/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.TitlePane");
dojo.require("dijit.TitlePane");
dojo.require("dijit.layout.ContentPane");


dojo.declare(
	// class
	"cosmos.widget.TitlePane",
	// superclass	
	[dijit.TitlePane],
	
	// member variables/functions
	{
		open:false,
		expand:false,
		expandIcon:dojo.moduleUrl("cosmos.widget", "img/minus.gif"),
		collapseIcon:dojo.moduleUrl("cosmos.widget", "img/plus.gif"),
		postCreate:function () {
			cosmos.widget.TitlePane.superclass.postCreate.apply(this, arguments);
			if (this.indent)
				this.domNode.setAttribute("style", "margin-left:"+this.indent+"px");
		    this.setTitle(this.label);
		},		
		_onTitleClick:function () {
			cosmos.widget.TitlePane.superclass._onTitleClick.apply(this, arguments);			
		    this.setTitle(this.label);
		}, setTitle:function (label) {
		    var iconLabel = label;
		    if (this.open)
				iconLabel = "<div><img src=\""+this.expandIcon+"\" alt=\"\" />"+label+"</div>";
			else 
				iconLabel = "<div><img src=\""+this.collapseIcon+"\" alt=\"\" />"+label+"</div>";
			cosmos.widget.TitlePane.superclass.setTitle.apply(this, [iconLabel]);
		}		
	}
);
