/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.actions;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.operations.ISMLValidateOperation;
import org.eclipse.cosmos.rm.smlif.internal.actions.AbstractAction;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLRepositoryManager;
import org.eclipse.cosmos.rm.validation.internal.SMLActivator;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;

public class ValidateResourceAction
extends AbstractAction {
    private Map attributes = new Hashtable();

    public ValidateResourceAction() {
        this.attributes.put("attribute.environment", "value.environment.eclipse");
    }

    public void run(IAction action) {
        if (this.noValidSelection()) {
            return;
        }
        SMLValidationJob validate = new SMLValidationJob(SMLMessages.validationJob);
        validate.setUser(true);
        validate.schedule();
    }

    private boolean runValidation(ISMLValidateOperation validationOperation, String inputType, String input) throws RepositoryOperationException {
        this.attributes.put("validation.input.type", inputType);
        this.attributes.put("validation.instance", input);
        validationOperation.setArguments(new Object[]{this.attributes});
        validationOperation.run();
        return validationOperation.getStatus();
    }

    private class SMLValidationJob
    extends Job {
        public SMLValidationJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            boolean status;
            try {
                ISMLRepository repository = SMLRepositoryManager.getRepository(ValidateResourceAction.this.getRootDirectory());
                ISMLValidateOperation validationOperation = (ISMLValidateOperation)repository.getOperation("org.eclipse.cosmos.rm.repository.provisional.operations.ISMLValidateOperation");
                List smlifDocuments = ValidateResourceAction.this.getSmlifdocuments();
                ValidateResourceAction.this.attributes.put("validation.progress", monitor);
                ValidateResourceAction.this.attributes.put("validation.input.type", "value.sml.if");
                status = true;
                try {
                    int smlifDocumentsCount = smlifDocuments.size();
                    monitor.beginTask(SMLMessages.validationTask, 7 * (smlifDocumentsCount + 1));
                    int i = 0;
                    while (i < smlifDocumentsCount) {
                        status = ValidateResourceAction.this.runValidation(validationOperation, "value.sml.if", (String)smlifDocuments.get(i)) && status;
                        ++i;
                    }
                    if (ValidateResourceAction.this.getSmlModelUnitPaths().length() > 0) {
                        status = ValidateResourceAction.this.runValidation(validationOperation, "value.sml.unit", ValidateResourceAction.this.getSmlModelUnitPaths()) && status;
                    } else {
                        monitor.worked(7);
                    }
                }
                catch (RepositoryOperationException roe) {
                    SMLValidatorUtil.openErrorWithDetail((String)SMLMessages.errorValidationTitle, (String)SMLMessages.errorValidation, (Throwable)roe);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    Object var8_12 = null;
                    monitor.done();
                    return iStatus;
                }
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                monitor.done();
                throw throwable;
            }
            IWorkbench workbench = SMLActivator.getDefault().getWorkbench();
            if (status) {
                workbench.getDisplay().syncExec(new Runnable(this){
                    final /* synthetic */ SMLValidationJob this$1;
                    {
                        this.this$1 = sMLValidationJob;
                    }

                    public void run() {
                        MessageDialog.openInformation((Shell)SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.confirmNoErrorTitle, (String)SMLMessages.confirmNoError);
                    }
                });
            } else {
                workbench.getDisplay().syncExec(new Runnable(this, workbench){
                    final /* synthetic */ SMLValidationJob this$1;
                    private final /* synthetic */ IWorkbench val$workbench;
                    {
                        this.this$1 = sMLValidationJob;
                        this.val$workbench = iWorkbench;
                    }

                    public void run() {
                        try {
                            this.val$workbench.getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView");
                        }
                        catch (PartInitException partInitException) {
                            MessageDialog.openError((Shell)SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.failedValidationTitle, (String)SMLMessages.failedValidation);
                        }
                    }
                });
            }
            IStatus iStatus = Status.OK_STATUS;
            Object var8_13 = null;
            monitor.done();
            return iStatus;
        }
    }
}

