/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.common;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.validation.internal.SMLActivator;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.FileOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationMessage;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class MarkerOutput
extends AbstractValidationOutput {
    public static final String SML_MARKER_ID = "org.eclipse.cosmos.rm.validation.smlMarker";
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private Map settings;
    private FileOutput backupOutput;
    private boolean errorReported = false;

    public void initialize(Map attributes) {
        super.initialize(attributes);
        this.settings = attributes;
        try {
            String files = (String)attributes.get("validation.instance");
            if (files == null) {
                return;
            }
            StringTokenizer tokens = new StringTokenizer(files, ",");
            while (tokens.hasMoreTokens()) {
                Path path = new Path(tokens.nextToken());
                IFile res = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                if (res == null || !res.exists()) {
                    res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                }
                if (res == null || !res.exists()) continue;
                IMarker[] markers = res.findMarkers(SML_MARKER_ID, false, 0);
                ResourcesPlugin.getWorkspace().deleteMarkers(markers);
            }
        }
        catch (Exception e) {
            SMLActivator.logError(e);
            e.printStackTrace();
        }
    }

    public void writeMessageToSource(IValidationMessage validationMessage) {
        try {
            int columnNumber;
            Object resourceAttribute = validationMessage.getAttribute("attribute.resource");
            IWorkspaceRoot file = null;
            if (resourceAttribute instanceof String) {
                Path path = new Path((String)resourceAttribute);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                file = root.getFileForLocation((IPath)path);
                if (file == null || !file.exists()) {
                    file = root.getFile((IPath)path);
                }
                if (file == null || !file.exists()) {
                    file = null;
                }
            }
            IWorkspaceRoot resource = file == null ? (this.getAssociatedResource() == null || !(this.getAssociatedResource().getResource() instanceof IResource) ? this.workspaceRoot : (IResource)this.getAssociatedResource().getResource()) : file;
            int severity = validationMessage.getAttribute("attribute.severity", 0);
            IMarker marker = resource.createMarker(SML_MARKER_ID);
            marker.setAttribute("message", (Object)validationMessage.getAttribute("attribute.message", ""));
            marker.setAttribute("severity", severity == 2 ? 2 : (severity == 1 ? 1 : 0));
            int lineNumber = validationMessage.getAttribute("attribute.line.number", -1);
            if (lineNumber > -1) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            if ((columnNumber = validationMessage.getAttribute("attribute.column.number", -1)) > -1) {
                marker.setAttribute("charStart", columnNumber);
            }
        }
        catch (CoreException coreException) {
            if (this.backupOutput == null) {
                this.backupOutput = new FileOutput();
                this.backupOutput.initialize(this.settings);
            }
            if (!this.errorReported) {
                this.errorReported = true;
                MessageDialog.openError((Shell)SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.commonError, (String)NLS.bind((String)SMLMessages.errorMarkerOutput, (Object)this.backupOutput.getFilePath()));
            }
            this.backupOutput.reportMessage(validationMessage);
        }
    }
}

