/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common.spi.impl;

import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataQueryService;
import org.eclipse.cosmos.dc.common.api.IDataResponseService;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.IDataSourceService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.spi.impl.ContextDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.DescriptorNode;
import org.eclipse.cosmos.dc.common.spi.impl.FilterDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.QueryDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.ResponseDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.SinkDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.SourceDescriptor;
import org.eclipse.cosmos.dc.common.spi.impl.TransformDescriptor;
import org.eclipse.cosmos.dc.mgmt.api.OperationalStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractCollectionContext
implements IDataCollectionContext,
OperationalStatus {
    protected ContextDescriptor rootDescriptor;
    public static final int AVAILABLE = 0;
    public static final int UNAVAILABLE = 1;
    public static final int PARTIALLY_AVAILABLE = 2;
    public static final int UNKNOWN = 3;
    private int status = 1;
    private boolean valid = true;
    public static final int NOT_WIRED = 0;
    public static final int FULLY_WIRED = 1;
    public static final int PARTIALLY_WIRED = 2;
    private int wired = 0;

    public void load(Document doc) throws Exception {
        Element[] children;
        this.rootDescriptor = this.processContext(doc.getDocumentElement());
        Element[] elementArray = children = XmlUtils.getAllElements((Node)doc.getDocumentElement());
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            Element child = elementArray[n];
            if (child.getNodeName().endsWith(":binding")) {
                this.processBinding(this.rootDescriptor, child);
            } else if ("http://www.eclipse.org/xmlns/cosmos/1.0".equals(child.getNamespaceURI())) {
                this.processChild(this.rootDescriptor, child);
            } else {
                throw new Exception("Unexpected Node type" + child.getNodeName());
            }
            ++n;
        }
    }

    protected ContextDescriptor processContext(Element context) throws Exception {
        ContextDescriptor descriptor = new ContextDescriptor();
        String name = XmlUtils.getAttribute((Element)context, (QName)IDataCollectionContext.NAME_QNAME);
        String direction = XmlUtils.getAttribute((Element)context, (QName)IDataCollectionContext.DIRECTION_QNAME);
        descriptor.setName(name);
        if ("in".equals(direction)) {
            descriptor.setDirection(1);
        } else if ("out".equals(direction)) {
            descriptor.setDirection(2);
        } else {
            throw new Exception("Invalid direction");
        }
        return descriptor;
    }

    protected SourceDescriptor processSource(Element context) throws Exception {
        SourceDescriptor descriptor = new SourceDescriptor();
        String factoryName = XmlUtils.getAttribute((Element)context, (QName)IDataSourceService.FACTORY_QNAME);
        String optimizable = XmlUtils.getAttribute((Element)context, (QName)IDataCollectionContext.OPTIMIZABLE_QNAME);
        descriptor.setFactoryName(factoryName);
        if ("true".equals(optimizable)) {
            descriptor.setOptimizable(true);
        } else if ("false".equals(optimizable)) {
            descriptor.setOptimizable(false);
        } else {
            throw new Exception("Invalid value for Optimizable");
        }
        return descriptor;
    }

    protected QueryDescriptor processQuery(Element context) throws Exception {
        QueryDescriptor descriptor = new QueryDescriptor();
        String factoryName = XmlUtils.getAttribute((Element)context, (QName)IDataSourceService.FACTORY_QNAME);
        String optimizable = XmlUtils.getAttribute((Element)context, (QName)IDataCollectionContext.OPTIMIZABLE_QNAME);
        descriptor.setFactoryName(factoryName);
        if ("true".equals(optimizable)) {
            descriptor.setOptimizable(true);
        } else if ("false".equals(optimizable)) {
            descriptor.setOptimizable(false);
        } else {
            throw new Exception("Invalid value for Optimizable");
        }
        return descriptor;
    }

    protected SinkDescriptor processSink(Element context) throws Exception {
        SinkDescriptor descriptor = new SinkDescriptor();
        String factoryName = XmlUtils.getAttribute((Element)context, (QName)IDataSourceService.FACTORY_QNAME);
        String optimizable = XmlUtils.getAttribute((Element)context, (QName)IDataCollectionContext.OPTIMIZABLE_QNAME);
        descriptor.setFactoryName(factoryName);
        if ("true".equals(optimizable)) {
            descriptor.setOptimizable(true);
        } else if ("false".equals(optimizable)) {
            descriptor.setOptimizable(false);
        } else {
            throw new Exception("Invalid value for Optimizable");
        }
        return descriptor;
    }

    protected FilterDescriptor processFilter(Element context) throws Exception {
        FilterDescriptor descriptor = new FilterDescriptor();
        String factoryName = XmlUtils.getAttribute((Element)context, (QName)IDataSourceService.FACTORY_QNAME);
        String optimizable = XmlUtils.getAttribute((Element)context, (QName)IDataCollectionContext.OPTIMIZABLE_QNAME);
        descriptor.setFactoryName(factoryName);
        if ("true".equals(optimizable)) {
            descriptor.setOptimizable(true);
        } else if ("false".equals(optimizable)) {
            descriptor.setOptimizable(false);
        } else {
            throw new Exception("Invalid value for Optimizable");
        }
        return descriptor;
    }

    protected TransformDescriptor processTransform(Element context) throws Exception {
        TransformDescriptor descriptor = new TransformDescriptor();
        String factoryName = XmlUtils.getAttribute((Element)context, (QName)IDataSourceService.FACTORY_QNAME);
        String optimizable = XmlUtils.getAttribute((Element)context, (QName)IDataCollectionContext.OPTIMIZABLE_QNAME);
        descriptor.setFactoryName(factoryName);
        if ("true".equals(optimizable)) {
            descriptor.setOptimizable(true);
        } else if ("false".equals(optimizable)) {
            descriptor.setOptimizable(false);
        } else {
            throw new Exception("Invalid value for Optimizable");
        }
        return descriptor;
    }

    protected ResponseDescriptor processResponse(Element context) throws Exception {
        ResponseDescriptor descriptor = new ResponseDescriptor();
        String factoryName = XmlUtils.getAttribute((Element)context, (QName)IDataSourceService.FACTORY_QNAME);
        String optimizable = XmlUtils.getAttribute((Element)context, (QName)IDataCollectionContext.OPTIMIZABLE_QNAME);
        descriptor.setFactoryName(factoryName);
        if ("true".equals(optimizable)) {
            descriptor.setOptimizable(true);
        } else if ("false".equals(optimizable)) {
            descriptor.setOptimizable(false);
        } else {
            throw new Exception("Invalid value for Optimizable");
        }
        return descriptor;
    }

    protected void processBinding(DescriptorNode bindee, Element binding) throws Exception {
        bindee.setBindingElement(binding);
    }

    protected DescriptorNode processChild(DescriptorNode parent, Element target) throws Exception {
        Element[] children;
        DescriptorNode descriptor = null;
        if (!"http://www.eclipse.org/xmlns/cosmos/1.0".equals(target.getNamespaceURI())) {
            throw new Exception("Invalid Namespace!");
        }
        if (IDataSourceService.SOURCE_QNAME.getLocalPart().equals(target.getNodeName())) {
            descriptor = this.processSource(target);
        } else if (IDataSinkService.SINK_QNAME.getLocalPart().equals(target.getNodeName())) {
            descriptor = this.processSink(target);
        } else if (IDataTransformService.TRANSFORM_QNAME.getLocalPart().equals(target.getNodeName())) {
            descriptor = this.processTransform(target);
        } else if (IDataFilterService.FILTER_QNAME.getLocalPart().equals(target.getNodeName())) {
            descriptor = this.processFilter(target);
        } else if (IDataQueryService.QUERY_QNAME.getLocalPart().equals(target.getNodeName())) {
            descriptor = this.processQuery(target);
        } else if (IDataResponseService.RESPONSE_QNAME.getLocalPart().equals(target.getNodeName())) {
            descriptor = this.processResponse(target);
        }
        parent.addChild(descriptor);
        Element[] elementArray = children = XmlUtils.getAllElements((Node)target);
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            Element child = elementArray[n];
            if (child.getNodeName().endsWith(":binding")) {
                this.processBinding(descriptor, child);
            } else if ("http://www.eclipse.org/xmlns/cosmos/1.0".equals(child.getNamespaceURI())) {
                this.processChild(descriptor, child);
            } else {
                throw new Exception("Unexpected Node type" + child.getNodeName());
            }
            ++n;
        }
        return descriptor;
    }

    public abstract void materialize() throws Exception;

    public String getName() {
        return this.rootDescriptor.getName();
    }

    public String getOperationalStatus() {
        switch (this.status) {
            case 0: {
                return "Available";
            }
            case 1: {
                return "Unavailable";
            }
            case 2: {
                return "PartiallyAvailable";
            }
        }
        return "Unknown";
    }

    protected void setOperationalStatus(int status) {
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.status = status;
                return;
            }
        }
        throw new IllegalArgumentException("Invalid value for OperationalStatus");
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isWired() {
        return this.wired == 2 || this.wired == 1;
    }

    public boolean isFullyWired() {
        return this.wired == 1;
    }

    protected void setWired(int wired) {
        switch (wired) {
            case 0: 
            case 1: 
            case 2: {
                this.wired = wired;
                return;
            }
        }
        throw new IllegalArgumentException("Invalid value for Wired");
    }
}

