/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath.axes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FXPObject;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.LastToken;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.EExpressionFactory;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.axes.EPredicatedNodeTest;

public class EAxesWalker
extends EPredicatedNodeTest {
    private AxesWalker node;
    protected EAxesWalker nextEWalker;
    protected EAxesWalker prevEWalker;
    protected boolean recursiveSearch = false;
    private Object[] objArr = null;

    public IExpression instance(Expression e) {
        return new EAxesWalker((AxesWalker)e);
    }

    public EAxesWalker(AxesWalker node) {
        super((PredicatedNodeTest)node);
        this.node = node;
    }

    public void printGraph(int level) {
        String indent = this.indent(level);
        System.out.print(String.valueOf(indent) + "AXIS = " + this.getAxis(this.getAxis()));
        super.printGraph(level);
        EAxesWalker next = this.getNextEWalker();
        if (next != null) {
            next.printGraph(++level);
        }
    }

    private Object[] shrink() {
        int nonNull = 0;
        if (this.objArr == null) {
            return new Object[0];
        }
        int i = 0;
        while (i < this.objArr.length) {
            if (this.objArr[i] != null) {
                ++nonNull;
            }
            ++i;
        }
        Object[] res = new Object[nonNull];
        int i2 = this.objArr.length - 1;
        while (i2 >= 0) {
            if (this.objArr[i2] != null) {
                res[--nonNull] = this.objArr[i2];
            }
            --i2;
        }
        return res;
    }

    public EAxesWalker getNextEWalker() {
        if (this.nextEWalker == null) {
            this.nextEWalker = (EAxesWalker)EExpressionFactory.INSTANCE.createEExprNode((Expression)this.getNextWalker());
        }
        return this.nextEWalker;
    }

    public EAxesWalker getPrevEWalker() {
        if (this.prevEWalker == null) {
            this.prevEWalker = (EAxesWalker)EExpressionFactory.INSTANCE.createEExprNode((Expression)this.getPrevWalker());
        }
        return this.prevEWalker;
    }

    public void setNextEWalker(EAxesWalker walker) {
        this.nextEWalker = walker;
        if (walker != null) {
            this.setNextWalker(walker.getNextWalker());
        }
    }

    public void setPrevEWalker(EAxesWalker walker) {
        this.prevEWalker = walker;
        this.setPrevWalker(walker.getPrevWalker());
    }

    public boolean isRecursiveSearch() {
        return this.recursiveSearch;
    }

    public void setRecursiveSearch(boolean b) {
        this.recursiveSearch = b;
    }

    public void linkParent(IExpression parent) {
        super.linkParent(parent);
        EAxesWalker nextW = this.getNextEWalker();
        if (nextW != null) {
            nextW.linkParent(this);
        }
        int count = this.node.getPredicateCount();
        IExpression[] ePreds = this.getEPredicates();
        int i = 0;
        while (i < count) {
            ePreds[i].linkParent(this);
            ++i;
        }
    }

    public Object[] execute(FastXPathContext context) throws TransformerException, ExpressionEvaluationException {
        Object[] resultObjectArray;
        String name = this.getLocalName();
        int axis = this.getAxis();
        EAxesWalker nextW = this.getNextEWalker();
        if (name.equals("") && nextW != null) {
            if (axis == 19) {
                resultObjectArray = nextW.execute(context.createFreshContext());
            } else {
                switch (axis) {
                    case 5: {
                        nextW.setRecursiveSearch(true);
                        break;
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        throw new ExpressionEvaluationException();
                    }
                }
                resultObjectArray = nextW.execute(context);
            }
        } else {
            this.objArr = new Object[0];
            ArrayList<Object> resArr = null;
            int queryType = this.recursiveSearch ? 2 : 0;
            switch (axis) {
                case 0: {
                    this.objArr = context.getAncestor(name, queryType);
                    break;
                }
                case 1: {
                    this.objArr = context.getAncestorOrSelf(name, queryType);
                    break;
                }
                case 4: {
                    this.objArr = context.getDescendant(name, queryType);
                    break;
                }
                case 5: {
                    this.objArr = context.getDescendantOrSelf(name, queryType);
                    break;
                }
                case 17: 
                case 18: {
                    throw new ExpressionEvaluationException("Unable to process this chain of expression nodes");
                }
                case 6: {
                    this.objArr = context.getFollowing(name, 2);
                    break;
                }
                case 11: {
                    this.objArr = context.getPreceding(name);
                    break;
                }
                case 15: {
                    this.objArr = context.getPrecedingSibling(name, queryType);
                    break;
                }
                case 7: {
                    this.objArr = context.getFollowing(name, queryType);
                    break;
                }
                case 12: {
                    this.objArr = context.getPrecedingSibling(name, queryType);
                    break;
                }
                case 13: {
                    this.objArr = context.getSelf(name);
                    break;
                }
                case 3: {
                    if (this.recursiveSearch) {
                        this.objArr = context.getDescendantOrSelf(name, queryType);
                        break;
                    }
                    this.objArr = context.getChild(name, queryType);
                    break;
                }
                case 2: {
                    if (this.recursiveSearch) {
                        this.objArr = context.getAttribute(name, 4);
                        break;
                    }
                    this.objArr = context.getAttribute(name, 3);
                    break;
                }
                case 10: {
                    this.objArr = context.getParent();
                    break;
                }
            }
            this.processPredicates(context);
            if (nextW == null) {
                resultObjectArray = this.shrink();
            } else {
                resArr = new ArrayList<Object>();
                int i = 0;
                while (i < this.objArr.length) {
                    if (this.objArr[i] != null) {
                        Object[] arr = nextW.execute(context.createContext(this.objArr[i]));
                        int j = 0;
                        while (j < arr.length) {
                            resArr.add(arr[j]);
                            ++j;
                        }
                    }
                    ++i;
                }
                resultObjectArray = resArr.toArray();
            }
        }
        return resultObjectArray;
    }

    public void compile(ICompilerContext compilationContext) throws CodeGenerationError {
        compilationContext.in(this);
        String name = this.getLocalName();
        int axis = this.getAxis();
        EAxesWalker nextW = this.getNextEWalker();
        switch (axis) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                throw new CodeGenerationError("Cannot generate code for Axis = " + this.getAxis(axis));
            }
        }
        if (name.equals("") && nextW != null) {
            nextW.compile(compilationContext);
        } else {
            compilationContext.addName(name);
            this.compilePredicates(compilationContext);
            if (nextW != null) {
                nextW.compile(compilationContext);
            }
        }
        compilationContext.out();
    }

    private void compilePredicates(ICompilerContext compilationContext) throws CodeGenerationError {
        int count = this.node.getPredicateCount();
        if (count == 0) {
            return;
        }
        compilationContext.enterPredicate();
        IExpression[] ePreds = this.getEPredicates();
        int j = 0;
        while (j < count) {
            compilationContext.append(" ( ");
            ePreds[j].compile(compilationContext);
            compilationContext.append(" ) ");
            ++j;
        }
        compilationContext.exitPredicate();
        if (compilationContext.getPredicateDepth() > 0 && this.getNextEWalker() != null) {
            compilationContext.append(" && ");
        }
    }

    private void processPredicates(FastXPathContext context) throws TransformerException, ExpressionEvaluationException {
        int count = this.node.getPredicateCount();
        if (count == 0) {
            return;
        }
        boolean oneOfThePredicatesIsFuncLast = false;
        IExpression[] ePreds = this.getEPredicates();
        int objArrLen = this.objArr.length;
        this.m_position = 0;
        while (this.m_position < objArrLen) {
            int j = 0;
            while (j < count) {
                if (this.objArr[this.m_position] == null) break;
                Object[] resultArr = ePreds[j].execute(context.createContext(this.objArr[this.m_position]));
                FXPObject fxpObject = (FXPObject)this.objArr[this.m_position];
                if (resultArr.length == 0 || resultArr[0] instanceof XBoolean && !((XBoolean)resultArr[0]).bool() || resultArr[0] instanceof Boolean && (Boolean)resultArr[0] == false || resultArr[0] instanceof XNumber && ((XNumber)resultArr[0]).num() != (double)fxpObject.getPosition() || resultArr[0] instanceof Integer && (Integer)resultArr[0] - 1 != this.m_position || resultArr[0] instanceof String && ((String)resultArr[0]).length() == 0) {
                    this.objArr[this.m_position] = null;
                    break;
                }
                if (resultArr[0].equals(LastToken.INSTANCE)) {
                    this.processLastToken();
                    oneOfThePredicatesIsFuncLast = true;
                }
                ++j;
            }
            if (oneOfThePredicatesIsFuncLast) {
                return;
            }
            ++this.m_position;
        }
    }

    private void processLastToken() {
        ArrayList<ObjectPositionTuple> list = new ArrayList<ObjectPositionTuple>();
        int i = 0;
        while (i < this.objArr.length) {
            Object obj = this.objArr[i];
            int posAsNumber = 0;
            int magnitude = 1;
            while (obj instanceof FXPObject) {
                posAsNumber += ((FXPObject)obj).getPosition() * magnitude;
                obj = ((FXPObject)obj).getParent();
                magnitude *= 10;
            }
            list.add(new ObjectPositionTuple(this.objArr[i], posAsNumber));
            ++i;
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                ObjectPositionTuple lhs = (ObjectPositionTuple)o1;
                ObjectPositionTuple rhs = (ObjectPositionTuple)o2;
                return lhs.position - rhs.position;
            }
        });
        int[] iArray = new int[list.size()];
        int indx = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ObjectPositionTuple tuple = (ObjectPositionTuple)iter.next();
            iArray[indx++] = tuple.position;
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        resultList.add(((ObjectPositionTuple)list.get((int)(list.size() - 1))).obj);
        int i2 = 0;
        while (i2 < iArray.length - 1) {
            int subtraction = iArray[i2 + 1] - iArray[i2];
            if (subtraction != 1) {
                resultList.add(((ObjectPositionTuple)list.get((int)i2)).obj);
            }
            ++i2;
        }
        this.objArr = resultList.toArray();
    }

    public int getAxis() {
        return this.node.getAxis();
    }

    private AxesWalker getNextWalker() {
        return this.node.getNextWalker();
    }

    private AxesWalker getPrevWalker() {
        return this.node.getPrevWalker();
    }

    private void setNextWalker(AxesWalker walker) {
        this.node.setNextWalker(walker);
    }

    private void setPrevWalker(AxesWalker walker) {
        this.node.setPrevWalker(walker);
    }

    class ObjectPositionTuple {
        Object obj;
        int position;

        public ObjectPositionTuple(Object obj, int position) {
            this.obj = obj;
            this.position = position;
        }
    }
}

