/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath.axes;

import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XString;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.axes.EPredicatedNodeTest;

public class ELocPathIterator
extends EPredicatedNodeTest {
    private LocPathIterator node;

    public IExpression instance(Expression e) {
        return new ELocPathIterator((LocPathIterator)e);
    }

    public ELocPathIterator(LocPathIterator node) {
        super((PredicatedNodeTest)node);
        this.node = node;
    }

    public int getAxis() {
        return this.node.getAxis();
    }

    public void printGraph(int level) {
        super.printGraph(level);
    }

    protected Object[] locationSpecificQuery(FastXPathContext context, String name) throws ExpressionEvaluationException {
        return context.get(name);
    }

    public Object[] execute(FastXPathContext context) throws TransformerException, ExpressionEvaluationException {
        String name = this.getLocalName();
        Object[] arr = !name.equals("") ? this.locationSpecificQuery(context, name) : context.getSelf();
        Object[] resultArr = this.processEPredicates(arr, context);
        return resultArr;
    }

    protected Object[] processEPredicates(Object[] resultsPriorToPredicates, FastXPathContext context) throws TransformerException, ExpressionEvaluationException {
        int count = this.node.getPredicateCount();
        if (count > 0) {
            ArrayList<Object> vec = new ArrayList<Object>();
            int i = 0;
            while (i < resultsPriorToPredicates.length) {
                vec.add(resultsPriorToPredicates[i]);
                ++i;
            }
            this.m_position = 0;
            while (this.m_position < vec.size()) {
                int j = 0;
                while (j < count) {
                    Object[] resultArr = this.getEPredicates()[j].execute(context.createContext(vec.get(this.m_position)));
                    if (resultArr.length == 0 || resultArr[0] instanceof XBoolean && !((XBoolean)resultArr[0]).bool() || this.node.getPredicate(j) instanceof XString && !Boolean.valueOf((String)resultArr[0]).booleanValue()) {
                        vec.remove(this.m_position--);
                        break;
                    }
                    ++j;
                }
                ++this.m_position;
            }
            return vec.toArray();
        }
        return resultsPriorToPredicates;
    }

    public void compile(ICompilerContext compilationContext) throws CodeGenerationError {
        compilationContext.in(this);
        String name = this.getLocalName();
        if (!name.equals("")) {
            compilationContext.addName(name);
        }
        this.compilePredicates(compilationContext);
        compilationContext.out();
    }

    protected void compilePredicates(ICompilerContext compilationContext) throws CodeGenerationError {
        int count = this.node.getPredicateCount();
        if (count > 0) {
            compilationContext.enterPredicate();
            int j = 0;
            while (j < count) {
                compilationContext.append(" ( ");
                this.getEPredicates()[j].compile(compilationContext);
                compilationContext.append(" ) ");
                ++j;
            }
            compilationContext.exitPredicate();
        }
    }
}

