/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.local.registry;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.dc.common.spi.BindingService;
import org.eclipse.cosmos.dc.local.registry.DataBroker;
import org.eclipse.cosmos.dc.local.registry.DataBrokerBindingService;
import org.eclipse.cosmos.dc.local.registry.DataBrokerRegistration;
import org.eclipse.cosmos.dc.local.registry.ManagementDomainBindingService;
import org.eclipse.cosmos.dc.remote.wsdm.spec.DataBrokerClient;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Activator
implements BundleActivator {
    public void start(BundleContext context) throws Exception {
        Element[] children;
        Properties props = new Properties();
        DataBrokerBindingService bindingService = new DataBrokerBindingService();
        props.put("namespace", bindingService.getNamespace());
        context.registerService(new String[]{BindingService.class.getName()}, (Object)bindingService, (Dictionary)props);
        Properties domainProps = new Properties();
        ManagementDomainBindingService domainBindingService = new ManagementDomainBindingService();
        domainProps.put("namespace", domainBindingService.getNamespace());
        context.registerService(new String[]{BindingService.class.getName()}, (Object)domainBindingService, (Dictionary)domainProps);
        URL resource = this.getClass().getClassLoader().getResource(DataBroker.CONFIG_FILENAME);
        InputStream contextStream = resource.openStream();
        Document doc = XmlUtils.createDocument((InputStream)contextStream);
        Element config = doc.getDocumentElement();
        String domainAddress = null;
        String domainResid = null;
        Element[] elementArray = children = XmlUtils.getAllElements((Node)config);
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            Element child = elementArray[n];
            if (child.getNodeName().equalsIgnoreCase("domain")) {
                domainAddress = XmlUtils.getAttribute((Element)child, (QName)new QName("http://cosmos.eclipse.org/ManagementDomain/1.0", "epr"));
                domainResid = XmlUtils.getAttribute((Element)child, (QName)new QName("http://cosmos.eclipse.org/ManagementDomain/1.0", "resid"));
            }
            ++n;
        }
        EndpointReference myEPR = DataBrokerClient.getDataBrokerEPR((String)InetAddress.getLocalHost().getHostName(), (int)DataBroker.BROKER_PORT);
        DataBrokerRegistration dbreg = new DataBrokerRegistration(domainAddress, domainResid, myEPR.getAddress().toString(), "DataBrokerIdentifierValue", "Default", DataBroker.BROKER_CLASSIFICATION);
        Thread regThread = new Thread(dbreg);
        regThread.start();
    }

    public void stop(BundleContext context) throws Exception {
    }
}

