/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElementCollection;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IInstanceId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphElementCollection
implements IGraphElementCollection {
    private List<IGraphElement> elements;
    private boolean idList;

    public GraphElementCollection(boolean idList, List<IGraphElement> elements) {
        this.elements = elements;
        this.idList = idList;
    }

    public GraphElementCollection(boolean idList) {
        this.elements = new ArrayList<IGraphElement>();
        this.idList = idList;
    }

    protected List<IGraphElement> getCollection() {
        return this.elements;
    }

    public IGraphElement[] getElements() {
        return this.elements.toArray(new IGraphElement[this.elements.size()]);
    }

    public int getSize() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public void setElements(IGraphElement[] elements) {
        this.elements = new ArrayList<IGraphElement>();
        int i = 0;
        while (i < elements.length) {
            this.elements.add(elements[i]);
            ++i;
        }
    }

    protected abstract String getElementName(boolean var1);

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.beginTagFor((String)this.getElementName(this.idList))) + ICMDBfServicesConstants.nl);
        if (this.idList) {
            int i = 0;
            int elementCount = this.elements.size();
            while (i < elementCount) {
                IGraphElement element = this.elements.get(i);
                IInstanceId[] instanceIds = element.getInstanceIds();
                int j = 0;
                while (j < instanceIds.length) {
                    CMDBfServicesUtil.addIndent((StringWriter)writer, (int)(indent + 1));
                    writer.write(String.valueOf(CMDBfServicesUtil.beginTagFor((String)"instanceId")) + ICMDBfServicesConstants.nl);
                    CMDBfServicesUtil.addIndent((StringWriter)writer, (int)(indent + 2));
                    writer.write(String.valueOf(CMDBfServicesUtil.beginTagFor((String)"mdrId")) + instanceIds[j].getMdrId().toString() + CMDBfServicesUtil.endTagFor((String)"mdrId") + ICMDBfServicesConstants.nl);
                    CMDBfServicesUtil.addIndent((StringWriter)writer, (int)(indent + 2));
                    writer.write(String.valueOf(CMDBfServicesUtil.beginTagFor((String)"localId")) + instanceIds[j].getLocalId().toString() + CMDBfServicesUtil.endTagFor((String)"localId") + ICMDBfServicesConstants.nl);
                    CMDBfServicesUtil.addIndent((StringWriter)writer, (int)(indent + 1));
                    writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)"instanceId")) + ICMDBfServicesConstants.nl);
                    ++j;
                }
                ++i;
            }
        } else {
            CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), this.getCollection());
        }
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)this.getElementName(this.idList))) + ICMDBfServicesConstants.nl);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphElementCollection other = (GraphElementCollection)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }
}

