/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform;

import java.io.StringWriter;
import org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.CMDBfServicesArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.deregistration.transform.output.artifacts.DeregisterResponseArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.output.artifacts.IAlternateInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.output.artifacts.IInstanceResponse;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.output.artifacts.IResponse;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IInstanceId;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class OutputStreamHandler
extends DefaultHandler
implements ITransformerHandler {
    private IResponse response;
    private String currentElementData;
    private IInstanceId currentInstanceId;
    private IInstanceResponse currentInstanceResponse;
    private IAlternateInstanceId currentAlternateInstanceId;

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (!"http://schemas.cmdbf.org/0-9-5/datamodel".equals(uri)) {
            return;
        }
        if (this.getResponseElementName().equals(name)) {
            this.response = this.createResponse();
        } else if ("instanceResponse".equals(name)) {
            this.currentInstanceResponse = DeregisterResponseArtifactFactory.createInstanceResponse();
            this.response.addInstanceResponse(this.currentInstanceResponse);
        } else if ("accepted".equals(name)) {
            this.currentInstanceResponse.setAccepted(DeregisterResponseArtifactFactory.createAccepted());
        } else if ("declined".equals(name)) {
            this.currentInstanceResponse.setDeclined(DeregisterResponseArtifactFactory.createDeclined());
        } else if ("instanceId".equals(name)) {
            this.currentInstanceId = CMDBfServicesArtifactFactory.createInstanceId();
        } else if ("alternateInstanceId".equals(name)) {
            this.currentAlternateInstanceId = DeregisterResponseArtifactFactory.createAlternateInstanceId();
        }
    }

    protected abstract IResponse createResponse();

    protected abstract String getResponseElementName();

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!"http://schemas.cmdbf.org/0-9-5/datamodel".equals(uri)) {
            return;
        }
        if ("mdrId".equals(name)) {
            if (this.currentInstanceId != null) {
                this.currentInstanceId.setMdrId(this.currentElementData);
            } else if (this.currentAlternateInstanceId != null) {
                this.currentAlternateInstanceId.setMdrId(this.currentElementData);
            }
            this.currentElementData = null;
        } else if ("localId".equals(name)) {
            if (this.currentInstanceId != null) {
                this.currentInstanceId.setLocalId(this.currentElementData);
            } else if (this.currentAlternateInstanceId != null) {
                this.currentAlternateInstanceId.setLocalId(this.currentElementData);
            }
            this.currentElementData = null;
        } else if ("instanceId".equals(name)) {
            this.currentInstanceResponse.setInstanceId(this.currentInstanceId);
            this.currentInstanceId = null;
        } else if ("alternateInstanceId".equals(name)) {
            this.currentInstanceResponse.getAccepted().addAlternateInstanceId(this.currentAlternateInstanceId);
            this.currentAlternateInstanceId = null;
        } else if ("reason".equals(name)) {
            this.currentInstanceResponse.getDeclined().addReason(this.currentElementData);
            this.currentElementData = null;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempData = new String(ch, start, length).trim();
        if (this.currentElementData == null) {
            this.currentElementData = tempData;
        } else {
            StringWriter tempWriter = new StringWriter();
            tempWriter.write(tempData);
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
        }
    }

    public IResponse getResponse() {
        return this.response;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public IRootElement getResult() {
        return this.getResponse();
    }
}

