/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform;

import java.io.StringWriter;
import org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.CMDBfServicesArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.input.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.input.artifacts.IRegisterRequest;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.input.artifacts.IRelationship;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.input.artifacts.RegisterRequestArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IAdditionalRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IRecord;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RegistrationInputStreamHandler
extends DefaultHandler
implements ITransformerHandler {
    private IRegisterRequest request;
    private IGraphElement currentRegisterEntity;
    private String currentElementData;
    private IInstanceId currentInstanceId;
    private IRecord currentRecord;

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (!"http://schemas.cmdbf.org/0-9-5/datamodel".equals(uri)) {
            if (this.currentRecord == null) {
                return;
            }
            StringWriter tempWriter = new StringWriter();
            CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
            tempWriter.write(CMDBfServicesUtil.beginTagFor((String)name, (Attributes)attributes));
            tempWriter.write(ICMDBfServicesConstants.nl);
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
            if (!name.equals(localName)) {
                String prefix = name.split(":")[0];
                this.currentRecord.addNamespace(prefix, uri);
            }
            return;
        }
        if ("registerRequest".equals(localName)) {
            this.request = RegisterRequestArtifactFactory.createRegisterRequest();
        } else if ("item".equals(localName)) {
            this.currentRegisterEntity = RegisterRequestArtifactFactory.createItem();
            this.request.addItem((IItem)this.currentRegisterEntity);
        } else if ("relationship".equals(localName)) {
            this.currentRegisterEntity = RegisterRequestArtifactFactory.createRelationship();
            this.request.addRelationship((IRelationship)this.currentRegisterEntity);
        } else if ("sourceItem".equals(localName)) {
            this.currentInstanceId = CMDBfServicesArtifactFactory.createInstanceId();
        } else if ("targetItem".equals(localName)) {
            this.currentInstanceId = CMDBfServicesArtifactFactory.createInstanceId();
        } else if ("record".equals(localName)) {
            String recordId = attributes.getValue("recordId");
            this.currentRecord = CMDBfServicesArtifactFactory.createRecord((IGraphElement)this.currentRegisterEntity);
            this.currentRecord.setRecordId(recordId);
            this.currentRegisterEntity.addRecord(this.currentRecord);
            this.currentElementData = "";
        } else if ("instanceId".equals(localName)) {
            this.currentInstanceId = CMDBfServicesArtifactFactory.createInstanceId();
        } else if ("additionalRecordType".equals(localName)) {
            String namespace = attributes.getValue("namespace");
            String locName = attributes.getValue("localName");
            IAdditionalRecordType adt = CMDBfServicesArtifactFactory.createAdditionalRecordType((String)namespace, (String)locName);
            this.currentRegisterEntity.addAdditionalRecordType(adt);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!"http://schemas.cmdbf.org/0-9-5/datamodel".equals(uri)) {
            if (this.currentRecord != null) {
                StringWriter tempWriter = new StringWriter();
                CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
                tempWriter.write(CMDBfServicesUtil.endTagFor((String)name));
                tempWriter.write(ICMDBfServicesConstants.nl);
                this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
            }
            return;
        }
        if ("mdrId".equals(localName)) {
            if (this.currentInstanceId != null) {
                this.currentInstanceId.setMdrId(this.currentElementData);
            } else {
                this.request.setMdrId(CMDBfServicesUtil.createURI((String)this.currentElementData));
            }
            this.currentElementData = null;
        } else if ("localId".equals(localName)) {
            this.currentInstanceId.setLocalId(this.currentElementData);
            this.currentElementData = null;
        } else if ("instanceId".equals(localName)) {
            this.currentRegisterEntity.addInstanceId(this.currentInstanceId);
            this.currentInstanceId = null;
        } else if ("sourceItem".equals(localName)) {
            ((IRelationship)this.currentRegisterEntity).setSourceId(this.currentInstanceId);
            this.currentInstanceId = null;
        } else if ("targetItem".equals(localName)) {
            ((IRelationship)this.currentRegisterEntity).setTargetId(this.currentInstanceId);
            this.currentInstanceId = null;
        } else if ("record".equals(localName)) {
            this.currentRecord.setValueFromString(this.currentElementData);
            this.currentElementData = null;
            this.currentRecord = null;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempData = new String(ch, start, length).trim();
        if (this.currentElementData == null) {
            this.currentElementData = tempData;
        } else {
            StringWriter tempWriter = new StringWriter();
            if (this.currentRecord != null) {
                CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
            }
            tempWriter.write(tempData);
            if (this.currentRecord != null) {
                tempWriter.write(10);
            }
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
        }
    }

    public IRegisterRequest getRequest() {
        return this.request;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public IRootElement getResult() {
        return this.getRequest();
    }
}

