/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mgmt.wsdm.osgi;

import java.net.InetAddress;
import java.net.URI;
import java.util.Hashtable;
import org.apache.muse.core.platform.osgi.ResourceManagementProvider;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.sg.remote.ServiceGroupClient;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.api.IDataQueryResult;
import org.eclipse.cosmos.dc.common.api.IDataQueryService;
import org.eclipse.cosmos.dc.common.spi.RuntimeHost;
import org.eclipse.cosmos.dc.mgmt.common.StatusChangeListener;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.WSDMBindingFactory;
import org.eclipse.cosmos.dc.mgmt.serializer.SPISerializer;
import org.eclipse.cosmos.dc.mgmt.serializer.SpecSerializer;
import org.eclipse.cosmos.dc.spec.types.StatisticalTuple;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class WSDMBindingService
extends WSDMBindingFactory {
    private BundleContext ctx;

    protected void activate(ComponentContext ctxt) {
        this.ctx = ctxt.getBundleContext();
        this.start(this.ctx);
    }

    protected void deactivate(ComponentContext ctxt) {
        BundleContext context = ctxt.getBundleContext();
        this.stop(context);
    }

    private void start(BundleContext ctxBundle) {
        ServiceReference managementServiceRef = ctxBundle.getServiceReference(ResourceManagementProvider.class.getName());
        ResourceManagementProvider managementProvider = (ResourceManagementProvider)ctxBundle.getService(managementServiceRef);
        WSDMBindingFactory.getDefault().setWSDMProvider(managementProvider);
        WSDMBindingFactory.getDefault().registerSerializer(RuntimeHost.class, SPISerializer.getRuntimeHostSerializer());
        WSDMBindingFactory.getDefault().registerSerializer(IDataCollectionContext.class, SPISerializer.getContextSerializer());
        WSDMBindingFactory.getDefault().registerSerializer(IDataQueryService.class, SPISerializer.getQueryRootSerializer());
        WSDMBindingFactory.getDefault().registerSerializer(IDataQueryResult.class, SPISerializer.getQueryResultSerializer());
        WSDMBindingFactory.getDefault().registerSerializer(StatisticalTuple.class, SpecSerializer.getStatisticalTupleSerializer());
        Thread museThread = new Thread(new Runnable(){

            public void run() {
                WSDMBindingService.this.warmUpMuse();
            }
        });
        museThread.start();
        try {
            museThread.join();
        }
        catch (InterruptedException interruptedException) {}
        Hashtable<String, String> providerProperties = new Hashtable<String, String>();
        providerProperties.put("Provider", "WSDM");
    }

    private void stop(BundleContext ctxBundle) {
    }

    private void warmUpMuse() {
        try {
            try {
                String webAppRoot = "/cosmos";
                String contextPath = String.valueOf(webAppRoot) + "/services/Relationships";
                String port = System.getProperty("org.osgi.service.http.port", "80");
                String ip = InetAddress.getLocalHost().getHostAddress();
                StringBuffer address = new StringBuffer();
                address.append("http://");
                address.append(ip);
                address.append(':');
                address.append(port);
                if (contextPath.charAt(0) != '/') {
                    address.append('/');
                }
                address.append(contextPath);
                URI addressURI = URI.create(address.toString());
                EndpointReference epr = new EndpointReference(addressURI);
                ServiceGroupClient sg = new ServiceGroupClient(epr);
                System.out.println("Pinging Muse to initialize the endpoint...");
                sg.getResourcePropertyDocument();
                System.out.println("Waiting 10 seconds while simulation creates WS-resources...");
            }
            catch (SoapFault s) {
                if (!WsaConstants.DESTINATION_UNREACHABLE_FAULT_QNAME.equals(s.getSubCode())) {
                    s.printStackTrace();
                }
                WSDMBindingFactory.getDefault().statusChanged(WSDMBindingFactory.getDefault(), StatusChangeListener.STATUS.AVAILABLE);
            }
            catch (Throwable t) {
                t.printStackTrace();
                WSDMBindingFactory.getDefault().statusChanged(WSDMBindingFactory.getDefault(), StatusChangeListener.STATUS.AVAILABLE);
            }
        }
        finally {
            WSDMBindingFactory.getDefault().statusChanged(WSDMBindingFactory.getDefault(), StatusChangeListener.STATUS.AVAILABLE);
        }
    }
}

