/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.provisional.common;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IItemNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.INotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.INotificationHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IRelationshipNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.exceptions.UnsupportedHandlerException;

public class AbstractNotificationHandlerFactory
implements INotificationHandlerFactory {
    private static final int ITEM = 0;
    private static final int RELATIONSHIP = 1;
    private Map<Integer, Map<Integer, INotificationHandler>> cachedHandlers = new Hashtable<Integer, Map<Integer, INotificationHandler>>();

    public IItemNotificationHandler createItemHandler(int type) throws UnsupportedHandlerException {
        return (IItemNotificationHandler)this.createNotificationHanlder(0, type);
    }

    public IRelationshipNotificationHandler createRelationshipHandler(int type) throws UnsupportedHandlerException {
        return (IRelationshipNotificationHandler)this.createNotificationHanlder(1, type);
    }

    private INotificationHandler createNotificationHanlder(int entityType, int notificationType) throws UnsupportedHandlerException {
        if (this.isCachingSupported()) {
            INotificationHandler handler;
            Map<Integer, INotificationHandler> nestedMap = this.cachedHandlers.get(entityType);
            INotificationHandler iNotificationHandler = handler = nestedMap == null ? null : nestedMap.get(notificationType);
            if (handler != null) {
                return handler;
            }
        }
        INotificationHandler handler = null;
        block0 : switch (entityType) {
            case 0: {
                switch (notificationType) {
                    case 0: {
                        handler = this.createRegistrationItemHandler();
                        break;
                    }
                    case 1: {
                        handler = this.createDeregistrationItemHandler();
                    }
                }
                break;
            }
            case 1: {
                switch (notificationType) {
                    case 0: {
                        handler = this.createRegistrationRelationshipHandler();
                        break block0;
                    }
                    case 1: {
                        handler = this.createDeregistrationRelationshipHandler();
                    }
                }
            }
        }
        if (handler != null && this.isCachingSupported()) {
            Map<Integer, INotificationHandler> nestedMap = this.cachedHandlers.get(entityType);
            if (nestedMap == null) {
                nestedMap = new Hashtable<Integer, INotificationHandler>();
                this.cachedHandlers.put(entityType, nestedMap);
            }
            nestedMap.put(notificationType, handler);
        }
        return handler;
    }

    protected IItemNotificationHandler createRegistrationItemHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unsupported registration handler");
    }

    protected IRelationshipNotificationHandler createRegistrationRelationshipHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unsupported registration handler");
    }

    protected IItemNotificationHandler createDeregistrationItemHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unsupported deregistration handler");
    }

    protected IRelationshipNotificationHandler createDeregistrationRelationshipHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unsupported deregistration handler");
    }

    protected boolean isCachingSupported() {
        return true;
    }
}

