/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts;

import java.io.StringWriter;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IOperator;

public class Operator
implements IOperator {
    private Boolean negate = null;
    protected int type;
    private Boolean caseSensitive = null;
    private Object value;

    public Operator(int type) {
        this.type = type;
    }

    public boolean isNegated() {
        if (this.primIsNegated() == null) {
            return false;
        }
        return this.primIsNegated();
    }

    private Boolean primIsNegated() {
        return this.negate;
    }

    public void setNegate(boolean negate) {
        this.negate = negate;
    }

    public int getType() {
        return this.type;
    }

    public boolean isCaseSensitive() {
        if (this.primIsCaseSensitive() == null) {
            return true;
        }
        return this.primIsCaseSensitive();
    }

    private Boolean primIsCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        String elementName = this.getElementName();
        writer.write("<" + elementName);
        if (this.primIsCaseSensitive() != null) {
            writer.write(" ");
            CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"caseSensitive", (String)this.primIsCaseSensitive().toString());
        }
        if (this.primIsNegated() != null) {
            writer.write(" ");
            CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"negate", (String)this.primIsNegated().toString());
        }
        if (this.getType() == 7) {
            writer.write("/");
        }
        writer.write(">");
        if (this.getType() != 7) {
            writer.write(this.getValue().toString());
            writer.write(CMDBfServicesUtil.endTagFor((String)elementName));
        }
        writer.write(ICMDBfServicesConstants.nl);
    }

    private String getElementName() {
        switch (this.type) {
            case 2: {
                return "less";
            }
            case 4: {
                return "lessOrEqual";
            }
            case 1: {
                return "greater";
            }
            case 3: {
                return "greaterOrEqual";
            }
            case 0: {
                return "equal";
            }
            case 5: {
                return "like";
            }
            case 6: {
                return "contains";
            }
            case 7: {
                return "isNull";
            }
        }
        return "unknown";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isCaseSensitive() ? 1231 : 1237);
        result = 31 * result + (this.isNegated() ? 1231 : 1237);
        result = 31 * result + this.type;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operator other = (Operator)obj;
        if (this.isCaseSensitive() != other.isCaseSensitive()) {
            return false;
        }
        if (this.isNegated() != other.isNegated()) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

