/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts.ItemTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IQuery;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IRelationshipTemplate;

public class Query
implements IQuery {
    private Map<String, IItemTemplate> itemTemplates = new HashMap<String, IItemTemplate>();
    private Map<String, IRelationshipTemplate> relationshipTemplates = new HashMap<String, IRelationshipTemplate>();

    public IItemTemplate[] getItemTemplates() {
        return this.itemTemplates.values().toArray(new ItemTemplate[this.itemTemplates.size()]);
    }

    public IItemTemplate getItemTemplate(String id) {
        return this.itemTemplates.get(id);
    }

    public IRelationshipTemplate[] getRelationshipTemplates() {
        return this.relationshipTemplates.values().toArray(new IRelationshipTemplate[this.relationshipTemplates.size()]);
    }

    public IRelationshipTemplate getRelationshipTemplate(String id) {
        return this.relationshipTemplates.get(id);
    }

    public void addItemTemplate(IItemTemplate itemTemplate) {
        this.itemTemplates.put(itemTemplate.getId(), itemTemplate);
    }

    public void addRelationshipTemplate(IRelationshipTemplate relationshipTemplate) {
        this.relationshipTemplates.put(relationshipTemplate.getId(), relationshipTemplate);
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write("<query xmlns=\"http://schemas.cmdbf.org/0-9-5/datamodel\">" + ICMDBfServicesConstants.nl);
        CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), new ArrayList<IItemTemplate>(this.itemTemplates.values()));
        CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), new ArrayList<IRelationshipTemplate>(this.relationshipTemplates.values()));
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)"query")) + ICMDBfServicesConstants.nl);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.itemTemplates == null ? 0 : this.itemTemplates.hashCode());
        result = 31 * result + (this.relationshipTemplates == null ? 0 : this.relationshipTemplates.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        if (this.itemTemplates == null ? other.itemTemplates != null : !this.itemTemplates.equals(other.itemTemplates)) {
            return false;
        }
        return !(this.relationshipTemplates == null ? other.relationshipTemplates != null : !this.relationshipTemplates.equals(other.relationshipTemplates));
    }

    public int getItemTemplateCount() {
        return this.itemTemplates.size();
    }

    public int getRelationshipTemplateCount() {
        return this.relationshipTemplates.size();
    }
}

