/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IInstanceIdSelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IPropertySubsetDirective;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IPropertyValueSelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IRecordTypeSelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.ITemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IXPath1Selector;

public abstract class Template
implements ITemplate,
IXMLWritable {
    private String id;
    private Boolean dropDirective = null;
    private IInstanceIdSelector instanceIdSelector;
    private List<IPropertyValueSelector> propertyValueSelectors = new ArrayList<IPropertyValueSelector>();
    private List<IXPath1Selector> xpath1Selectors = new ArrayList<IXPath1Selector>();
    private List<IRecordTypeSelector> recordTypeSelectors = new ArrayList<IRecordTypeSelector>();
    private IPropertySubsetDirective propertySubsetDirective;

    public Template(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isDropDirective() {
        if (this.primIsDropDirective() == null) {
            return false;
        }
        return this.primIsDropDirective();
    }

    private Boolean primIsDropDirective() {
        return this.dropDirective;
    }

    public void setDropDirective(boolean dropDirective) {
        this.dropDirective = dropDirective;
    }

    public IInstanceIdSelector getInstanceIdSelector() {
        return this.instanceIdSelector;
    }

    public void setInstanceIdSelector(IInstanceIdSelector instanceIdSelector) {
        this.instanceIdSelector = instanceIdSelector;
    }

    public IPropertySubsetDirective getPropertySubsetDirective() {
        return this.propertySubsetDirective;
    }

    public void setPropertySubsetDirective(IPropertySubsetDirective propertySubsetDirective) {
        this.propertySubsetDirective = propertySubsetDirective;
    }

    public IPropertyValueSelector[] getPropertyValueSelectors() {
        return this.propertyValueSelectors.toArray(new IPropertyValueSelector[this.propertyValueSelectors.size()]);
    }

    public IXPath1Selector[] getXpath1Selectors() {
        return this.xpath1Selectors.toArray(new IXPath1Selector[this.xpath1Selectors.size()]);
    }

    public IRecordTypeSelector[] getRecordTypeSelectors() {
        return this.recordTypeSelectors.toArray(new IRecordTypeSelector[this.recordTypeSelectors.size()]);
    }

    public void addXpath1Selector(IXPath1Selector xpath1Selector) {
        this.xpath1Selectors.add(xpath1Selector);
    }

    public void addPropertyValueSelector(IPropertyValueSelector propertyValueSelector) {
        this.propertyValueSelectors.add(propertyValueSelector);
    }

    public void addRecordTypeSelector(IRecordTypeSelector recordTypeSelector) {
        this.recordTypeSelectors.add(recordTypeSelector);
    }

    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write("<" + this.getElementName() + " ");
        CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"id", (String)this.getId());
        if (this.primIsDropDirective() != null) {
            writer.write(" ");
            CMDBfServicesUtil.writeAttribute((StringWriter)writer, (String)"dropDirective", (String)this.primIsDropDirective().toString());
        }
        writer.write(">" + ICMDBfServicesConstants.nl);
        if (this.getInstanceIdSelector() != null) {
            this.getInstanceIdSelector().toXML(writer, indent + 1);
        }
        CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), this.propertyValueSelectors);
        CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), this.xpath1Selectors);
        CMDBfServicesUtil.outputListToXML((StringWriter)writer, (int)(indent + 1), this.recordTypeSelectors);
        if (this.getPropertySubsetDirective() != null) {
            this.getPropertySubsetDirective().toXML(writer, indent + 1);
        }
        this.outputAdditionalSubelements(writer, indent + 1);
        CMDBfServicesUtil.addIndent((StringWriter)writer, (int)indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor((String)this.getElementName())) + ICMDBfServicesConstants.nl);
    }

    protected void outputAdditionalSubelements(StringWriter writer, int indent) {
    }

    protected abstract String getElementName();

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isDropDirective() ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.instanceIdSelector == null ? 0 : this.instanceIdSelector.hashCode());
        result = 31 * result + (this.propertySubsetDirective == null ? 0 : this.propertySubsetDirective.hashCode());
        result = 31 * result + (this.propertyValueSelectors == null ? 0 : this.propertyValueSelectors.hashCode());
        result = 31 * result + (this.recordTypeSelectors == null ? 0 : this.recordTypeSelectors.hashCode());
        result = 31 * result + (this.xpath1Selectors == null ? 0 : this.xpath1Selectors.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Template other = (Template)obj;
        if (this.isDropDirective() != other.isDropDirective()) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.instanceIdSelector == null ? other.instanceIdSelector != null : !this.instanceIdSelector.equals(other.instanceIdSelector)) {
            return false;
        }
        if (this.propertySubsetDirective == null ? other.propertySubsetDirective != null : !this.propertySubsetDirective.equals(other.propertySubsetDirective)) {
            return false;
        }
        if (this.propertyValueSelectors == null ? other.propertyValueSelectors != null : !this.propertyValueSelectors.equals(other.propertyValueSelectors)) {
            return false;
        }
        if (this.recordTypeSelectors == null ? other.recordTypeSelectors != null : !this.recordTypeSelectors.equals(other.recordTypeSelectors)) {
            return false;
        }
        return !(this.xpath1Selectors == null ? other.xpath1Selectors != null : !this.xpath1Selectors.equals(other.xpath1Selectors));
    }
}

