/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.response.artifacts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IPropertySubsetDirective;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.ITemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElementCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphCollection
implements IGraphElementCollection {
    private ITemplate template;
    private String templateId;
    private List<IXMLWritable> elements;
    private boolean startingContext;

    public AbstractGraphCollection(String templateId) {
        this.templateId = templateId;
        this.elements = new ArrayList<IXMLWritable>();
    }

    public AbstractGraphCollection(ITemplate template) {
        this(template.getId());
        this.template = template;
    }

    public AbstractGraphCollection(ITemplate template, List<IXMLWritable> elements) {
        this(template);
        this.elements = elements;
    }

    protected List<IXMLWritable> getCollection() {
        return this.elements;
    }

    public IGraphElement[] getElements() {
        return this.elements.toArray(new IGraphElement[this.elements.size()]);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.templateId == null ? 0 : this.templateId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj ? true : (obj == null || this.getClass() != obj.getClass() ? false : this.checkEquality(obj));
    }

    private boolean checkEquality(Object obj) {
        AbstractGraphCollection other = (AbstractGraphCollection)obj;
        return !(this.elements == null && other.getCollection() != null || !this.elements.equals(other.getCollection()) || this.templateId == null && other.getId() != null) && this.templateId.equals(other.getId());
    }

    public void clear() {
        this.getCollection().clear();
    }

    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    public void setElements(IGraphElement[] elements) {
        this.elements = new ArrayList<IXMLWritable>();
        int i = 0;
        while (i < elements.length) {
            this.elements.add((IXMLWritable)elements[i]);
            ++i;
        }
    }

    public IPropertySubsetDirective getDirectives() {
        return this.template == null ? null : this.template.getPropertySubsetDirective();
    }

    public String getId() {
        return this.templateId;
    }

    public int getSize() {
        return this.elements.size();
    }

    public boolean isStartingContext() {
        return this.startingContext;
    }

    public void setStartingContext(boolean startingContext) {
        this.startingContext = startingContext;
    }

    protected ITemplate getTemplate() {
        return this.template;
    }
}

