/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform;

import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IInstanceIdSelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IItemReference;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IOperator;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IPrefixMapping;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IPropertyId;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IPropertySubsetDirective;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IPropertyValueSelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IQuery;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IRecordTypeSelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.ISelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.ITemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IXPath1Selector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.InputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.ITransformerHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.helpers.DefaultHandler;

public class QueryInputStreamHandler
extends DefaultHandler
implements ITransformerHandler {
    private IQuery query;
    private ITemplate currentTemplate;
    private String currentElementData;
    private ISelector currentSelector;
    private IPropertySubsetDirective currentPropertySubsetDirective;
    private IOperator currentOperator;
    private boolean relationshipTemplate;
    private boolean instanceIdSelector;
    private boolean propertyValueSelector;
    private boolean xpath1Selector;
    private boolean propertySubsetDirective;

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (!"http://schemas.cmdbf.org/0-9-5/datamodel".equals(uri)) {
            return;
        }
        boolean temporaryFlag = false;
        if (this.propertyValueSelector) {
            this.handlePropertyElements(uri, localName, name, attributes, true);
        } else if (this.xpath1Selector) {
            this.handleXPathElements(uri, localName, name, attributes, true);
        } else if (this.propertySubsetDirective) {
            this.handlePropertySubsetDirective(uri, localName, name, attributes, true);
        } else if ("query".equals(localName)) {
            this.query = InputArtifactFactory.createQuery();
        } else if ("itemTemplate".equals(localName) || (temporaryFlag = "relationshipTemplate".equals(localName))) {
            if (temporaryFlag) {
                this.relationshipTemplate = true;
                this.currentTemplate = InputArtifactFactory.createRelationshipTemplate(null);
            } else {
                this.currentTemplate = InputArtifactFactory.createItemTemplate(null);
            }
            String id = attributes.getValue("id");
            this.currentTemplate.setId(id);
            String dropDirective = attributes.getValue("dropDirective");
            if (dropDirective != null && ((Attributes2)attributes).isSpecified("dropDirective")) {
                this.currentTemplate.setDropDirective(Boolean.parseBoolean(dropDirective));
            }
        } else if (this.relationshipTemplate && ("source".equals(localName) || "target".equals(localName))) {
            String max;
            String min;
            int relationshipType = 1;
            if ("source".equals(localName)) {
                relationshipType = 0;
            }
            IItemReference element = InputArtifactFactory.createItemReference(relationshipType);
            String ref = attributes.getValue("ref");
            IItemTemplate template = this.query.getItemTemplate(ref);
            if (template != null) {
                element.setRef(template);
            }
            if ((min = attributes.getValue("minimum")) != null) {
                element.setMinimum(Integer.valueOf(min));
            }
            if ((max = attributes.getValue("maximum")) != null) {
                element.setMaximum(Integer.valueOf(max));
            }
            if (this.currentTemplate != null) {
                if ("source".equals(localName)) {
                    ((IRelationshipTemplate)this.currentTemplate).setSourceElement(element);
                } else {
                    ((IRelationshipTemplate)this.currentTemplate).setTargetElement(element);
                }
            }
        } else if ("instanceIdSelector".equals(localName)) {
            this.instanceIdSelector = true;
            this.currentSelector = InputArtifactFactory.createInstanceIdSelector();
        } else if ("propertyValueSelector".equals(localName)) {
            this.propertyValueSelector = true;
            IPropertyValueSelector propertyValueSelector = InputArtifactFactory.createPropertyValueSelector();
            String namespace = attributes.getValue("namespace");
            String locName = attributes.getValue("localName");
            propertyValueSelector.setNamespace(CMDBfServicesUtil.createURI((String)namespace));
            propertyValueSelector.setLocalName(locName);
            if (this.shouldRetrieveAttribute(attributes, "matchAny")) {
                String matchAny = attributes.getValue("matchAny");
                propertyValueSelector.setMatchAny(Boolean.parseBoolean(matchAny));
            }
            this.currentSelector = propertyValueSelector;
        } else if ("xpath1Selector".equals(localName)) {
            this.xpath1Selector = true;
            this.currentSelector = InputArtifactFactory.createXPath1Selector();
        } else if ("recordTypeSelector".equals(localName)) {
            IRecordTypeSelector recordTypeSelector = InputArtifactFactory.createRecordTypeSelector();
            String namespace = attributes.getValue("namespace");
            String locName = attributes.getValue("localName");
            recordTypeSelector.setNamespace(CMDBfServicesUtil.createURI((String)namespace));
            recordTypeSelector.setLocalName(locName);
            this.currentTemplate.addRecordTypeSelector(recordTypeSelector);
        } else if ("propertySubsetDirective".equals(localName)) {
            this.propertySubsetDirective = true;
            this.currentPropertySubsetDirective = InputArtifactFactory.createPropertySubsetDirective();
        }
    }

    private boolean shouldRetrieveAttribute(Attributes attributes, String attributeName) {
        int attributeIndex = attributes.getIndex(attributeName);
        return attributeIndex != -1 && (!(attributes instanceof Attributes2) || ((Attributes2)attributes).isSpecified(attributeIndex));
    }

    private void handleInstanceIdElements(String uri, String localName, String name, boolean open) {
        if (!open) {
            if ("mdrId".equals(localName)) {
                ((IInstanceIdSelector)this.currentSelector).setMdrId(CMDBfServicesUtil.createURI((String)this.currentElementData));
            } else if ("localId".equals(localName)) {
                ((IInstanceIdSelector)this.currentSelector).setLocalId(CMDBfServicesUtil.createURI((String)this.currentElementData));
            }
        }
    }

    private void handlePropertySubsetDirective(String uri, String localName, String name, Attributes attributes, boolean open) {
        if (open && "selectedProperty".equals(localName)) {
            IPropertyId property = InputArtifactFactory.createPropertyId();
            String namespace = attributes.getValue("namespace");
            String locName = attributes.getValue("localName");
            property.setNamespace(CMDBfServicesUtil.createURI((String)namespace));
            property.setLocalName(locName);
            this.currentPropertySubsetDirective.addSelectedProperty(property);
        }
    }

    private void handleXPathElements(String uri, String localName, String name, Attributes attributes, boolean open) {
        if (open) {
            if ("prefixMapping".equals(localName)) {
                IPrefixMapping mapping = InputArtifactFactory.createPrefixMapping();
                mapping.setPrefix(attributes.getValue("prefix"));
                mapping.setNamespace(CMDBfServicesUtil.createURI((String)attributes.getValue("namespace")));
                ((IXPath1Selector)this.currentSelector).addPrefixMapping(mapping);
            }
        } else if ("xpathExpression".equals(localName)) {
            ((IXPath1Selector)this.currentSelector).setXpathExpression(this.currentElementData);
        }
    }

    private void handlePropertyElements(String uri, String localName, String name, Attributes attributes, boolean open) {
        if (open) {
            if ("less".equals(localName)) {
                this.createCurrentOperator(attributes, 2);
            } else if ("lessOrEqual".equals(localName)) {
                this.createCurrentOperator(attributes, 4);
            } else if ("greater".equals(localName)) {
                this.createCurrentOperator(attributes, 1);
            } else if ("greaterOrEqual".equals(localName)) {
                this.createCurrentOperator(attributes, 3);
            } else if ("equal".equals(localName)) {
                this.createCurrentStringOperator(attributes, 0);
            } else if ("like".equals(localName)) {
                this.createCurrentStringOperator(attributes, 5);
            } else if ("contains".equals(localName)) {
                this.createCurrentStringOperator(attributes, 6);
            } else if ("isNull".equals(localName)) {
                this.currentOperator = InputArtifactFactory.createOperator(7);
                if (this.shouldRetrieveAttribute(attributes, "negate")) {
                    String negateString = attributes.getValue("negate");
                    this.currentOperator.setNegate(Boolean.parseBoolean(negateString));
                }
            }
        } else if (this.isComparisonSelector(localName)) {
            this.currentOperator.setValue(this.currentElementData);
            ((IPropertyValueSelector)this.currentSelector).addOperator(this.currentOperator);
        }
    }

    private void createCurrentOperator(Attributes attributes, int type) {
        this.currentOperator = InputArtifactFactory.createOperator(type);
        if (this.shouldRetrieveAttribute(attributes, "negate")) {
            String negateString = attributes.getValue("negate");
            this.currentOperator.setNegate(Boolean.parseBoolean(negateString));
        }
    }

    private void createCurrentStringOperator(Attributes attributes, int type) {
        this.createCurrentOperator(attributes, type);
        if (this.shouldRetrieveAttribute(attributes, "caseSensitive")) {
            String caseSensitiveString = attributes.getValue("caseSensitive");
            this.currentOperator.setCaseSensitive(Boolean.parseBoolean(caseSensitiveString));
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!"http://schemas.cmdbf.org/0-9-5/datamodel".equals(uri)) {
            return;
        }
        if ("itemTemplate".equals(localName)) {
            this.query.addItemTemplate((IItemTemplate)this.currentTemplate);
            this.currentTemplate = null;
        } else if (this.relationshipTemplate && "relationshipTemplate".equals(localName)) {
            this.relationshipTemplate = false;
            this.query.addRelationshipTemplate((IRelationshipTemplate)this.currentTemplate);
            this.currentTemplate = null;
        } else if (this.instanceIdSelector && "instanceIdSelector".equals(localName)) {
            this.instanceIdSelector = false;
            this.currentTemplate.setInstanceIdSelector((IInstanceIdSelector)this.currentSelector);
            this.currentSelector = null;
        } else if ("xpath1Selector".equals(localName)) {
            this.xpath1Selector = false;
            IXPath1Selector xpath1Selector = (IXPath1Selector)this.currentSelector;
            this.currentTemplate.addXpath1Selector(xpath1Selector);
            this.currentSelector = null;
        } else if (this.propertyValueSelector && "propertyValueSelector".equals(localName)) {
            this.propertyValueSelector = false;
            IPropertyValueSelector propertyValueSelector = (IPropertyValueSelector)this.currentSelector;
            this.currentTemplate.addPropertyValueSelector(propertyValueSelector);
            this.currentSelector = null;
        } else if (this.propertySubsetDirective && "propertySubsetDirective".equals(localName)) {
            this.propertySubsetDirective = false;
            this.currentTemplate.setPropertySubsetDirective(this.currentPropertySubsetDirective);
            this.currentPropertySubsetDirective = null;
        } else if ("isNull".equals(localName)) {
            ((IPropertyValueSelector)this.currentSelector).addOperator(this.currentOperator);
        } else if (this.instanceIdSelector) {
            this.handleInstanceIdElements(uri, localName, name, false);
        } else if (this.propertyValueSelector) {
            this.handlePropertyElements(uri, localName, name, null, false);
        } else if (this.xpath1Selector) {
            this.handleXPathElements(uri, localName, name, null, false);
        }
        this.currentElementData = null;
    }

    private boolean isComparisonSelector(String name) {
        return "equal".equals(name) || "contains".equals(name) || "like".equals(name) || "greater".equals(name) || "greaterOrEqual".equals(name) || "less".equals(name) || "lessOrEqual".equals(name);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempData = new String(ch, start, length).trim();
        this.currentElementData = this.currentElementData == null ? tempData : String.valueOf(this.currentElementData) + tempData;
    }

    public IRootElement getResult() {
        return this.query;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }
}

