/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform;

import java.io.StringWriter;
import org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.CMDBfServicesArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IRelationship;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.ResponseArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IAdditionalRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IRecord;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class QueryOutputStreamHandler
extends DefaultHandler
implements ITransformerHandler {
    private IQueryResult queryResult;
    private IGraphElement currentResultEntity;
    private String currentElementData;
    private INodes currentNodes;
    private IEdges currentEdges;
    private IRecord currentRecord;
    private IInstanceId currentInstanceId;

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("queryResult".equals(name)) {
            this.queryResult = ResponseArtifactFactory.createQueryResult();
        } else if ("item".equals(name)) {
            this.currentResultEntity = ResponseArtifactFactory.createItem();
            this.currentNodes.addItem((IItem)this.currentResultEntity);
        } else if ("relationship".equals(name)) {
            this.currentResultEntity = ResponseArtifactFactory.createRelationship();
            this.currentEdges.addRelationship((IRelationship)this.currentResultEntity);
        } else if ("sourceItem".equals(name)) {
            this.currentInstanceId = CMDBfServicesArtifactFactory.createInstanceId();
        } else if ("targetItem".equals(name)) {
            this.currentInstanceId = CMDBfServicesArtifactFactory.createInstanceId();
        } else if ("nodes".equals(name)) {
            String templateId = attributes.getValue("templateId");
            this.currentNodes = ResponseArtifactFactory.createNodes(templateId);
            this.queryResult.addNodes(this.currentNodes);
        } else if ("edges".equals(name)) {
            String templateId = attributes.getValue("templateId");
            this.currentEdges = ResponseArtifactFactory.createEdges(templateId);
            this.queryResult.addEdges(this.currentEdges);
        } else if ("record".equals(name)) {
            String recordId = attributes.getValue("recordId");
            this.currentRecord = CMDBfServicesArtifactFactory.createRecord((IGraphElement)this.currentResultEntity);
            this.currentRecord.setRecordId(recordId);
            this.currentResultEntity.addRecord(this.currentRecord);
            this.currentElementData = "";
        } else if ("instanceId".equals(name)) {
            this.currentInstanceId = CMDBfServicesArtifactFactory.createInstanceId();
        } else if ("additionalRecordType".equals(name)) {
            String namespace = attributes.getValue("namespace");
            String locName = attributes.getValue("localName");
            IAdditionalRecordType adt = CMDBfServicesArtifactFactory.createAdditionalRecordType((String)namespace, (String)locName);
            this.currentResultEntity.addAdditionalRecordType(adt);
        } else if (this.currentRecord != null) {
            StringWriter tempWriter = new StringWriter();
            CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
            tempWriter.write(CMDBfServicesUtil.beginTagFor((String)name, (Attributes)attributes));
            tempWriter.write(ICMDBfServicesConstants.nl);
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
            if (!name.equals(localName)) {
                String prefix = name.split(":")[0];
                this.currentRecord.addNamespace(prefix, uri);
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("mdrId".equals(name)) {
            this.currentInstanceId.setMdrId(this.currentElementData);
            this.currentElementData = null;
        } else if ("localId".equals(name)) {
            this.currentInstanceId.setLocalId(this.currentElementData);
            this.currentElementData = null;
        } else if ("instanceId".equals(name)) {
            this.currentResultEntity.addInstanceId(this.currentInstanceId);
            this.currentInstanceId = null;
        } else if ("sourceItem".equals(name)) {
            ((IRelationship)this.currentResultEntity).setSourceId(this.currentInstanceId);
            this.currentInstanceId = null;
        } else if ("targetItem".equals(name)) {
            ((IRelationship)this.currentResultEntity).setTargetId(this.currentInstanceId);
            this.currentInstanceId = null;
        } else if ("record".equals(name)) {
            this.currentRecord.setValueFromString(this.currentElementData);
            this.currentElementData = null;
            this.currentRecord = null;
        } else if (this.currentRecord != null) {
            StringWriter tempWriter = new StringWriter();
            CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
            tempWriter.write(CMDBfServicesUtil.endTagFor((String)name));
            tempWriter.write(ICMDBfServicesConstants.nl);
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempData = new String(ch, start, length).trim();
        if (this.currentElementData == null) {
            this.currentElementData = tempData;
        } else {
            StringWriter tempWriter = new StringWriter();
            if (this.currentRecord != null) {
                CMDBfServicesUtil.addIndent((StringWriter)tempWriter, (int)4);
            }
            tempWriter.write(tempData);
            if (this.currentRecord != null) {
                tempWriter.write(10);
            }
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
        }
    }

    public IQueryResult getQueryResult() {
        return this.queryResult;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public IRootElement getResult() {
        return this.getQueryResult();
    }
}

