/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.cmdbfservice.AbstractServiceHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.exceptions.InitializationException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.exceptions.UnsupportedHandlerException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.IItemSelectorHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.IRelationshipSelectorHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.ISelectorHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.exceptions.SelectorHandleException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.QueryInputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IInstanceIdSelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IQuery;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.ISelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.ITemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IRelationship;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.ResponseArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.TransformerException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IInstanceId;

public class CMDBfQueryOperation
extends AbstractServiceHandler {
    private ISelectorHandlerFactory handlerFactory;

    public CMDBfQueryOperation(ISelectorHandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    public IQueryResult execute(InputStream query) throws IllegalArgumentException {
        IQuery cmdbfQuery = this.transform(query);
        try {
            IQueryResult queryResult = this.processItemTemplates(cmdbfQuery);
            this.processRelationshipTemplates(cmdbfQuery, queryResult);
            this.processDropDirectives(cmdbfQuery, queryResult);
            return queryResult;
        }
        catch (SelectorHandleException she) {
            throw new IllegalArgumentException(she);
        }
        catch (InitializationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UnsupportedHandlerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private IQuery transform(InputStream query) throws IllegalArgumentException {
        try {
            return QueryInputTransformer.transform((InputStream)query);
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException("There was an error in transforming the input query string", e);
        }
    }

    private IQueryResult processItemTemplates(IQuery query) throws IllegalArgumentException, SelectorHandleException, UnsupportedHandlerException, InitializationException {
        IQueryResult queryResult = ResponseArtifactFactory.createQueryResult();
        if (query.getItemTemplateCount() <= 0) {
            return queryResult;
        }
        IItemTemplate[] itemTemplates = query.getItemTemplates();
        int i = 0;
        while (i < itemTemplates.length) {
            INodes result = ResponseArtifactFactory.createNodes((IItemTemplate)itemTemplates[i]);
            result.setStartingContext(true);
            IInstanceIdSelector instanceSelector = itemTemplates[i].getInstanceIdSelector();
            if (!(instanceSelector != null && (result = this.applyItemSelectors(result, new ISelector[]{instanceSelector})).isEmpty() || !(result = this.applyItemSelectors(result, (ISelector[])itemTemplates[i].getRecordTypeSelectors())).isStartingContext() && result.isEmpty() || !(result = this.applyItemSelectors(result, (ISelector[])itemTemplates[i].getPropertyValueSelectors())).isStartingContext() && result.isEmpty() || (result = this.applyItemSelectors(result, (ISelector[])itemTemplates[i].getXpath1Selectors())).isStartingContext() || result.isEmpty() || result.getType() != 1)) {
                queryResult.addNodes(result);
            }
            ++i;
        }
        return queryResult;
    }

    private void processRelationshipTemplates(IQuery cmdbfQuery, IQueryResult queryResult) throws SelectorHandleException, InitializationException, UnsupportedHandlerException {
        IRelationshipTemplate[] relationshipTemplates = cmdbfQuery.getRelationshipTemplates();
        int i = 0;
        while (i < relationshipTemplates.length) {
            IEdges edges = ResponseArtifactFactory.createEdges((IRelationshipTemplate)relationshipTemplates[i]);
            edges.setStartingContext(true);
            INodes sourceNodes = queryResult.getNodes(relationshipTemplates[i].getSourceElement().getRef().getId());
            INodes targetNodes = queryResult.getNodes(relationshipTemplates[i].getTargetElement().getRef().getId());
            if (sourceNodes != null && targetNodes != null) {
                IGraphElement[] sourceElements = sourceNodes.getElements();
                IGraphElement[] targetElements = targetNodes.getElements();
                ArrayList<IGraphElement> revisedSourceList = new ArrayList<IGraphElement>();
                ArrayList<IGraphElement> revisedTargetList = new ArrayList<IGraphElement>();
                int j = 0;
                while (j < sourceElements.length) {
                    int k = 0;
                    while (k < targetElements.length) {
                        IGraphElement[] elements;
                        IGraphElement[] iGraphElementArray = elements = (edges = this.retrieveRelationship(edges, relationshipTemplates[i], (IItem)sourceElements[j], (IItem)targetElements[k])) == null ? null : edges.getElements();
                        if (elements != null) {
                            int l = 0;
                            while (l < elements.length) {
                                IRelationship relationship = (IRelationship)elements[i];
                                if (this.isElementPresent(relationship, targetElements[k])) {
                                    revisedTargetList.add(targetElements[k]);
                                }
                                ++l;
                            }
                        }
                        ++k;
                    }
                    if (edges != null && !edges.isEmpty()) {
                        revisedSourceList.add(sourceElements[j]);
                    }
                    ++j;
                }
                sourceNodes.setElements(revisedSourceList.toArray(new IGraphElement[revisedSourceList.size()]));
                targetNodes.setElements(revisedTargetList.toArray(new IGraphElement[revisedTargetList.size()]));
                this.cleanResults(queryResult, sourceNodes);
                this.cleanResults(queryResult, targetNodes);
                IGraphElement[] relationships = edges.getElements();
                if (relationships != null && relationships.length > 0) {
                    queryResult.addEdges(edges);
                }
            }
            ++i;
        }
    }

    private boolean isElementPresent(IRelationship relationship, IGraphElement graphElement) {
        IInstanceId targetId;
        IInstanceId iInstanceId = targetId = relationship == null ? null : relationship.getTargetId();
        if (targetId == null) {
            return false;
        }
        IInstanceId[] instanceIds = graphElement.getInstanceIds();
        int i = 0;
        while (i < instanceIds.length) {
            if (targetId.equals(instanceIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IEdges retrieveRelationship(IEdges parent, IRelationshipTemplate relationshipTemplate, IItem source, IItem target) throws SelectorHandleException, InitializationException, UnsupportedHandlerException {
        ISelector[] iSelectorArray;
        ISelector[][] iSelectorArrayArray = new ISelector[4][];
        if (relationshipTemplate.getInstanceIdSelector() == null) {
            iSelectorArray = null;
        } else {
            ISelector[] iSelectorArray2 = new ISelector[1];
            iSelectorArray = iSelectorArray2;
            iSelectorArray2[0] = relationshipTemplate.getInstanceIdSelector();
        }
        iSelectorArrayArray[0] = iSelectorArray;
        iSelectorArrayArray[1] = relationshipTemplate.getRecordTypeSelectors();
        iSelectorArrayArray[2] = relationshipTemplate.getPropertyValueSelectors();
        iSelectorArrayArray[3] = relationshipTemplate.getXpath1Selectors();
        ISelector[][] selectors = iSelectorArrayArray;
        IEdges result = parent;
        int i = 0;
        while (i < selectors.length) {
            if (selectors[i] != null && selectors[i].length > 0) {
                result = this.applyRelationshipSelectors(result, source, target, selectors[i]);
            }
            ++i;
        }
        return result;
    }

    private IEdges applyRelationshipSelectors(IEdges parent, IItem source, IItem target, ISelector[] selectors) throws SelectorHandleException, InitializationException, UnsupportedHandlerException {
        if (selectors == null || selectors.length <= 0) {
            return null;
        }
        IRelationshipSelectorHandler selectorHandler = this.handlerFactory.createRelationshipHandler(selectors[0]);
        if (!selectorHandler.isInitialized()) {
            selectorHandler.initialize(this.getInit());
        }
        boolean status = true;
        IEdges result = parent;
        int i = 0;
        while (status && i < selectors.length) {
            result = selectorHandler.execute(result, source, target, selectors[i]);
            result.setStartingContext(false);
            ++i;
        }
        return result;
    }

    private void cleanResults(IQueryResult result, INodes nodes) {
        if (nodes.isEmpty()) {
            result.removeNodes(nodes);
        }
    }

    private INodes applyItemSelectors(INodes context, ISelector[] selectors) throws UnsupportedHandlerException, SelectorHandleException, InitializationException {
        INodes result = context;
        if (selectors == null || selectors.length <= 0) {
            return result;
        }
        IItemSelectorHandler selectorHandler = this.handlerFactory.createItemHandler(selectors[0]);
        if (!selectorHandler.isInitialized()) {
            selectorHandler.initialize(this.getInit());
        }
        int i = 0;
        while (i < selectors.length) {
            result = selectorHandler.execute(result, selectors[i]);
            result.setStartingContext(false);
            ++i;
        }
        return result;
    }

    private void processDropDirectives(IQuery query, IQueryResult result) {
        this.processDropDirectives(result, (ITemplate[])query.getItemTemplates(), true);
        this.processDropDirectives(result, (ITemplate[])query.getRelationshipTemplates(), false);
    }

    private void processDropDirectives(IQueryResult result, ITemplate[] templates, boolean isItemTemplate) {
        int i = 0;
        while (i < templates.length) {
            if (templates[i].isDropDirective()) {
                if (isItemTemplate) {
                    INodes nodes = result.getNodes(templates[i].getId());
                    if (nodes != null) {
                        result.removeNodes(nodes);
                    }
                } else {
                    IEdges edges = result.getEdges(templates[i].getId());
                    if (edges != null) {
                        result.removeEdges(edges);
                    }
                }
            }
            ++i;
        }
    }
}

