/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.util.ArrayList;
import org.eclipse.datatools.connectivity.oda.OdaException;

public final class SPParameterPositionUtil {
    private char[] parameterDefnChars;
    private char escaper;

    public SPParameterPositionUtil(String sqlTxt, char escaper) throws OdaException {
        this.escaper = escaper;
        this.parameterDefnChars = this.getParameterDefinitionChars(sqlTxt, escaper);
    }

    public boolean hasNonDefaultParameter() {
        boolean nextDelimiterValid = true;
        int i = 0;
        while (i < this.parameterDefnChars.length) {
            if (i <= 0 || this.parameterDefnChars[i - 1] != this.escaper) {
                if ('\"' == this.parameterDefnChars[i]) {
                    boolean bl = nextDelimiterValid = !nextDelimiterValid;
                }
                if (nextDelimiterValid && '?' == this.parameterDefnChars[i]) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public int[] getParameterPositions() {
        int nextPosition = 1;
        ArrayList<Integer> result = new ArrayList<Integer>();
        boolean nextDelimiterValid = true;
        int i = 0;
        while (i < this.parameterDefnChars.length) {
            if (i <= 0 || this.parameterDefnChars[i - 1] != this.escaper) {
                if ('\"' == this.parameterDefnChars[i]) {
                    boolean bl = nextDelimiterValid = !nextDelimiterValid;
                }
                if (nextDelimiterValid) {
                    if ('?' == this.parameterDefnChars[i]) {
                        result.add(new Integer(nextPosition));
                    }
                    if (',' == this.parameterDefnChars[i]) {
                        ++nextPosition;
                    }
                }
            }
            ++i;
        }
        int[] rt = new int[result.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            rt[i2] = new Integer(result.get(i2).toString());
            ++i2;
        }
        return rt;
    }

    private char[] getParameterDefinitionChars(String sqlTxt, char escaper) throws OdaException {
        char[] temp = sqlTxt.toCharArray();
        int startPoint = -1;
        int endPoint = -1;
        boolean validBracket = true;
        int i = temp.length - 1;
        while (i >= 0) {
            if (i <= 0 || temp[i - 1] != escaper) {
                if (validBracket) {
                    if (')' == temp[i] && endPoint == -1) {
                        endPoint = i;
                    }
                    if ('(' == temp[i]) {
                        startPoint = i;
                        break;
                    }
                }
                if ('\"' == temp[i]) {
                    validBracket = !validBracket;
                }
            }
            --i;
        }
        if (startPoint == -1 && endPoint == -1) {
            return new char[0];
        }
        if (startPoint >= endPoint || startPoint == -1) {
            throw new OdaException("Illegal SP call");
        }
        return sqlTxt.substring(startPoint, endPoint).toCharArray();
    }
}

