/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.provisional.deregistration.transform;

import java.io.StringWriter;
import org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.CMDBfServicesArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.deregistration.transform.input.artifacts.DeregisterRequestArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.deregistration.transform.input.artifacts.IDeregisterRequest;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.input.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.input.artifacts.IRelationship;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IInstanceId;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DeregistrationInputStreamHandler
extends DefaultHandler
implements ITransformerHandler {
    private IDeregisterRequest request;
    private String currentElementData;
    private IInstanceId currentInstanceId;
    private boolean inItemIdList = false;

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (!"http://schemas.cmdbf.org/0-9-5/datamodel".equals(uri)) {
            return;
        }
        if ("deregisterRequest".equals(localName)) {
            this.request = DeregisterRequestArtifactFactory.createDeregisterRequest();
        } else if ("itemIdList".equals(localName)) {
            this.inItemIdList = true;
        } else if ("instanceId".equals(localName)) {
            this.currentInstanceId = CMDBfServicesArtifactFactory.createInstanceId();
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (!"http://schemas.cmdbf.org/0-9-5/datamodel".equals(uri)) {
            return;
        }
        if ("mdrId".equals(localName)) {
            if (this.currentInstanceId != null) {
                this.currentInstanceId.setMdrId(this.currentElementData);
            } else {
                this.request.setMdrId(CMDBfServicesUtil.createURI((String)this.currentElementData));
            }
            this.currentElementData = null;
        } else if ("localId".equals(localName)) {
            this.currentInstanceId.setLocalId(this.currentElementData);
            this.currentElementData = null;
        } else if ("instanceId".equals(localName)) {
            if (this.inItemIdList) {
                IItem item = DeregisterRequestArtifactFactory.createItem();
                item.addInstanceId(this.currentInstanceId);
                this.request.addItem(item);
            } else {
                IRelationship relationship = DeregisterRequestArtifactFactory.createRelationship();
                relationship.addInstanceId(this.currentInstanceId);
                this.request.addRelationship(relationship);
            }
            this.currentInstanceId = null;
        } else if ("itemIdList".equals(localName)) {
            this.inItemIdList = false;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tempData = new String(ch, start, length).trim();
        if (this.currentElementData == null) {
            this.currentElementData = tempData;
        } else {
            StringWriter tempWriter = new StringWriter();
            tempWriter.write(tempData);
            this.currentElementData = String.valueOf(this.currentElementData) + tempWriter.toString();
        }
    }

    public IDeregisterRequest getRequest() {
        return this.request;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public IRootElement getResult() {
        return this.getRequest();
    }
}

