/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.IReportItemMethodContext;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.interfaces.IReportItemModel;
import org.eclipse.birt.report.model.elements.interfaces.IStyledElementModel;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.BoundDataColumnUtil;
import org.eclipse.birt.report.model.util.UnusedBoundColumnsMgr;

public abstract class ReportItemHandle
extends ReportElementHandle
implements IReportItemModel,
IStyledElementModel,
IReportItemMethodContext {
    public static final int DATABINDING_TYPE_NONE = 0;
    public static final int DATABINDING_TYPE_DATA = 1;
    public static final int DATABINDING_TYPE_REPORT_ITEM_REF = 2;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.ReportItemHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ReportItemHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public DataSetHandle getDataSet() {
        DesignElement dataSet = ((ReportItem)this.getElement()).getDataSetElement(this.module);
        if (dataSet == null) {
            return null;
        }
        if (!$assertionsDisabled && !(dataSet instanceof DataSet)) {
            throw new AssertionError();
        }
        return (DataSetHandle)dataSet.getHandle(dataSet.getRoot());
    }

    public void setDataSet(DataSetHandle handle) throws SemanticException {
        if (handle == null) {
            this.setStringProperty("dataSet", null);
        } else {
            ModuleHandle moduleHandle = handle.getRoot();
            String valueToSet = handle.getElement().getFullName();
            if (moduleHandle instanceof LibraryHandle) {
                String namespace = ((LibraryHandle)moduleHandle).getNamespace();
                valueToSet = StringUtil.buildQualifiedReference(namespace, valueToSet);
            }
            this.setStringProperty("dataSet", valueToSet);
        }
    }

    public CubeHandle getCube() {
        DesignElement cube = ((ReportItem)this.getElement()).getCubeElement(this.module);
        if (cube == null) {
            return null;
        }
        if (!$assertionsDisabled && !(cube instanceof Cube)) {
            throw new AssertionError();
        }
        return (CubeHandle)cube.getHandle(cube.getRoot());
    }

    public void setCube(CubeHandle handle) throws SemanticException {
        if (handle == null) {
            this.setStringProperty("cube", null);
        } else {
            ModuleHandle moduleHandle = handle.getRoot();
            String valueToSet = handle.getElement().getFullName();
            if (moduleHandle instanceof LibraryHandle) {
                String namespace = ((LibraryHandle)moduleHandle).getNamespace();
                valueToSet = StringUtil.buildQualifiedReference(namespace, valueToSet);
            }
            this.setStringProperty("cube", valueToSet);
        }
    }

    public DimensionHandle getX() {
        return super.getDimensionProperty("x");
    }

    public DimensionHandle getY() {
        return super.getDimensionProperty("y");
    }

    public void setX(String dimension) throws SemanticException {
        this.setProperty("x", dimension);
    }

    public void setX(double dimension) throws SemanticException {
        this.setFloatProperty("x", dimension);
    }

    public void setY(String dimension) throws SemanticException {
        this.setProperty("y", dimension);
    }

    public void setY(double dimension) throws SemanticException {
        this.setFloatProperty("y", dimension);
    }

    public void setHeight(String dimension) throws SemanticException {
        this.setProperty("height", dimension);
    }

    public void setHeight(double dimension) throws SemanticException {
        this.setFloatProperty("height", dimension);
    }

    public void setWidth(String dimension) throws SemanticException {
        this.setProperty("width", dimension);
    }

    public void setWidth(double dimension) throws SemanticException {
        this.setFloatProperty("width", dimension);
    }

    public DimensionHandle getWidth() {
        return super.getDimensionProperty("width");
    }

    public DimensionHandle getHeight() {
        return super.getDimensionProperty("height");
    }

    public String getBookmark() {
        return this.getStringProperty("bookmark");
    }

    public void setBookmark(String value) throws SemanticException {
        this.setStringProperty("bookmark", value);
    }

    public Iterator visibilityRulesIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("visibility");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.iterator();
    }

    public String getOnCreate() {
        return this.getStringProperty("onCreate");
    }

    public void setOnCreate(String value) throws SemanticException {
        this.setProperty("onCreate", value);
    }

    public String getOnRender() {
        return this.getStringProperty("onRender");
    }

    public void setOnRender(String value) throws SemanticException {
        this.setProperty("onRender", value);
    }

    public Iterator paramBindingsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("paramBindings");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.iterator();
    }

    public void setTocExpression(String expression) throws SemanticException {
        if (StringUtil.isEmpty(expression)) {
            this.setProperty("toc", null);
            return;
        }
        TOCHandle tocHandle = this.getTOC();
        if (StringUtil.isBlank(expression)) {
            return;
        }
        if (tocHandle == null) {
            TOC toc = StructureFactory.createTOC(expression);
            this.addTOC(toc);
        } else {
            tocHandle.setExpression(expression);
        }
    }

    public String getTocExpression() {
        TOCHandle tocHandle = this.getTOC();
        if (tocHandle == null) {
            return null;
        }
        return tocHandle.getExpression();
    }

    public String getOnPrepare() {
        return this.getStringProperty("onPrepare");
    }

    public void setOnPrepare(String script) throws SemanticException {
        this.setProperty("onPrepare", script);
    }

    public String getOnPageBreak() {
        return this.getStringProperty("onPageBreak");
    }

    public void setOnPageBreak(String script) throws SemanticException {
        this.setProperty("onPageBreak", script);
    }

    public Iterator columnBindingsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("boundDataColumns");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.iterator();
    }

    public PropertyHandle getColumnBindings() {
        return this.getPropertyHandle("boundDataColumns");
    }

    public ComputedColumnHandle addColumnBinding(ComputedColumn addColumn, boolean inForce) throws SemanticException {
        if (addColumn == null) {
            return null;
        }
        String expr = addColumn.getExpression();
        if (expr == null) {
            return null;
        }
        List columns = (List)this.getProperty("boundDataColumns");
        if (columns == null) {
            return (ComputedColumnHandle)this.getPropertyHandle("boundDataColumns").addItem(addColumn);
        }
        ComputedColumn column = BoundDataColumnUtil.getColumn(columns, expr, addColumn.getAggregateFunction(), addColumn.getAggregateOnList());
        if (column != null && !inForce) {
            return (ComputedColumnHandle)column.handle(this.getPropertyHandle("boundDataColumns"), columns.indexOf(column));
        }
        return (ComputedColumnHandle)this.getPropertyHandle("boundDataColumns").addItem(addColumn);
    }

    public ComputedColumnHandle findColumnBinding(String name) {
        if (name == null) {
            return null;
        }
        List columns = (List)this.getProperty("boundDataColumns");
        if (columns == null) {
            return null;
        }
        int i = 0;
        while (i < columns.size()) {
            ComputedColumn column = (ComputedColumn)columns.get(i);
            if (name.equals(column.getName())) {
                return (ComputedColumnHandle)column.handle(this.getPropertyHandle("boundDataColumns"), i);
            }
            ++i;
        }
        return null;
    }

    public void removedUnusedColumnBindings() throws SemanticException {
        UnusedBoundColumnsMgr.removedUnusedBoundColumns(this);
    }

    public TOCHandle getTOC() {
        PropertyHandle propHandle = this.getPropertyHandle("toc");
        if (propHandle == null) {
            return null;
        }
        TOC toc = (TOC)propHandle.getValue();
        if (toc == null) {
            return null;
        }
        return (TOCHandle)toc.getHandle(propHandle);
    }

    public TOCHandle addTOC(String expression) throws SemanticException {
        if (StringUtil.isEmpty(expression)) {
            return null;
        }
        TOC toc = StructureFactory.createTOC(expression);
        this.setProperty("toc", toc);
        return (TOCHandle)toc.getHandle(this.getPropertyHandle("toc"));
    }

    public TOCHandle addTOC(TOC toc) throws SemanticException {
        this.setProperty("toc", toc);
        if (toc == null) {
            return null;
        }
        return (TOCHandle)toc.getHandle(this.getPropertyHandle("toc"));
    }

    public int getZIndex() {
        return super.getIntProperty("zIndex");
    }

    public void setZIndex(int zIndex) throws SemanticException {
        this.setIntProperty("zIndex", zIndex);
    }

    public List getMethods(String methodName) {
        return Collections.EMPTY_LIST;
    }

    public void setDataBindingReference(ReportItemHandle item) throws SemanticException {
        this.setProperty("dataBindingRef", item);
    }

    public String getDataBindingReferenceName() {
        return (String)this.getProperty("dataBindingRef");
    }

    public ReportItemHandle getDataBindingReference() {
        ElementRefValue refValue = (ElementRefValue)this.getElement().getProperty(this.module, "dataBindingRef");
        if (refValue == null || !refValue.isResolved()) {
            return null;
        }
        DesignElement tmpElement = refValue.getElement();
        return (ReportItemHandle)tmpElement.getHandle(tmpElement.getRoot());
    }

    public int getDataBindingType() {
        if (this.getDataBindingReferenceName() != null) {
            return 2;
        }
        if (this.getDataSet() != null || this.element.getProperty(this.module, "cube") != null) {
            return 1;
        }
        return 0;
    }

    public List getAvailableDataBindingReferenceList() {
        ArrayList<ReportItemHandle> rtnList = new ArrayList<ReportItemHandle>();
        NameSpace ns = this.module.getNameHelper().getNameSpace(1);
        List elements = ns.getElements();
        int i = 0;
        while (i < elements.size()) {
            ReportItemHandle elementHandle;
            DesignElement e = (DesignElement)elements.get(i);
            if (e != this.getElement() && e instanceof ReportItem && (elementHandle = (ReportItemHandle)e.getHandle(this.module)).getDataBindingType() == 1) {
                rtnList.add(elementHandle);
            }
            ++i;
        }
        if (rtnList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(rtnList);
    }

    public void removedColumnBindings(List bindingNameList) throws SemanticException {
        if (bindingNameList == null || bindingNameList.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < bindingNameList.size()) {
            this.removedColumnBinding((String)bindingNameList.get(i));
            ++i;
        }
    }

    public void removedColumnBinding(String bindingName) throws SemanticException {
        ComputedColumnHandle toRemoveColumn = this.findColumnBinding(bindingName);
        if (toRemoveColumn == null) {
            return;
        }
        toRemoveColumn.drop();
    }
}

