/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.transform.IComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.expression.AggregateObject;
import org.eclipse.birt.data.engine.expression.ExpressionInfo;
import org.eclipse.birt.data.engine.expression.MultiPassExpressionCompiler;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.impl.aggregation.JSAggrValueObject;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ExpressionProcessor
implements IExpressionProcessor {
    private List availableAggrList;
    private DataSetRuntime dataset;
    private ResultSetPopulator rsPopulator;
    private boolean isDataSetMode = true;
    private IResultIterator resultIterator;
    private BaseQuery baseQuery;
    private MultiPassExpressionCompiler currentHelper;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.expression.ExpressionProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ExpressionProcessor(DataSetRuntime dataSet) {
        this.dataset = dataSet;
        this.availableAggrList = new ArrayList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void evaluateMultiPassExprOnCmp(IComputedColumnsState iccState, boolean useResultSetMeta) throws DataException {
        if (!$assertionsDisabled && iccState == null) {
            throw new AssertionError();
        }
        Context context = Context.enter();
        try {
            int exprType = 0;
            int currentGroupLevel = 0;
            MultiPassExpressionCompiler helper = this.getMultiPassCompilerHelper();
            helper.setDataSetMode(this.isDataSetMode);
            int i = 0;
            while (i < iccState.getCount()) {
                if (iccState.isValueAvailable(i)) {
                    helper.addAvailableCmpColumn(iccState.getName(i));
                }
                ++i;
            }
            i = 0;
            while (i < iccState.getCount()) {
                if (!iccState.isValueAvailable(i)) {
                    IBaseExpression baseExpression = iccState.getExpression(i);
                    String name = iccState.getName(i);
                    if (useResultSetMeta && name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E")) {
                        exprType = 2;
                        currentGroupLevel = this.getCurrentGroupLevel(name, currentGroupLevel, this.rsPopulator.getQuery());
                        iccState.setValueAvailable(i);
                    }
                    if (baseExpression instanceof IScriptExpression) {
                        ExpressionInfo exprInfo = new ExpressionInfo((IScriptExpression)baseExpression, exprType, currentGroupLevel, useResultSetMeta);
                        baseExpression.setHandle(helper.compileExpression(exprInfo, context));
                    } else if (baseExpression instanceof IConditionalExpression) {
                        this.compileConditionalExpression((IConditionalExpression)baseExpression, helper, this.rsPopulator, exprType, currentGroupLevel, context);
                    }
                    if (exprType != 2) {
                        if (helper.getExpressionPassLevel() <= 1) {
                            iccState.setValueAvailable(i);
                        }
                        helper.reSetPassLevelFlag();
                    } else {
                        Object var11_11 = null;
                        Context.exit();
                        return;
                    }
                }
                ++i;
            }
            this.calculate(helper);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        Context.exit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void evaluateMultiPassExprOnGroup(Object[] exprArray, int[] currentGroupLevel, int arrayType) throws DataException {
        if (!$assertionsDisabled && exprArray == null) {
            throw new AssertionError();
        }
        IBaseExpression baseExpression = null;
        Context context = Context.enter();
        MultiPassExpressionCompiler helper = this.getMultiPassCompilerHelper();
        helper.setDataSetMode(this.isDataSetMode);
        try {
            int i = 0;
            while (i < exprArray.length) {
                baseExpression = (IBaseExpression)exprArray[i];
                if (baseExpression instanceof IConditionalExpression) {
                    this.compileConditionalExpression((IConditionalExpression)baseExpression, helper, this.rsPopulator, arrayType, currentGroupLevel[i], context);
                } else if (baseExpression instanceof IScriptExpression) {
                    ExpressionInfo exprInfo = new ExpressionInfo((IScriptExpression)baseExpression, arrayType, currentGroupLevel[i], true);
                    baseExpression.setHandle(helper.compileExpression(exprInfo, context));
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        Context.exit();
        this.calculate(helper);
    }

    public boolean hasAggregateExpr(List list) throws DataException {
        boolean hasAggregate = false;
        MultiPassExpressionCompiler helper = new MultiPassExpressionCompiler(this.rsPopulator, this.baseQuery, this.dataset.getScriptScope(), this.availableAggrList);
        helper.setDataSetMode(this.isDataSetMode);
        IBaseExpression baseExpression = null;
        int i = 0;
        while (i < list.size()) {
            baseExpression = (IBaseExpression)list.get(i);
            this.compileBaseExpression(baseExpression, helper);
            ++i;
        }
        hasAggregate = helper.getAggregateStatus();
        this.clear();
        return hasAggregate;
    }

    public boolean hasAggregation(IBaseExpression expression) {
        boolean hasAggregate = false;
        try {
            MultiPassExpressionCompiler helper = new MultiPassExpressionCompiler(this.rsPopulator, this.baseQuery, null, null);
            helper.setDataSetMode(this.isDataSetMode);
            IBaseExpression baseExpression = expression;
            this.compileBaseExpression(baseExpression, helper);
            hasAggregate = helper.getAggregateStatus();
            this.clear();
        }
        catch (DataException dataException) {
            this.clear();
            return false;
        }
        return hasAggregate;
    }

    private void calculate(MultiPassExpressionCompiler helper) throws DataException {
        List aggrList = helper.getAggregateList(1);
        AggregateTable table = helper.getAggregateTable();
        if (aggrList == null || table == null) {
            return;
        }
        if (helper.hasNestedAggregate()) {
            table.calculate(this.resultIterator, this.dataset.getScriptScope(), (JSAggrValueObject)this.dataset.getJSTempAggrValueObject());
        } else {
            table.calculate(this.resultIterator, this.dataset.getScriptScope());
        }
        Scriptable aggrObj = table.getJSAggrValueObject();
        this.dataset.setJSTempAggrValueObject(aggrObj);
        int i = 0;
        while (i < aggrList.size()) {
            AggregateObject obj = (AggregateObject)aggrList.get(i);
            obj.setAvailable(true);
            if (this.availableAggrList == null) {
                this.availableAggrList = new ArrayList();
            }
            if (!this.availableAggrList.contains(obj)) {
                this.availableAggrList.add(obj);
            }
            ++i;
        }
    }

    private void compileConditionalExpression(IConditionalExpression baseExpression, MultiPassExpressionCompiler helper, ResultSetPopulator rsPopulator, int exprType, int currentGroupLevel, Context context) throws DataException {
        ExpressionInfo exprInfo = null;
        if (baseExpression instanceof IConditionalExpression) {
            IConditionalExpression condition = baseExpression;
            IScriptExpression op = condition.getExpression();
            IScriptExpression op1 = condition.getOperand1();
            IScriptExpression op2 = condition.getOperand2();
            if (op != null) {
                exprInfo = new ExpressionInfo(op, exprType, currentGroupLevel, true);
                op.setHandle(helper.compileExpression(exprInfo, context));
            }
            if (op1 != null) {
                exprInfo = new ExpressionInfo(op1, exprType, currentGroupLevel, true);
                op1.setHandle(helper.compileExpression(op1, context));
            }
            if (op2 != null) {
                exprInfo = new ExpressionInfo(op2, exprType, currentGroupLevel, true);
                op2.setHandle(helper.compileExpression(op2, context));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compileBaseExpression(IBaseExpression baseExpression, MultiPassExpressionCompiler helper) throws DataException {
        Context context = Context.enter();
        try {
            if (baseExpression instanceof IConditionalExpression) {
                IConditionalExpression condition = (IConditionalExpression)baseExpression;
                IScriptExpression op = condition.getExpression();
                IScriptExpression op1 = condition.getOperand1();
                IScriptExpression op2 = condition.getOperand2();
                if (op != null) {
                    helper.compileExpression(op, context);
                }
                if (op1 != null) {
                    helper.compileExpression(op1, context);
                }
                if (op2 != null) {
                    helper.compileExpression(op2, context);
                }
            } else if (baseExpression instanceof IScriptExpression) {
                IScriptExpression scriptExpr = (IScriptExpression)baseExpression;
                helper.compileExpression(scriptExpr, context);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    private int getCurrentGroupLevel(String groupText, int start, BaseQuery query) {
        if (!$assertionsDisabled && groupText == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && query == null) {
            throw new AssertionError();
        }
        IQuery.GroupSpec[] groups = query.getGrouping();
        int i = start;
        while (i < groups.length) {
            IQuery.GroupSpec group = groups[i];
            if (groupText.equals(group.getName()) || groupText.equals(group.getKeyColumn())) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private MultiPassExpressionCompiler getMultiPassCompilerHelper() {
        if (this.currentHelper == null) {
            this.currentHelper = new MultiPassExpressionCompiler(this.rsPopulator, this.baseQuery, this.dataset.getScriptScope(), this.availableAggrList);
        } else {
            this.currentHelper.setCompilerStatus(this.availableAggrList);
        }
        return this.currentHelper;
    }

    public Scriptable getScope() {
        return this.dataset.getScriptScope();
    }

    public void setResultSetPopulator(ResultSetPopulator rsPopulator) {
        this.rsPopulator = rsPopulator;
    }

    public void setDataSetMode(boolean isDataSetMode) {
        this.isDataSetMode = isDataSetMode;
    }

    public void setQuery(BaseQuery query) {
        this.baseQuery = query;
    }

    public void setResultIterator(IResultIterator resultIterator) {
        this.resultIterator = resultIterator;
        this.dataset.setResultSet(this.resultIterator, false);
    }

    public void clear() {
        if (this.availableAggrList != null) {
            this.availableAggrList.clear();
        }
        this.availableAggrList = null;
    }
}

