/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.SmartCache;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.RDGroupUtil;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.impl.document.SubQueryIndexUtil;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataResultSet2;
import org.eclipse.birt.data.engine.impl.document.viewing.BaseCachedResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.DummyEventHandler;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;

public class CachedSubExprResultSet
extends BaseCachedResultSet {
    private int[] offsetIndex;
    private int oldSubQueryIndex;
    private DataEngineSession session;

    public CachedSubExprResultSet(StreamManager streamManager, SubQueryIndexUtil subQueryManager, int currParentIndex, RDGroupUtil rdGroupUtil, DataEngineSession session) throws DataException {
        this.rdGroupUtil = rdGroupUtil;
        this.rdGroupUtil.setCacheProvider(this);
        this.session = session;
        this.doPrepare(streamManager, subQueryManager, currParentIndex);
        this.next();
    }

    private void doPrepare(StreamManager streamManager, SubQueryIndexUtil subQueryManager, int currParentIndex) throws DataException {
        this.oldSubQueryIndex = subQueryManager.getOldGroupInstanceIndex(currParentIndex);
        this.offsetIndex = subQueryManager.getRowOffsetOfSubQuery(currParentIndex);
        ExprDataResultSet2 exprDataResultSet = new ExprDataResultSet2(streamManager.getInStream(31, 0, 2), streamManager.getInStream(33, 0, 2), this.offsetIndex, ExprMetaUtil.loadExprMetaInfo((InputStream)streamManager.getInStream(32, 0, 2)));
        this.resultClass = exprDataResultSet.getResultClass();
        this.smartCache = new SmartCache(new CacheRequest(-1, new ArrayList(), null, new DummyEventHandler()), new OdiAdapter(exprDataResultSet), this.resultClass, this.session);
        this.rowCount = this.smartCache.getCount();
    }

    public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
        try {
            IOUtil.writeInt((OutputStream)streamsWrapper.getStreamForParentIndex(), (int)this.oldSubQueryIndex);
            OutputStream outputStream = streamsWrapper.getStreamForRowIndexInfo();
            int i = 0;
            while (i < this.offsetIndex.length) {
                IOUtil.writeInt((OutputStream)outputStream, (int)this.offsetIndex[i]);
                ++i;
            }
            IOUtil.writeInt((OutputStream)streamsWrapper.getStreamForGroupInfo(), (int)0);
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Data");
        }
    }
}

