/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.ColumnHint;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odaconsumer.ParameterMetaData;
import org.eclipse.birt.data.engine.odaconsumer.ProjectedColumns;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odaconsumer.ResultSetMetaData;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.datatools.connectivity.oda.IAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;

public class PreparedStatement {
    private String m_dataSetType;
    private Connection m_connection;
    private String m_queryText;
    private IQuery m_statement;
    private ArrayList m_properties;
    private int m_maxRows;
    private ArrayList m_sortSpecs;
    private int m_supportsNamedResults;
    private int m_supportsOutputParameters;
    private int m_supportsNamedParameters;
    private Boolean m_supportsInputParameters;
    private ArrayList m_parameterHints;
    private Collection m_parameterMetaData;
    private ProjectedColumns m_projectedColumns;
    private IResultClass m_currentResultClass;
    private ResultSet m_currentResultSet;
    private IResultSet m_driverResultSet;
    private boolean m_updateProjectedColumns;
    private Hashtable m_namedProjectedColumns;
    private Hashtable m_namedCurrentResultClasses;
    private Hashtable m_namedCurrentResultSets;
    private HashSet m_updateNamedProjectedColumns;
    private static final int UNKNOWN = -1;
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private static String sm_className;
    private static String sm_loggerName;
    private static LogHelper sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.PreparedStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.PreparedStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_className = clazz2.getName();
        sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }

    PreparedStatement(IQuery statement, String dataSetType, Connection connection, String query) {
        String methodName = "PreparedStatement";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{statement, dataSetType, connection, query});
        }
        if (!($assertionsDisabled || statement != null && connection != null)) {
            throw new AssertionError();
        }
        this.m_statement = statement;
        this.m_dataSetType = dataSetType;
        this.m_connection = connection;
        this.m_queryText = query;
        this.m_supportsNamedResults = -1;
        this.m_supportsOutputParameters = -1;
        this.m_supportsNamedParameters = -1;
        this.m_supportsInputParameters = null;
        sm_logger.exiting(sm_className, methodName, this);
    }

    public void setProperty(String name, String value) throws DataException {
        String methodName = "setProperty";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{name, value});
        }
        this.doSetProperty(name, value);
        this.getPropertiesList().add(new Property(name, value));
        sm_logger.exiting(sm_className, methodName);
    }

    private void doSetProperty(String name, String value) throws DataException {
        String methodName = "doSetProperty";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{name, value});
        }
        try {
            this.m_statement.setProperty(name, value);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot set statement property.", ex);
            throw new DataException("odaconsumer.CannotSetStatementProperty", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, methodName, "Cannot set statement property.", ex);
        }
        sm_logger.exiting(sm_className, methodName);
    }

    private ArrayList getPropertiesList() {
        if (this.m_properties == null) {
            this.m_properties = new ArrayList();
        }
        return this.m_properties;
    }

    public void setSortSpec(SortSpec sortBy) throws DataException {
        String methodName = "setSortSpec";
        sm_logger.entering(sm_className, methodName, sortBy);
        this.doSetSortSpec(sortBy);
        this.getSortSpecsList().add(sortBy);
        sm_logger.exiting(sm_className, methodName);
    }

    private void doSetSortSpec(SortSpec sortBy) throws DataException {
        String methodName = "doSetSortSpec";
        sm_logger.entering(sm_className, methodName, sortBy);
        try {
            this.m_statement.setSortSpec(sortBy);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot set sort spec.", ex);
            throw new DataException("odaconsumer.CannotSetSortSpec", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot set sort spec.", ex);
            throw new DataException("odaconsumer.CannotSetSortSpec", ex);
        }
        sm_logger.exiting(sm_className, methodName);
    }

    private ArrayList getSortSpecsList() {
        if (this.m_sortSpecs == null) {
            this.m_sortSpecs = new ArrayList();
        }
        return this.m_sortSpecs;
    }

    public void setMaxRows(int max) throws DataException {
        String methodName = "setMaxRows";
        sm_logger.entering(sm_className, methodName, max);
        this.doSetMaxRows(max);
        this.m_maxRows = max;
        sm_logger.exiting(sm_className, methodName);
    }

    private void doSetMaxRows(int max) throws DataException {
        String methodName = "doSetMaxRows";
        sm_logger.entering(sm_className, methodName, max);
        try {
            this.m_statement.setMaxRows(max);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot set max rows.", ex);
            throw new DataException("odaconsumer.CannotSetMaxRows", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, methodName, "Cannot set max rows.", ex);
        }
        sm_logger.exiting(sm_className, methodName);
    }

    public IResultClass getMetaData() throws DataException {
        String methodName = "getMetaData";
        sm_logger.entering(sm_className, methodName);
        IResultClass ret = null;
        ret = this.m_currentResultSet != null ? this.m_currentResultSet.getMetaData() : this.doGetMetaData();
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    private IResultClass doGetMetaData() throws DataException {
        String methodName = "doGetMetaData";
        sm_logger.entering(sm_className, methodName);
        if (this.m_currentResultClass == null) {
            List projectedColumns = this.getProjectedColumns().getColumnsMetadata();
            this.m_currentResultClass = this.doGetResultClass(projectedColumns);
        }
        sm_logger.exiting(sm_className, methodName, this.m_currentResultClass);
        return this.m_currentResultClass;
    }

    private ResultClass doGetResultClass(List projectedColumns) throws DataException {
        String methodName = "doGetResultClass";
        sm_logger.entering(sm_className, methodName, projectedColumns);
        if (!$assertionsDisabled && projectedColumns == null) {
            throw new AssertionError();
        }
        ResultClass ret = new ResultClass(projectedColumns);
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    private ProjectedColumns getProjectedColumns() throws DataException {
        String methodName = "getProjectedColumns";
        sm_logger.entering(sm_className, methodName);
        if (this.m_projectedColumns == null) {
            IResultSetMetaData odaMetadata = this.getRuntimeMetaData();
            this.m_projectedColumns = this.doGetProjectedColumns(odaMetadata);
        } else if (this.m_updateProjectedColumns) {
            IResultSetMetaData odaMetadata = this.getRuntimeMetaData();
            ProjectedColumns newProjectedColumns = this.doGetProjectedColumns(odaMetadata);
            this.updateProjectedColumns(newProjectedColumns, this.m_projectedColumns);
            this.m_projectedColumns = newProjectedColumns;
            this.m_updateProjectedColumns = false;
        }
        sm_logger.exiting(sm_className, methodName, this.m_projectedColumns);
        return this.m_projectedColumns;
    }

    private IResultSetMetaData getRuntimeMetaData() throws DataException {
        String methodName = "getRuntimeMetaData";
        sm_logger.entering(sm_className, methodName);
        try {
            IResultSetMetaData ret = this.m_statement.getMetaData();
            sm_logger.exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get resultset metadata.", ex);
            throw new DataException("odaconsumer.CannotGetResultSetMetaData", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get resultset metadata.", ex);
            throw new DataException("odaconsumer.CannotGetResultSetMetaData", ex);
        }
    }

    private ProjectedColumns doGetProjectedColumns(IResultSetMetaData odaMetadata) throws DataException {
        String methodName = "doGetProjectedColumns";
        sm_logger.entering(sm_className, methodName, odaMetadata);
        ResultSetMetaData metadata = new ResultSetMetaData(odaMetadata, this.m_connection.getDataSourceId(), this.m_dataSetType);
        ProjectedColumns ret = new ProjectedColumns(metadata);
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    public IResultClass getMetaData(String resultSetName) throws DataException {
        String methodName = "getMetaData";
        sm_logger.entering(sm_className, methodName, resultSetName);
        this.checkNamedResultsSupport();
        ResultSet resultset = (ResultSet)this.getNamedCurrentResultSets().get(resultSetName);
        IResultClass ret = null;
        ret = resultset != null ? resultset.getMetaData() : this.doGetMetaData(resultSetName);
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    private IResultClass doGetMetaData(String resultSetName) throws DataException {
        String methodName = "doGetMetaData";
        sm_logger.entering(sm_className, methodName, resultSetName);
        IResultClass resultClass = (IResultClass)this.getNamedCurrentResultClasses().get(resultSetName);
        if (resultClass == null) {
            List projectedColumns = this.getProjectedColumns(resultSetName).getColumnsMetadata();
            resultClass = this.doGetResultClass(projectedColumns);
            this.getNamedCurrentResultClasses().put(resultSetName, resultClass);
        }
        sm_logger.exiting(sm_className, methodName, resultClass);
        return resultClass;
    }

    private ProjectedColumns getProjectedColumns(String resultSetName) throws DataException {
        String methodName = "getProjectedColumns";
        sm_logger.entering(sm_className, methodName, resultSetName);
        ProjectedColumns projectedColumns = (ProjectedColumns)this.getNamedProjectedColumns().get(resultSetName);
        if (projectedColumns == null) {
            IResultSetMetaData odaMetadata = this.getRuntimeMetaData(resultSetName);
            projectedColumns = this.doGetProjectedColumns(odaMetadata);
            this.getNamedProjectedColumns().put(resultSetName, projectedColumns);
        } else if (this.m_updateNamedProjectedColumns != null && this.m_updateNamedProjectedColumns.contains(resultSetName)) {
            IResultSetMetaData odaMetadata = this.getRuntimeMetaData(resultSetName);
            ProjectedColumns newProjectedColumns = this.doGetProjectedColumns(odaMetadata);
            this.updateProjectedColumns(newProjectedColumns, projectedColumns);
            this.getNamedProjectedColumns().put(resultSetName, newProjectedColumns);
            this.m_updateNamedProjectedColumns.remove(resultSetName);
        }
        sm_logger.exiting(sm_className, methodName, projectedColumns);
        return projectedColumns;
    }

    private IResultSetMetaData getRuntimeMetaData(String resultSetName) throws DataException {
        String methodName = "getRuntimeMetaData";
        sm_logger.entering(sm_className, methodName, resultSetName);
        try {
            IResultSetMetaData ret = this.getAdvancedStatement().getMetaDataOf(resultSetName);
            sm_logger.exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get metadata for named resultset.", ex);
            throw new DataException("odaconsumer.CannotGetMetaDataForNamedResultSet", (Throwable)ex, resultSetName);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get metadata for named resultset.", ex);
            throw new DataException("odaconsumer.CannotGetMetaDataForNamedResultSet", (Throwable)ex, resultSetName);
        }
    }

    public boolean execute() throws DataException {
        String methodName = "execute";
        sm_logger.entering(sm_className, methodName);
        this.resetCurrentResultSets();
        this.doGetMetaData();
        try {
            boolean ret = false;
            if (this.isAdvancedQuery()) {
                ret = this.getAdvancedStatement().execute();
            } else {
                this.m_driverResultSet = this.m_statement.executeQuery();
                ret = true;
            }
            if (sm_logger.isLoggingEnterExitLevel()) {
                sm_logger.exiting(sm_className, methodName, ret);
            }
            return ret;
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot execute statement.", ex);
            throw new DataException("odaconsumer.CannotExecuteStatement", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot execute statement.", ex);
            throw new DataException("odaconsumer.CannotExecuteStatement", ex);
        }
    }

    private void resetCurrentResultSets() {
        this.m_driverResultSet = null;
        this.m_currentResultSet = null;
        if (this.m_namedCurrentResultSets != null) {
            this.m_namedCurrentResultSets.clear();
        }
    }

    public ResultSet getResultSet() throws DataException {
        ResultSet rs;
        String methodName = "getResultSet";
        sm_logger.entering(sm_className, methodName);
        IResultSet resultSet = null;
        try {
            if (this.isAdvancedQuery()) {
                resultSet = this.getAdvancedStatement().getResultSet();
            } else {
                resultSet = this.m_driverResultSet;
                this.m_driverResultSet = null;
            }
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get resultset.", ex);
            throw new DataException("odaconsumer.CannotGetResultSet", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get resultset.", ex);
            throw new DataException("odaconsumer.CannotGetResultSet", ex);
        }
        this.m_currentResultSet = rs = new ResultSet(resultSet, this.doGetMetaData());
        this.m_currentResultClass = null;
        sm_logger.exiting(sm_className, methodName, rs);
        return rs;
    }

    public ResultSet getResultSet(String resultSetName) throws DataException {
        String methodName = "getResultSet";
        sm_logger.entering(sm_className, methodName, resultSetName);
        this.checkNamedResultsSupport();
        IResultSet resultset = null;
        try {
            resultset = this.getAdvancedStatement().getResultSet(resultSetName);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get named resultset.", ex);
            throw new DataException("odaconsumer.CannotGetNamedResultSet", (Throwable)ex, resultSetName);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get named resultset.", ex);
            throw new DataException("odaconsumer.CannotGetNamedResultSet", (Throwable)ex, resultSetName);
        }
        ResultSet rs = new ResultSet(resultset, this.doGetMetaData(resultSetName));
        this.getNamedCurrentResultSets().put(resultSetName, rs);
        this.getNamedCurrentResultClasses().remove(resultSetName);
        sm_logger.exiting(sm_className, methodName, rs);
        return rs;
    }

    public int findOutParameter(String paramName) throws DataException {
        String methodName = "findOutParameter";
        sm_logger.entering(sm_className, methodName, paramName);
        this.checkOutputParameterSupport();
        try {
            int ret = this.getAdvancedStatement().findOutParameter(paramName);
            sm_logger.exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot find out parameter.", ex);
            throw new DataException("odaconsumer.CannotFindOutParameter", (Throwable)ex, paramName);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot find out parameter.", ex);
            throw new DataException("odaconsumer.CannotFindOutParameter", (Throwable)ex, paramName);
        }
    }

    public int getParameterType(int paramIndex) throws DataException {
        String methodName = "getParameterType";
        sm_logger.entering(sm_className, methodName, paramIndex);
        ParameterMetaData paramMD = this.getParameterMetaData(paramIndex);
        if (!$assertionsDisabled && paramMD == null) {
            throw new AssertionError();
        }
        int ret = paramMD.getDataType();
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    public int getParameterType(String paramName) throws DataException {
        String methodName = "getParameterType";
        sm_logger.entering(sm_className, methodName, paramName);
        int paramIndex = this.getIndexFromParamHints(paramName);
        if (paramIndex <= 0) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get parameter type by name.");
            throw new DataException("odaconsumer.CannotGetParameterType", paramName);
        }
        int ret = this.getParameterType(paramIndex);
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    public Object getParameterValue(int paramIndex) throws DataException {
        String methodName = "getParameterValue";
        sm_logger.entering(sm_className, methodName, paramIndex);
        this.checkOutputParameterSupport();
        Object ret = this.getParameterValue(null, paramIndex);
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    public Object getParameterValue(String paramName) throws DataException {
        String methodName = "getParameterValue";
        sm_logger.entering(sm_className, methodName, paramName);
        this.checkOutputParameterSupport();
        Object ret = this.getParameterValue(paramName, 0);
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    public void close() throws DataException {
        String methodName = "close";
        sm_logger.entering(sm_className, methodName);
        this.resetCachedMetadata();
        try {
            this.m_statement.close();
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot close statement.", ex);
            throw new DataException("odaconsumer.CannotCloseStatement", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, methodName, "Cannot close statement.", ex);
        }
        sm_logger.exiting(sm_className, methodName);
    }

    private void resetCachedMetadata() {
        String methodName = "resetCachedMetaData";
        sm_logger.entering(sm_className, methodName);
        this.resetCurrentMetaData();
        if (this.m_namedCurrentResultSets != null) {
            this.m_namedCurrentResultSets.clear();
        }
        if (this.m_namedCurrentResultClasses != null) {
            this.m_namedCurrentResultClasses.clear();
        }
        sm_logger.exiting(sm_className, methodName);
    }

    public void addColumnHint(ColumnHint columnHint) throws DataException {
        String methodName = "addColumnHint";
        sm_logger.entering(sm_className, methodName, columnHint);
        if (columnHint != null) {
            this.getProjectedColumns().addHint(columnHint);
        }
        sm_logger.exiting(sm_className, methodName);
    }

    public void addColumnHint(String resultSetName, ColumnHint columnHint) throws DataException {
        String methodName = "addColumnHint";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{resultSetName, columnHint});
        }
        this.checkNamedResultsSupport();
        if (columnHint != null) {
            this.getProjectedColumns(resultSetName).addHint(columnHint);
        }
        sm_logger.exiting(sm_className, methodName);
    }

    private ArrayList getParameterHints() {
        if (this.m_parameterHints == null) {
            this.m_parameterHints = new ArrayList();
        }
        return this.m_parameterHints;
    }

    public void addParameterHint(ParameterHint paramHint) throws DataException {
        String methodName = "addParameterHint";
        sm_logger.entering(sm_className, methodName, paramHint);
        if (paramHint != null) {
            this.validateAndAddParameterHint(paramHint);
            this.m_parameterMetaData = null;
        }
        sm_logger.exiting(sm_className, methodName);
    }

    private void validateAndAddParameterHint(ParameterHint newParameterHint) throws DataException {
        String methodName = "validateAndAddParameterHint";
        sm_logger.entering(sm_className, methodName, newParameterHint);
        ArrayList parameterHintsList = this.getParameterHints();
        String newParamHintName = newParameterHint.getName();
        int newParamHintIndex = newParameterHint.getPosition();
        int i = 0;
        int n = parameterHintsList.size();
        while (i < n) {
            ParameterHint existingParamHint = (ParameterHint)parameterHintsList.get(i);
            String existingParamHintName = existingParamHint.getName();
            if (!existingParamHintName.equals(newParamHintName)) {
                int existingParamHintPosition = existingParamHint.getPosition();
                if (newParamHintIndex != 0 && existingParamHintPosition == newParamHintIndex) {
                    sm_logger.logp(Level.SEVERE, sm_className, methodName, "Different parameter name {0} for same position {1}.", new Object[]{existingParamHintName, new Integer(existingParamHintPosition)});
                    throw new DataException("odaconsumer.DifferentParamNameForSamePosition", new Object[]{existingParamHintName, new Integer(existingParamHintPosition)});
                }
            } else {
                int existingParamHintIndex = existingParamHint.getPosition();
                if (existingParamHintIndex != newParamHintIndex && existingParamHintIndex > 0 && newParamHintIndex > 0) {
                    sm_logger.logp(Level.SEVERE, sm_className, methodName, "Same parameter name {0} for different hints.", existingParamHintName);
                    throw new DataException("odaconsumer.SameParamNameForDifferentHints", existingParamHintName);
                }
                existingParamHint.updateHint(newParameterHint);
                sm_logger.exiting(sm_className, methodName);
                return;
            }
            ++i;
        }
        parameterHintsList.add(newParameterHint);
        sm_logger.exiting(sm_className, methodName);
    }

    public void setColumnsProjection(String[] projectedNames) throws DataException {
        String methodName = "setColumnsProjection";
        sm_logger.entering(sm_className, methodName, projectedNames);
        this.resetCurrentMetaData();
        this.getProjectedColumns().setProjectedNames(projectedNames);
        sm_logger.exiting(sm_className, methodName);
    }

    public void setColumnsProjection(String resultSetName, String[] projectedNames) throws DataException {
        String methodName = "setColumnsProjection";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{resultSetName, projectedNames});
        }
        this.checkNamedResultsSupport();
        this.resetCurrentMetaData(resultSetName);
        this.getProjectedColumns(resultSetName).setProjectedNames(projectedNames);
        sm_logger.exiting(sm_className, methodName);
    }

    public void declareCustomColumn(String columnName, Class columnType) throws DataException {
        String methodName = "declareCustomColumn";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{columnName, columnType});
        }
        if (!$assertionsDisabled && columnName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && columnName.length() == 0) {
            throw new AssertionError();
        }
        this.resetCurrentMetaData();
        this.getProjectedColumns().addCustomColumn(columnName, columnType);
        sm_logger.exiting(sm_className, methodName);
    }

    public void declareCustomColumn(String resultSetName, String columnName, Class columnType) throws DataException {
        String methodName = "declareCustomColumn";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{resultSetName, columnName, columnType});
        }
        this.checkNamedResultsSupport();
        if (!$assertionsDisabled && columnName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && columnName.length() == 0) {
            throw new AssertionError();
        }
        this.resetCurrentMetaData(resultSetName);
        this.getProjectedColumns(resultSetName).addCustomColumn(columnName, columnType);
        sm_logger.exiting(sm_className, methodName);
    }

    private void resetCurrentMetaData() {
        String methodName = "resetCurrentMetaData";
        sm_logger.entering(sm_className, methodName);
        this.m_currentResultClass = null;
        this.m_currentResultSet = null;
        sm_logger.exiting(sm_className, methodName);
    }

    private void resetCurrentMetaData(String resultSetName) {
        String methodName = "resetCurrentMetaData";
        sm_logger.entering(sm_className, methodName, resultSetName);
        this.getNamedCurrentResultClasses().remove(resultSetName);
        this.getNamedCurrentResultSets().remove(resultSetName);
        sm_logger.exiting(sm_className, methodName);
    }

    private Hashtable getNamedProjectedColumns() {
        if (this.m_namedProjectedColumns == null) {
            this.m_namedProjectedColumns = new Hashtable();
        }
        return this.m_namedProjectedColumns;
    }

    private Hashtable getNamedCurrentResultClasses() {
        if (this.m_namedCurrentResultClasses == null) {
            this.m_namedCurrentResultClasses = new Hashtable();
        }
        return this.m_namedCurrentResultClasses;
    }

    private Hashtable getNamedCurrentResultSets() {
        if (this.m_namedCurrentResultSets == null) {
            this.m_namedCurrentResultSets = new Hashtable();
        }
        return this.m_namedCurrentResultSets;
    }

    private IQuery getStatement() {
        return this.m_statement;
    }

    private IAdvancedQuery getAdvancedStatement() {
        if (!$assertionsDisabled && !this.isAdvancedQuery()) {
            throw new AssertionError();
        }
        return (IAdvancedQuery)this.m_statement;
    }

    private boolean isAdvancedQuery() {
        return this.m_statement instanceof IAdvancedQuery;
    }

    private boolean supportsNamedResults() throws DataException {
        String methodName = "supportsNamedResults";
        sm_logger.entering(sm_className, methodName);
        if (this.m_supportsNamedResults != -1) {
            boolean ret;
            boolean bl = ret = this.m_supportsNamedResults == 1;
            if (sm_logger.isLoggingEnterExitLevel()) {
                sm_logger.exiting(sm_className, methodName, ret);
            }
            return ret;
        }
        boolean b = this.m_connection.getMetaData(this.m_dataSetType).supportsNamedResultSets();
        int n = this.m_supportsNamedResults = b ? 1 : 0;
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.exiting(sm_className, methodName, b);
        }
        return b;
    }

    private boolean supportsInputParameter() throws DataException {
        String methodName = "supportsInputParameter";
        sm_logger.entering(sm_className, methodName);
        if (this.m_supportsInputParameters == null) {
            this.m_supportsInputParameters = this.m_connection.getMetaData(this.m_dataSetType).supportsInParameters();
        }
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.exiting(sm_className, methodName, this.m_supportsInputParameters);
        }
        return this.m_supportsInputParameters;
    }

    private boolean supportsOutputParameter() throws DataException {
        String methodName = "supportsOutputParameter";
        sm_logger.entering(sm_className, methodName);
        if (this.m_supportsOutputParameters != -1) {
            boolean ret;
            boolean bl = ret = this.m_supportsOutputParameters == 1;
            if (sm_logger.isLoggingEnterExitLevel()) {
                sm_logger.exiting(sm_className, methodName, ret);
            }
            return ret;
        }
        boolean b = this.m_connection.getMetaData(this.m_dataSetType).supportsOutParameters();
        int n = this.m_supportsOutputParameters = b ? 1 : 0;
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.exiting(sm_className, methodName, b);
        }
        return b;
    }

    private boolean supportsNamedParameter() throws DataException {
        String methodName = "supportsNamedParameter";
        sm_logger.entering(sm_className, methodName);
        if (this.m_supportsNamedParameters != -1) {
            boolean ret;
            boolean bl = ret = this.m_supportsNamedParameters == 1;
            if (sm_logger.isLoggingEnterExitLevel()) {
                sm_logger.exiting(sm_className, methodName, ret);
            }
            return ret;
        }
        boolean b = this.m_connection.getMetaData(this.m_dataSetType).supportsNamedParameters();
        int n = this.m_supportsNamedParameters = b ? 1 : 0;
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.exiting(sm_className, methodName, b);
        }
        return b;
    }

    private void checkNamedResultsSupport() throws DataException {
        String methodName = "checkNamedResultsSupport";
        if (!this.isAdvancedQuery() || !this.supportsNamedResults()) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Named resultsets is not supported.");
            throw new DataException("odaconsumer.NamedResultSetsUnsupported", new UnsupportedOperationException());
        }
    }

    public Collection getParameterMetaData() throws DataException {
        String methodName = "getParameterMetaData";
        sm_logger.entering(sm_className, methodName);
        if (this.m_parameterMetaData == null) {
            IParameterMetaData odaParamMetaData;
            block4: {
                if (!this.supportsInputParameter() && !this.supportsOutputParameter()) {
                    sm_logger.logp(Level.INFO, sm_className, methodName, "The ODA driver does not support any type of parameters (IDataSetMetaData); no metadata is available.");
                    sm_logger.exiting(sm_className, methodName, null);
                    return null;
                }
                odaParamMetaData = null;
                try {
                    odaParamMetaData = this.getOdaDriverParamMetaData();
                }
                catch (DataException e) {
                    if (this.m_parameterHints != null && this.m_parameterHints.size() > 0) break block4;
                    throw e;
                }
            }
            this.m_parameterMetaData = odaParamMetaData == null ? this.mergeParamHints() : this.mergeParamHintsWithMetaData(odaParamMetaData);
        }
        sm_logger.exiting(sm_className, methodName, this.m_parameterMetaData);
        return this.m_parameterMetaData;
    }

    private ParameterMetaData getParameterMetaData(int paramIndex) throws DataException {
        String methodName = "getParameterMetaData";
        sm_logger.entering(sm_className, methodName, paramIndex);
        Collection allParamsMetadata = null;
        if (paramIndex > 0) {
            allParamsMetadata = this.getParameterMetaData();
        }
        if (allParamsMetadata != null) {
            Iterator paramMDIter = allParamsMetadata.iterator();
            while (paramMDIter.hasNext()) {
                ParameterMetaData aParamMetaData = (ParameterMetaData)paramMDIter.next();
                if (aParamMetaData.getPosition() != paramIndex) continue;
                sm_logger.exiting(sm_className, methodName, aParamMetaData);
                return aParamMetaData;
            }
        }
        throw new DataException("odaconsumer.CannotGetParameterMetaData", new Integer(paramIndex));
    }

    private IParameterMetaData getOdaDriverParamMetaData() throws DataException {
        String methodName = "getOdaDriverParamMetaData";
        sm_logger.entering(sm_className, methodName);
        IParameterMetaData odaParamMetaData = null;
        try {
            odaParamMetaData = this.m_statement.getParameterMetaData();
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get driver's parameter metadata.", ex);
            throw new DataException("odaconsumer.CannotGetParameterMetaData", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, methodName, "The ODA driver is not capable of providing parameter metadata.", ex);
        }
        sm_logger.exiting(sm_className, methodName, odaParamMetaData);
        return odaParamMetaData;
    }

    private Collection mergeParamHints() throws DataException {
        String methodName = "mergeParamHints";
        sm_logger.entering(sm_className, methodName);
        ArrayList parameterMetaData = null;
        if (this.m_parameterHints != null && this.m_parameterHints.size() > 0) {
            parameterMetaData = new ArrayList();
            this.addParameterHints(parameterMetaData, this.m_parameterHints);
        }
        sm_logger.exiting(sm_className, methodName, parameterMetaData);
        return parameterMetaData;
    }

    private void addParameterHints(List parameterMetaData, List parameterHints) {
        String methodName = "addParameterHints";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{parameterMetaData, parameterHints});
        }
        ListIterator iter = parameterHints.listIterator();
        while (iter.hasNext()) {
            ParameterHint paramHint = (ParameterHint)iter.next();
            ParameterMetaData paramMd = new ParameterMetaData(paramHint, this.m_connection.getDataSourceId(), this.m_dataSetType);
            parameterMetaData.add(paramMd);
        }
        sm_logger.exiting(sm_className, methodName);
    }

    private Collection mergeParamHintsWithMetaData(IParameterMetaData runtimeParamMetaData) throws DataException {
        String methodName = "mergeParamHintsWithMetaData";
        sm_logger.entering(sm_className, methodName, runtimeParamMetaData);
        if (!$assertionsDisabled && runtimeParamMetaData == null) {
            throw new AssertionError();
        }
        int numOfParameters = this.doGetParameterCount(runtimeParamMetaData);
        ArrayList<ParameterMetaData> paramMetaData = new ArrayList<ParameterMetaData>(numOfParameters);
        int i = 1;
        while (i <= numOfParameters) {
            ParameterMetaData paramMd = new ParameterMetaData(runtimeParamMetaData, i, this.m_connection.getDataSourceId(), this.m_dataSetType);
            paramMetaData.add(paramMd);
            ++i;
        }
        if (this.m_parameterHints != null && this.m_parameterHints.size() > 0) {
            this.updateWithParameterHints(paramMetaData, this.m_parameterHints);
        }
        sm_logger.exiting(sm_className, methodName, paramMetaData);
        return paramMetaData;
    }

    private int doGetParameterCount(IParameterMetaData runtimeParamMetaData) throws DataException {
        String methodName = "doGetParameterCount";
        sm_logger.entering(sm_className, methodName, runtimeParamMetaData);
        try {
            int ret = runtimeParamMetaData.getParameterCount();
            sm_logger.exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get parameter count.", ex);
            throw new DataException("odaconsumer.CannotGetParameterCount", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get parameter count.", ex);
            throw new DataException("odaconsumer.CannotGetParameterCount", ex);
        }
    }

    private void updateWithParameterHints(List parameterMetaData, List parameterHints) throws DataException {
        String methodName = "updateWithParameterHints";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{parameterMetaData, parameterHints});
        }
        if (!$assertionsDisabled && parameterHints == null) {
            throw new AssertionError();
        }
        int numOfRuntimeParameters = parameterMetaData.size();
        ListIterator iter = parameterHints.listIterator();
        while (iter.hasNext()) {
            ParameterHint paramHint = (ParameterHint)iter.next();
            String paramHintName = paramHint.getName();
            int position = 0;
            if (paramHint.isInputMode()) {
                position = this.getRuntimeParameterIndexFromName(paramHintName, true);
            }
            if (position <= 0 || position > numOfRuntimeParameters) {
                if (paramHint.isOutputMode()) {
                    position = this.getRuntimeParameterIndexFromName(paramHintName, false);
                }
                if (!(position > 0 && position <= numOfRuntimeParameters || (position = paramHint.getPosition()) > 0 && position <= numOfRuntimeParameters)) continue;
            }
            ParameterMetaData paramMd = (ParameterMetaData)parameterMetaData.get(position - 1);
            paramMd.updateWith(paramHint, this.m_connection.getDataSourceId(), this.m_dataSetType);
        }
        sm_logger.exiting(sm_className, methodName);
    }

    private int getRuntimeParameterIndexFromName(String paramName, boolean forInput) throws DataException {
        String methodName = "getRuntimeParameterIndexFromName";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{paramName, forInput});
        }
        if (forInput) {
            try {
                int ret = this.findInParameter(paramName);
                sm_logger.exiting(sm_className, methodName, ret);
                return ret;
            }
            catch (DataException ex) {
                if (ex.getCause() instanceof UnsupportedOperationException) {
                    sm_logger.exiting(sm_className, methodName, 0);
                    return 0;
                }
                sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get runtime parameter index.", (Throwable)((Object)ex));
                throw ex;
            }
        }
        try {
            int ret = this.findOutParameter(paramName);
            sm_logger.exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (DataException ex) {
            if (ex.getCause() instanceof UnsupportedOperationException) {
                sm_logger.exiting(sm_className, methodName, 0);
                return 0;
            }
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get runtime parameter index.", (Throwable)((Object)ex));
            throw ex;
        }
    }

    private void checkOutputParameterSupport() throws DataException {
        String methodName = "checkOutputParameterSupport";
        if (!this.isAdvancedQuery() || !this.supportsOutputParameter()) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Output parameters is not supported.");
            throw new DataException("odaconsumer.OutputParameterUnsupported", new UnsupportedOperationException());
        }
    }

    private Object getParameterValue(String paramName, int paramIndex) throws DataException {
        String methodName = "getParameterValue";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{paramName, new Integer(paramIndex)});
        }
        this.checkOutputParameterSupport();
        Object paramValue = null;
        int paramType = paramName == null ? this.getParameterType(paramIndex) : this.getParameterType(paramName);
        switch (paramType) {
            case 4: {
                int i;
                int n = i = paramName == null ? this.doGetInt(paramIndex) : this.getInt(paramName);
                if (this.wasNull()) break;
                paramValue = new Integer(i);
                break;
            }
            case 8: {
                double d;
                double d2 = d = paramName == null ? this.doGetDouble(paramIndex) : this.getDouble(paramName);
                if (this.wasNull()) break;
                paramValue = new Double(d);
                break;
            }
            case 1: {
                paramValue = paramName == null ? this.doGetString(paramIndex) : this.getString(paramName);
                break;
            }
            case 3: {
                paramValue = paramName == null ? this.doGetBigDecimal(paramIndex) : this.getBigDecimal(paramName);
                break;
            }
            case 91: {
                paramValue = paramName == null ? this.doGetDate(paramIndex) : this.getDate(paramName);
                break;
            }
            case 92: {
                paramValue = paramName == null ? this.doGetTime(paramIndex) : this.getTime(paramName);
                break;
            }
            case 93: {
                paramValue = paramName == null ? this.doGetTimestamp(paramIndex) : this.getTimestamp(paramName);
                break;
            }
            case 2004: {
                paramValue = paramName == null ? this.doGetBlob(paramIndex) : this.getBlob(paramName);
                break;
            }
            case 2005: {
                paramValue = paramName == null ? this.doGetClob(paramIndex) : this.getClob(paramName);
                break;
            }
            case 16: {
                paramValue = paramName == null ? this.doGetBoolean(paramIndex) : this.getBoolean(paramName);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        Object ret = this.wasNull() ? null : paramValue;
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    private int getInt(String paramName) throws DataException {
        String methodName = "getInt";
        sm_logger.entering(sm_className, methodName, paramName);
        int ret = 0;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName);
            if (paramIndex > 0) {
                ret = this.doGetInt(paramIndex);
            }
        } else {
            ret = this.doGetInt(paramName);
        }
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    private double getDouble(String paramName) throws DataException {
        String methodName = "getDouble";
        sm_logger.entering(sm_className, methodName, paramName);
        double ret = 0.0;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName);
            if (paramIndex > 0) {
                ret = this.doGetDouble(paramIndex);
            }
        } else {
            ret = this.doGetDouble(paramName);
        }
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.exiting(sm_className, methodName, new Double(ret));
        }
        return ret;
    }

    private String getString(String paramName) throws DataException {
        String methodName = "getString";
        sm_logger.entering(sm_className, methodName, paramName);
        String ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName);
            if (paramIndex > 0) {
                ret = this.doGetString(paramIndex);
            }
        } else {
            ret = this.doGetString(paramName);
        }
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    private BigDecimal getBigDecimal(String paramName) throws DataException {
        String methodName = "getBigDecimal";
        sm_logger.entering(sm_className, methodName, paramName);
        BigDecimal ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName);
            if (paramIndex > 0) {
                ret = this.doGetBigDecimal(paramIndex);
            }
        } else {
            ret = this.doGetBigDecimal(paramName);
        }
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    private java.util.Date getDate(String paramName) throws DataException {
        String methodName = "getDate";
        sm_logger.entering(sm_className, methodName, paramName);
        java.util.Date ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName);
            if (paramIndex > 0) {
                ret = this.doGetDate(paramIndex);
            }
        } else {
            ret = this.doGetDate(paramName);
        }
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    private Time getTime(String paramName) throws DataException {
        String methodName = "getTime";
        sm_logger.entering(sm_className, methodName, paramName);
        Time ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName);
            if (paramIndex > 0) {
                ret = this.doGetTime(paramIndex);
            }
        } else {
            ret = this.doGetTime(paramName);
        }
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    private Timestamp getTimestamp(String paramName) throws DataException {
        String methodName = "getTimestamp";
        sm_logger.entering(sm_className, methodName, paramName);
        Timestamp ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName);
            if (paramIndex > 0) {
                ret = this.doGetTimestamp(paramIndex);
            }
        } else {
            ret = this.doGetTimestamp(paramName);
        }
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    private IBlob getBlob(String paramName) throws DataException {
        sm_logger.entering(sm_className, "getBlob", paramName);
        IBlob ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName);
            if (paramIndex > 0) {
                ret = this.doGetBlob(paramIndex);
            }
        } else {
            ret = this.doGetBlob(paramName);
        }
        sm_logger.exiting(sm_className, "getBlob", ret);
        return ret;
    }

    private IClob getClob(String paramName) throws DataException {
        sm_logger.entering(sm_className, "getClob", paramName);
        IClob ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName);
            if (paramIndex > 0) {
                ret = this.doGetClob(paramIndex);
            }
        } else {
            ret = this.doGetClob(paramName);
        }
        sm_logger.exiting(sm_className, "getClob", ret);
        return ret;
    }

    private Boolean getBoolean(String paramName) throws DataException {
        sm_logger.entering(sm_className, "getBoolean( String )", paramName);
        Boolean ret = null;
        if (!this.supportsNamedParameter()) {
            int paramIndex = this.getIndexFromParamHints(paramName);
            if (paramIndex > 0) {
                ret = this.doGetBoolean(paramIndex);
            }
        } else {
            ret = this.doGetBoolean(paramName);
        }
        sm_logger.exiting(sm_className, "getBoolean( String )", ret);
        return ret;
    }

    private int doGetInt(int paramIndex) throws DataException {
        sm_logger.entering(sm_className, "doGetInt( int )", paramIndex);
        try {
            int ret = this.getAdvancedStatement().getInt(paramIndex);
            sm_logger.exiting(sm_className, "doGetInt( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetIntFromParameter", "doGetInt( int )", paramIndex);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetIntFromParameter", "doGetInt( int )", paramIndex);
        }
        return 0;
    }

    private int doGetInt(String paramName) throws DataException {
        sm_logger.entering(sm_className, "doGetInt( String )", paramName);
        try {
            int ret = this.getAdvancedStatement().getInt(paramName);
            sm_logger.exiting(sm_className, "doGetInt( String )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetIntFromParameter", "doGetInt( String )", (Object)paramName);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetIntFromParameter", "doGetInt( String )", (Object)paramName);
        }
        return 0;
    }

    private double doGetDouble(int paramIndex) throws DataException {
        sm_logger.entering(sm_className, "doGetDouble( int )", paramIndex);
        try {
            double ret = this.getAdvancedStatement().getDouble(paramIndex);
            if (sm_logger.isLoggingEnterExitLevel()) {
                sm_logger.exiting(sm_className, "doGetDouble( int )", new Double(ret));
            }
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetDoubleFromParameter", "doGetDouble( int )", paramIndex);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetDoubleFromParameter", "doGetDouble( int )", paramIndex);
        }
        return 0.0;
    }

    private double doGetDouble(String paramName) throws DataException {
        sm_logger.entering(sm_className, "doGetDouble( String )", paramName);
        try {
            double ret = this.getAdvancedStatement().getDouble(paramName);
            if (sm_logger.isLoggingEnterExitLevel()) {
                sm_logger.exiting(sm_className, "doGetDouble( String )", new Double(ret));
            }
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetDoubleFromParameter", "doGetDouble( String )", (Object)paramName);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetDoubleFromParameter", "doGetDouble( String )", (Object)paramName);
        }
        return 0.0;
    }

    private String doGetString(int paramIndex) throws DataException {
        sm_logger.entering(sm_className, "doGetString( int )", paramIndex);
        try {
            String ret = this.getAdvancedStatement().getString(paramIndex);
            sm_logger.exiting(sm_className, "doGetString( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetStringFromParameter", "doGetString( int )", paramIndex);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetStringFromParameter", "doGetString( int )", paramIndex);
        }
        return null;
    }

    private String doGetString(String paramName) throws DataException {
        sm_logger.entering(sm_className, "doGetString( String )", paramName);
        try {
            String ret = this.getAdvancedStatement().getString(paramName);
            sm_logger.exiting(sm_className, "doGetString( String )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetStringFromParameter", "doGetString( String )", (Object)paramName);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetStringFromParameter", "doGetString( String )", (Object)paramName);
        }
        return null;
    }

    private BigDecimal doGetBigDecimal(int paramIndex) throws DataException {
        sm_logger.entering(sm_className, "doGetBigDecimal( int )", paramIndex);
        try {
            BigDecimal ret = this.getAdvancedStatement().getBigDecimal(paramIndex);
            sm_logger.exiting(sm_className, "doGetBigDecimal( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetBigDecimalFromParameter", "doGetBigDecimal( int )", paramIndex);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetBigDecimalFromParameter", "doGetBigDecimal( int )", paramIndex);
        }
        return null;
    }

    private BigDecimal doGetBigDecimal(String paramName) throws DataException {
        sm_logger.entering(sm_className, "doGetBigDecimal( String )", paramName);
        try {
            BigDecimal ret = this.getAdvancedStatement().getBigDecimal(paramName);
            sm_logger.exiting(sm_className, "doGetBigDecimal( String )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetBigDecimalFromParameter", "doGetBigDecimal( String )", (Object)paramName);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetBigDecimalFromParameter", "doGetBigDecimal( String )", (Object)paramName);
        }
        return null;
    }

    private java.util.Date doGetDate(int paramIndex) throws DataException {
        sm_logger.entering(sm_className, "doGetDate( int )", paramIndex);
        try {
            Date ret = this.getAdvancedStatement().getDate(paramIndex);
            sm_logger.exiting(sm_className, "doGetDate( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetDateFromParameter", "doGetDate( int )", paramIndex);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetDateFromParameter", "doGetDate( int )", paramIndex);
        }
        return null;
    }

    private java.util.Date doGetDate(String paramName) throws DataException {
        sm_logger.entering(sm_className, "doGetDate( String )", paramName);
        try {
            Date ret = this.getAdvancedStatement().getDate(paramName);
            sm_logger.exiting(sm_className, "doGetDate( String )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetDateFromParameter", "doGetDate( String )", (Object)paramName);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetDateFromParameter", "doGetDate( String )", (Object)paramName);
        }
        return null;
    }

    private Time doGetTime(int paramIndex) throws DataException {
        sm_logger.entering(sm_className, "doGetTime( int )", paramIndex);
        try {
            Time ret = this.getAdvancedStatement().getTime(paramIndex);
            sm_logger.exiting(sm_className, "doGetTime( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetTimeFromParameter", "doGetTime( int )", paramIndex);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetTimeFromParameter", "doGetTime( int )", paramIndex);
        }
        return null;
    }

    private Time doGetTime(String paramName) throws DataException {
        sm_logger.entering(sm_className, "doGetTime( String )", paramName);
        try {
            Time ret = this.getAdvancedStatement().getTime(paramName);
            sm_logger.exiting(sm_className, "doGetTime( String )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetTimeFromParameter", "doGetTime( String )", (Object)paramName);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetTimeFromParameter", "doGetTime( String )", (Object)paramName);
        }
        return null;
    }

    private Timestamp doGetTimestamp(int paramIndex) throws DataException {
        sm_logger.entering(sm_className, "doGetTimestamp( int )", paramIndex);
        try {
            Timestamp ret = this.getAdvancedStatement().getTimestamp(paramIndex);
            sm_logger.exiting(sm_className, "doGetTimestamp( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetTimestampFromParameter", "doGetTimestamp( int )", paramIndex);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetTimestampFromParameter", "doGetTimestamp( int )", paramIndex);
        }
        return null;
    }

    private Timestamp doGetTimestamp(String paramName) throws DataException {
        sm_logger.entering(sm_className, "doGetTimestamp( String )", paramName);
        try {
            Timestamp ret = this.getAdvancedStatement().getTimestamp(paramName);
            sm_logger.exiting(sm_className, "doGetTimestamp( String )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetTimestampFromParameter", "doGetTimestamp( String )", (Object)paramName);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetTimestampFromParameter", "doGetTimestamp( String )", (Object)paramName);
        }
        return null;
    }

    private IBlob doGetBlob(int paramIndex) throws DataException {
        sm_logger.entering(sm_className, "doGetBlob( int )", paramIndex);
        try {
            IBlob ret = this.getAdvancedStatement().getBlob(paramIndex);
            sm_logger.exiting(sm_className, "doGetBlob( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.logAndThrowGetBlobParamException("doGetBlob( int )", new Integer(paramIndex), (Exception)((Object)ex));
        }
        catch (UnsupportedOperationException ex) {
            this.logAndThrowGetBlobParamException("doGetBlob( int )", new Integer(paramIndex), ex);
        }
        return null;
    }

    private IBlob doGetBlob(String paramName) throws DataException {
        sm_logger.entering(sm_className, "doGetBlob( String )", paramName);
        try {
            IBlob ret = this.getAdvancedStatement().getBlob(paramName);
            sm_logger.exiting(sm_className, "doGetBlob( String )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.logAndThrowGetBlobParamException("doGetBlob( String )", paramName, (Exception)((Object)ex));
        }
        catch (UnsupportedOperationException ex) {
            this.logAndThrowGetBlobParamException("doGetBlob( String )", paramName, ex);
        }
        return null;
    }

    private void logAndThrowGetBlobParamException(String methodName, Object parameterId, Exception ex) throws DataException {
        this.handleException((Throwable)ex, "odaconsumer.CannotGetBlobFromParameter", methodName, parameterId);
    }

    private IClob doGetClob(int paramIndex) throws DataException {
        sm_logger.entering(sm_className, "doGetClob( int )", paramIndex);
        try {
            IClob ret = this.getAdvancedStatement().getClob(paramIndex);
            sm_logger.exiting(sm_className, "doGetClob( int )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.logAndThrowGetClobParamException("doGetClob( int )", new Integer(paramIndex), (Exception)((Object)ex));
        }
        catch (UnsupportedOperationException ex) {
            this.logAndThrowGetClobParamException("doGetClob( int )", new Integer(paramIndex), ex);
        }
        return null;
    }

    private IClob doGetClob(String paramName) throws DataException {
        sm_logger.entering(sm_className, "doGetClob( String )", paramName);
        try {
            IClob ret = this.getAdvancedStatement().getClob(paramName);
            sm_logger.exiting(sm_className, "doGetClob( String )", ret);
            return ret;
        }
        catch (OdaException ex) {
            this.logAndThrowGetClobParamException("doGetClob( String )", paramName, (Exception)((Object)ex));
        }
        catch (UnsupportedOperationException ex) {
            this.logAndThrowGetClobParamException("doGetClob( String )", paramName, ex);
        }
        return null;
    }

    private void logAndThrowGetClobParamException(String methodName, Object parameterId, Exception ex) throws DataException {
        this.handleException((Throwable)ex, "odaconsumer.CannotGetClobFromParameter", methodName, parameterId);
    }

    private Boolean doGetBoolean(int paramIndex) throws DataException {
        sm_logger.entering(sm_className, "doGetBoolean( int )", paramIndex);
        try {
            boolean ret = this.getAdvancedStatement().getBoolean(paramIndex);
            Boolean retObj = this.wasNull() ? null : new Boolean(ret);
            sm_logger.exiting(sm_className, "doGetBoolean( int )", retObj);
            return retObj;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetBooleanFromParameter", "doGetBoolean( int )", paramIndex);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetBooleanFromParameter", "doGetBoolean( int )", paramIndex);
        }
        return null;
    }

    private Boolean doGetBoolean(String paramName) throws DataException {
        sm_logger.entering(sm_className, "doGetBoolean( String )", paramName);
        try {
            boolean ret = this.getAdvancedStatement().getBoolean(paramName);
            Boolean retObj = this.wasNull() ? null : new Boolean(ret);
            sm_logger.exiting(sm_className, "doGetBoolean( String )", retObj);
            return retObj;
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetBooleanFromParameter", "doGetBoolean( String )", (Object)paramName);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotGetBooleanFromParameter", "doGetBoolean( String )", (Object)paramName);
        }
        return null;
    }

    private boolean wasNull() throws DataException {
        try {
            return this.getAdvancedStatement().wasNull();
        }
        catch (OdaException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotDetermineWasNull", "wasNull", null);
        }
        catch (UnsupportedOperationException ex) {
            this.handleException((Throwable)ex, "odaconsumer.CannotDetermineWasNull", "wasNull", null);
        }
        return false;
    }

    private int getOdaTypeFromParamHints(String paramName, int paramIndex) {
        if (this.m_parameterHints == null) {
            return 1;
        }
        ListIterator iter = this.m_parameterHints.listIterator();
        boolean useParamName = paramName != null;
        while (iter.hasNext()) {
            ParameterHint paramHint = (ParameterHint)iter.next();
            if ((!useParamName || !paramHint.getName().equals(paramName)) && (useParamName || paramHint.getPosition() != paramIndex)) continue;
            return paramHint.getEffectiveOdaType(this.m_connection.getDataSourceId(), this.m_dataSetType);
        }
        return 1;
    }

    private int getIndexFromParamHints(String paramName) {
        if (this.m_parameterHints == null) {
            return 0;
        }
        ListIterator iter = this.m_parameterHints.listIterator();
        while (iter.hasNext()) {
            ParameterHint paramHint = (ParameterHint)iter.next();
            if (!paramHint.getName().equals(paramName)) continue;
            return paramHint.getPosition();
        }
        return 0;
    }

    public void clearParameterValues() throws DataException {
        String methodName = "clearParameterValues";
        sm_logger.entering(sm_className, methodName);
        try {
            this.getStatement().clearInParameters();
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot clear input parameters.", ex);
            throw new DataException("odaconsumer.CannotClearInParameters", ex);
        }
        catch (AbstractMethodError err) {
            sm_logger.logp(Level.WARNING, sm_className, methodName, "clearInParameters method undefined.", err);
            this.handleUnsupportedClearInParameters();
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, methodName, "clearInParameters is not supported.", ex);
            this.handleUnsupportedClearInParameters();
        }
        this.resetCachedMetadata();
        this.m_updateProjectedColumns = true;
        if (this.m_namedProjectedColumns != null) {
            Set keys = this.m_namedProjectedColumns.keySet();
            if (this.m_updateNamedProjectedColumns == null) {
                this.m_updateNamedProjectedColumns = new HashSet(keys);
            } else {
                this.m_updateNamedProjectedColumns.addAll(keys);
            }
        }
        sm_logger.exiting(sm_className, methodName);
    }

    private void handleUnsupportedClearInParameters() throws DataException {
        ListIterator iter;
        this.m_statement = this.m_connection.prepareOdaQuery(this.m_queryText, this.m_dataSetType);
        if (this.m_properties != null) {
            iter = this.m_properties.listIterator();
            while (iter.hasNext()) {
                Property property = (Property)iter.next();
                this.doSetProperty(property.getName(), property.getValue());
            }
        }
        this.doSetMaxRows(this.m_maxRows);
        if (this.m_sortSpecs != null) {
            iter = this.m_sortSpecs.listIterator();
            while (iter.hasNext()) {
                SortSpec sortBy = (SortSpec)iter.next();
                this.doSetSortSpec(sortBy);
            }
        }
    }

    private void updateProjectedColumns(ProjectedColumns newProjectedColumns, ProjectedColumns oldProjectedColumns) throws DataException {
        ListIterator iter;
        ArrayList customColumns = oldProjectedColumns.getCustomColumns();
        ArrayList columnHints = oldProjectedColumns.getColumnHints();
        String[] projections = oldProjectedColumns.getProjections();
        if (customColumns != null) {
            iter = customColumns.listIterator();
            while (iter.hasNext()) {
                CustomColumn customColumn = (CustomColumn)iter.next();
                newProjectedColumns.addCustomColumn(customColumn.getName(), customColumn.getType());
            }
        }
        if (columnHints != null) {
            iter = columnHints.listIterator();
            while (iter.hasNext()) {
                ColumnHint columnHint = (ColumnHint)iter.next();
                newProjectedColumns.addHint(columnHint);
            }
        }
        newProjectedColumns.setProjectedNames(projections);
    }

    public int findInParameter(String paramName) throws DataException {
        sm_logger.entering(sm_className, "findInParameter", paramName);
        try {
            int ret = this.getStatement().findInParameter(paramName);
            sm_logger.exiting(sm_className, "findInParameter", ret);
            return ret;
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "findInParameter", "Cannot find input parameter by name.", ex);
            throw new DataException("odaconsumer.CannotFindInParameter", (Throwable)ex, new Object[]{paramName});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.INFO, sm_className, "findInParameter", "Cannot find input parameter by name.", ex);
            throw new DataException("odaconsumer.CannotFindInParameter", (Throwable)ex, new Object[]{paramName});
        }
    }

    public void setParameterValue(int paramIndex, Object paramValue) throws DataException {
        this.setParameterValue(null, paramIndex, paramValue);
    }

    public void setParameterValue(String paramName, Object paramValue) throws DataException {
        this.setParameterValue(paramName, 0, paramValue);
    }

    private void setParameterValue(String paramName, int paramIndex, Object paramValue) throws DataException {
        try {
            if (paramValue == null) {
                this.setNull(paramName, paramIndex);
                return;
            }
            if (paramValue instanceof Integer) {
                int i = (Integer)paramValue;
                this.setInt(paramName, paramIndex, i);
                return;
            }
            if (paramValue instanceof Double) {
                double d = (Double)paramValue;
                this.setDouble(paramName, paramIndex, d);
                return;
            }
            if (paramValue instanceof String) {
                String string = (String)paramValue;
                this.setString(paramName, paramIndex, string);
                return;
            }
            if (paramValue instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)paramValue;
                this.setBigDecimal(paramName, paramIndex, decimal);
                return;
            }
            if (paramValue instanceof Time) {
                Time time = (Time)paramValue;
                this.setTime(paramName, paramIndex, time);
                return;
            }
            if (paramValue instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)paramValue;
                this.setTimestamp(paramName, paramIndex, timestamp);
                return;
            }
            if (paramValue instanceof Date) {
                Date sqlDate = (Date)paramValue;
                this.setDate(paramName, paramIndex, sqlDate);
                return;
            }
            if (paramValue instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)paramValue;
                Timestamp sqlDateTime = new Timestamp(date.getTime());
                this.setTimestamp(paramName, paramIndex, sqlDateTime);
                return;
            }
            if (paramValue instanceof Boolean) {
                boolean val = (Boolean)paramValue;
                this.setBoolean(paramName, paramIndex, val);
                return;
            }
        }
        catch (RuntimeException ex) {
            this.retrySetParameterValue(paramName, paramIndex, paramValue, ex);
            return;
        }
        catch (DataException ex) {
            this.retrySetParameterValue(paramName, paramIndex, paramValue, (Exception)((Object)ex));
            return;
        }
        sm_logger.logp(Level.SEVERE, sm_className, "setParameterValue", "Unsupported parameter value type.");
        throw new DataException("odaconsumer.UnsupportedParameterValueType", new Object[]{paramValue.getClass()});
    }

    private void retrySetParameterValue(String paramName, int paramIndex, Object paramValue, Exception lastException) throws DataException {
        int parameterType = 0;
        try {
            parameterType = paramName == null ? this.getParameterType(paramIndex) : this.getParameterType(paramName);
        }
        catch (Exception exception) {}
        if (parameterType == 0) {
            parameterType = this.getOdaTypeFromParamHints(paramName, paramIndex);
        }
        if (parameterType == 4 && paramValue instanceof Integer || parameterType == 8 && paramValue instanceof Double || parameterType == 1 && paramValue instanceof String || parameterType == 3 && paramValue instanceof BigDecimal || parameterType == 92 && paramValue instanceof Time || parameterType == 93 && paramValue instanceof Timestamp || parameterType == 91 && paramValue instanceof java.util.Date || parameterType == 16 && paramValue instanceof Boolean) {
            this.throwSetParamValueLastException(lastException, "retrySetParameterValue");
        }
        if (paramValue == null) {
            this.retrySetNullParamValue(paramName, paramIndex, parameterType, lastException);
            return;
        }
        if (paramValue instanceof Integer) {
            this.retrySetIntegerParamValue(paramName, paramIndex, (Integer)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof Double) {
            this.retrySetDoubleParamValue(paramName, paramIndex, (Double)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof String) {
            this.retrySetStringParamValue(paramName, paramIndex, (String)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof BigDecimal) {
            this.retryBigDecimalParamValue(paramName, paramIndex, (BigDecimal)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof Time) {
            this.retrySetTimeParamValue(paramName, paramIndex, (Time)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof Timestamp) {
            this.retrySetTimestampParamValue(paramName, paramIndex, (Timestamp)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof java.util.Date) {
            this.retrySetDateParamValue(paramName, paramIndex, (java.util.Date)paramValue, parameterType);
            return;
        }
        if (paramValue instanceof Boolean) {
            this.retrySetBooleanParamValue(paramName, paramIndex, (Boolean)paramValue, parameterType);
            return;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private void retrySetIntegerParamValue(String paramName, int paramIndex, Integer paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 8: {
                double d = paramValue.doubleValue();
                this.setDouble(paramName, paramIndex, d);
                return;
            }
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 3: {
                int i = paramValue;
                BigDecimal bd = new BigDecimal((double)i);
                this.setBigDecimal(paramName, paramIndex, bd);
                return;
            }
            case 16: {
                boolean val = paramValue != 0;
                this.setBoolean(paramName, paramIndex, val);
                return;
            }
        }
        this.conversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetDoubleParamValue(String paramName, int paramIndex, Double paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 4: {
                int i = paramValue.intValue();
                Double intValue = new Double(i);
                if (!paramValue.equals(intValue)) {
                    this.conversionError(paramName, paramIndex, paramValue, parameterType, null);
                }
                this.setInt(paramName, paramIndex, i);
                return;
            }
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 3: {
                double d = paramValue;
                BigDecimal bd = new BigDecimal(d);
                this.setBigDecimal(paramName, paramIndex, bd);
                return;
            }
            case 16: {
                boolean val = paramValue != 0.0;
                this.setBoolean(paramName, paramIndex, val);
                return;
            }
        }
        this.conversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetStringParamValue(String paramName, int paramIndex, String paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 4: {
                try {
                    int i = Integer.parseInt(paramValue);
                    this.setInt(paramName, paramIndex, i);
                    return;
                }
                catch (NumberFormatException ex) {
                    this.conversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 8: {
                try {
                    double d = Double.parseDouble(paramValue);
                    this.setDouble(paramName, paramIndex, d);
                    return;
                }
                catch (NumberFormatException ex) {
                    this.conversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 3: {
                try {
                    BigDecimal bd = new BigDecimal(paramValue);
                    this.setBigDecimal(paramName, paramIndex, bd);
                    return;
                }
                catch (NumberFormatException ex) {
                    this.conversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 91: {
                try {
                    Date d = Date.valueOf(paramValue);
                    this.setDate(paramName, paramIndex, d);
                    return;
                }
                catch (IllegalArgumentException ex) {
                    this.conversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 92: {
                try {
                    Time t = Time.valueOf(paramValue);
                    this.setTime(paramName, paramIndex, t);
                    return;
                }
                catch (IllegalArgumentException ex) {
                    this.conversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 93: {
                try {
                    Timestamp ts = Timestamp.valueOf(paramValue);
                    this.setTimestamp(paramName, paramIndex, ts);
                    return;
                }
                catch (IllegalArgumentException ex) {
                    this.conversionError(paramName, paramIndex, paramValue, parameterType, ex);
                    return;
                }
            }
            case 16: {
                boolean val = Boolean.valueOf(paramValue);
                this.setBoolean(paramName, paramIndex, val);
                return;
            }
        }
        this.conversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retryBigDecimalParamValue(String paramName, int paramIndex, BigDecimal paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 4: {
                int i = paramValue.intValue();
                BigDecimal intValue = new BigDecimal((double)i);
                if (!paramValue.equals(intValue)) {
                    this.conversionError(paramName, paramIndex, paramValue, parameterType, null);
                }
                this.setInt(paramName, paramIndex, i);
                return;
            }
            case 8: {
                double d = paramValue.doubleValue();
                BigDecimal doubleValue = new BigDecimal(d);
                if (!paramValue.equals(doubleValue)) {
                    this.conversionError(paramName, paramIndex, paramValue, parameterType, null);
                }
                this.setDouble(paramName, paramIndex, d);
                return;
            }
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 16: {
                boolean val = paramValue.compareTo(BigDecimal.valueOf(0L)) != 0;
                this.setBoolean(paramName, paramIndex, val);
                return;
            }
        }
        this.conversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetDateParamValue(String paramName, int paramIndex, java.util.Date paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 1: {
                Date sqlDate = new Date(paramValue.getTime());
                String s = sqlDate.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 92: {
                Time timeValue = new Time(paramValue.getTime());
                this.setTime(paramName, paramIndex, timeValue);
                return;
            }
            case 93: {
                Timestamp ts = new Timestamp(paramValue.getTime());
                this.setTimestamp(paramName, paramIndex, ts);
                return;
            }
        }
        this.conversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetTimeParamValue(String paramName, int paramIndex, Time paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 91: {
                Date d = new Date(paramValue.getTime());
                this.setDate(paramName, paramIndex, d);
                return;
            }
            case 93: {
                Timestamp ts = new Timestamp(paramValue.getTime());
                this.setTimestamp(paramName, paramIndex, ts);
                return;
            }
        }
        this.conversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetTimestampParamValue(String paramName, int paramIndex, Timestamp paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 91: {
                long time = paramValue.getTime();
                Date d = new Date(time);
                this.setDate(paramName, paramIndex, d);
                return;
            }
            case 92: {
                Time timeValue = new Time(paramValue.getTime());
                this.setTime(paramName, paramIndex, timeValue);
                return;
            }
        }
        this.conversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetBooleanParamValue(String paramName, int paramIndex, Boolean paramValue, int parameterType) throws DataException {
        switch (parameterType) {
            case 4: {
                int i = paramValue != false ? 1 : 0;
                this.setInt(paramName, paramIndex, i);
                return;
            }
            case 8: {
                double d = paramValue != false ? 1 : 0;
                this.setDouble(paramName, paramIndex, d);
                return;
            }
            case 1: {
                String s = paramValue.toString();
                this.setString(paramName, paramIndex, s);
                return;
            }
            case 3: {
                boolean i = paramValue != false;
                BigDecimal bd = new BigDecimal((double)i);
                this.setBigDecimal(paramName, paramIndex, bd);
                return;
            }
        }
        this.conversionError(paramName, paramIndex, paramValue, parameterType, null);
    }

    private void retrySetNullParamValue(String paramName, int paramIndex, int parameterType, Exception lastException) throws DataException {
        switch (parameterType) {
            case 1: {
                this.setString(paramName, paramIndex, null);
                return;
            }
            case 3: {
                this.setBigDecimal(paramName, paramIndex, null);
                return;
            }
            case 91: {
                this.setDate(paramName, paramIndex, null);
                return;
            }
            case 92: {
                this.setTime(paramName, paramIndex, null);
                return;
            }
            case 93: {
                this.setTimestamp(paramName, paramIndex, null);
                return;
            }
        }
        sm_logger.logp(Level.SEVERE, sm_className, "retrySetNullParamValue", "Input parameter value is null; not able to retry, throws exception from underlying ODA driver.");
        this.throwSetParamValueLastException(lastException, "retrySetNullParamValue");
    }

    private void conversionError(String paramName, int paramIndex, Object paramValue, int odaType, Exception cause) throws DataException {
        Object paramValueArg = paramValue == null ? "" : paramValue;
        Object paramClassArg = paramValue == null ? "null" : paramValue.getClass();
        DataException exception = null;
        exception = paramName == null ? new DataException("odaconsumer.CannotConvertIndexedParameterValue", new Object[]{paramValueArg, new Integer(paramIndex), paramClassArg, new Integer(odaType)}) : new DataException("odaconsumer.CannotConvertIndexedParameterValue", new Object[]{paramValueArg, paramName, paramClassArg, new Integer(odaType)});
        if (cause != null) {
            exception.initCause(cause);
        }
        sm_logger.logp(Level.SEVERE, sm_className, "conversionError", "Data type conversion error.", (Throwable)((Object)exception));
        throw exception;
    }

    private void throwSetParamValueLastException(Exception lastException, String methodName) throws RuntimeException, DataException, IllegalStateException {
        if (!$assertionsDisabled && lastException == null) {
            throw new AssertionError();
        }
        String logContextMsg = "Cannot set input parameter.";
        if (lastException instanceof RuntimeException) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, logContextMsg, lastException);
            throw (RuntimeException)lastException;
        }
        if (lastException instanceof DataException) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, logContextMsg, lastException);
            throw (DataException)((Object)lastException);
        }
        String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.UnknownExceptionThrown");
        IllegalStateException ex = new IllegalStateException(localizedMessage);
        ex.initCause(lastException);
        sm_logger.logp(Level.SEVERE, sm_className, methodName, logContextMsg, lastException);
        throw ex;
    }

    private void setInt(String paramName, int paramIndex, int i) throws DataException {
        if (paramName == null) {
            this.doSetInt(paramIndex, i);
        } else {
            this.setInt(paramName, i);
        }
    }

    private void setInt(String paramName, int i) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetInt(paramName, i);
            return;
        }
        if (!this.setIntUsingHints(paramName, i)) {
            Object[] msgArgs = new Object[]{new Integer(i), paramName};
            this.handleError("odaconsumer.CannotSetIntParameter", msgArgs, "setInt( String, int )");
        }
    }

    private boolean setIntUsingHints(String paramName, int i) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName);
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetInt(paramIndex, i);
        return true;
    }

    private void setDouble(String paramName, int paramIndex, double d) throws DataException {
        if (paramName == null) {
            this.doSetDouble(paramIndex, d);
        } else {
            this.setDouble(paramName, d);
        }
    }

    private void setDouble(String paramName, double d) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetDouble(paramName, d);
            return;
        }
        if (!this.setDoubleUsingHints(paramName, d)) {
            Object[] msgArgs = new Object[]{new Double(d), paramName};
            this.handleError("odaconsumer.CannotSetDoubleParameter", msgArgs, "setDouble( String, double )");
        }
    }

    private boolean setDoubleUsingHints(String paramName, double d) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName);
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetDouble(paramIndex, d);
        return true;
    }

    private void setString(String paramName, int paramIndex, String stringValue) throws DataException {
        if (paramName == null) {
            this.doSetString(paramIndex, stringValue);
        } else {
            this.setString(paramName, stringValue);
        }
    }

    private void setString(String paramName, String stringValue) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetString(paramName, stringValue);
            return;
        }
        if (!this.setStringUsingHints(paramName, stringValue)) {
            Object[] msgArgs = new Object[]{stringValue, paramName};
            this.handleError("odaconsumer.CannotSetStringParameter", msgArgs, "setString( String, String )");
        }
    }

    private boolean setStringUsingHints(String paramName, String stringValue) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName);
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetString(paramIndex, stringValue);
        return true;
    }

    private void setBigDecimal(String paramName, int paramIndex, BigDecimal decimal) throws DataException {
        if (paramName == null) {
            this.doSetBigDecimal(paramIndex, decimal);
        } else {
            this.setBigDecimal(paramName, decimal);
        }
    }

    private void setBigDecimal(String paramName, BigDecimal decimal) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetBigDecimal(paramName, decimal);
            return;
        }
        if (!this.setBigDecimalUsingHints(paramName, decimal)) {
            Object[] msgArgs = new Object[]{decimal, paramName};
            this.handleError("odaconsumer.CannotSetBigDecimalParameter", msgArgs, "setBigDecimal( String, BigDecimal )");
        }
    }

    private boolean setBigDecimalUsingHints(String paramName, BigDecimal decimal) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName);
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetBigDecimal(paramIndex, decimal);
        return true;
    }

    private void setDate(String paramName, int paramIndex, Date date) throws DataException {
        if (paramName == null) {
            this.doSetDate(paramIndex, date);
        } else {
            this.setDate(paramName, date);
        }
    }

    private void setDate(String paramName, Date date) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetDate(paramName, date);
            return;
        }
        if (!this.setDateUsingHints(paramName, date)) {
            Object[] msgArgs = new Object[]{date, paramName};
            this.handleError("odaconsumer.CannotSetDateParameter", msgArgs, "setDate( String, Date )");
        }
    }

    private boolean setDateUsingHints(String paramName, Date date) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName);
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetDate(paramIndex, date);
        return true;
    }

    private void setTime(String paramName, int paramIndex, Time time) throws DataException {
        if (paramName == null) {
            this.doSetTime(paramIndex, time);
        } else {
            this.setTime(paramName, time);
        }
    }

    private void setTime(String paramName, Time time) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetTime(paramName, time);
            return;
        }
        if (!this.setTimeUsingHints(paramName, time)) {
            Object[] msgArgs = new Object[]{time, paramName};
            this.handleError("odaconsumer.CannotSetTimeParameter", msgArgs, "setTime( String, Time )");
        }
    }

    private boolean setTimeUsingHints(String paramName, Time time) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName);
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetTime(paramIndex, time);
        return true;
    }

    private void setTimestamp(String paramName, int paramIndex, Timestamp timestamp) throws DataException {
        if (paramName == null) {
            this.doSetTimestamp(paramIndex, timestamp);
        } else {
            this.setTimestamp(paramName, timestamp);
        }
    }

    private void setTimestamp(String paramName, Timestamp timestamp) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetTimestamp(paramName, timestamp);
            return;
        }
        if (!this.setTimestampUsingHints(paramName, timestamp)) {
            Object[] msgArgs = new Object[]{timestamp, paramName};
            this.handleError("odaconsumer.CannotSetTimestampParameter", msgArgs, "setTimestamp( String, Timestamp )");
        }
    }

    private boolean setTimestampUsingHints(String paramName, Timestamp timestamp) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName);
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetTimestamp(paramIndex, timestamp);
        return true;
    }

    private void setBoolean(String paramName, int paramIndex, boolean val) throws DataException {
        if (paramName == null) {
            this.doSetBoolean(paramIndex, val);
        } else {
            this.setBoolean(paramName, val);
        }
    }

    private void setBoolean(String paramName, boolean val) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetBoolean(paramName, val);
            return;
        }
        if (!this.setBooleanUsingHints(paramName, val)) {
            Object[] msgArgs = new Object[]{new Boolean(val), paramName};
            this.handleError("odaconsumer.CannotSetBooleanParameter", msgArgs, "setBoolean( String, boolean )");
        }
    }

    private boolean setBooleanUsingHints(String paramName, boolean val) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName);
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetBoolean(paramIndex, val);
        return true;
    }

    private void setNull(String paramName, int paramIndex) throws DataException {
        if (paramName == null) {
            this.doSetNull(paramIndex);
        } else {
            this.setNull(paramName);
        }
    }

    private void setNull(String paramName) throws DataException {
        if (this.supportsNamedParameter()) {
            this.doSetNull(paramName);
            return;
        }
        if (!this.setNullUsingHints(paramName)) {
            Object[] msgArgs = new Object[]{paramName};
            this.handleError("odaconsumer.CannotSetNullParameter", msgArgs, "setNull( String )");
        }
    }

    private boolean setNullUsingHints(String paramName) throws DataException {
        int paramIndex = this.getIndexFromParamHints(paramName);
        if (paramIndex <= 0) {
            return false;
        }
        this.doSetNull(paramIndex);
        return true;
    }

    private void doSetInt(int paramIndex, int i) throws DataException {
        try {
            this.getStatement().setInt(paramIndex, i);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{new Integer(i), new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetIntParameter", msgArgs, "doSetInt( int, int )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{new Integer(i), new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetIntParameter", msgArgs, "doSetInt( int, int )");
        }
    }

    private void doSetInt(String paramName, int i) throws DataException {
        block3: {
            try {
                this.getStatement().setInt(paramName, i);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{new Integer(i), paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetIntParameter", msgArgs, "doSetInt( String, int )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setIntUsingHints(paramName, i)) break block3;
                Object[] msgArgs = new Object[]{new Integer(i), paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetIntParameter", msgArgs, "doSetInt( String, int )");
            }
        }
    }

    private void doSetDouble(int paramIndex, double d) throws DataException {
        try {
            this.getStatement().setDouble(paramIndex, d);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{new Double(d), new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetDoubleParameter", msgArgs, "doSetDouble( int, double )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{new Double(d), new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetDoubleParameter", msgArgs, "doSetDouble( int, double )");
        }
    }

    private void doSetDouble(String paramName, double d) throws DataException {
        block3: {
            try {
                this.getStatement().setDouble(paramName, d);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{new Double(d), paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetDoubleParameter", msgArgs, "doSetDouble( String, double )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setDoubleUsingHints(paramName, d)) break block3;
                Object[] msgArgs = new Object[]{new Double(d), paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetDoubleParameter", msgArgs, "doSetDouble( String, double )");
            }
        }
    }

    private void doSetString(int paramIndex, String stringValue) throws DataException {
        try {
            this.getStatement().setString(paramIndex, stringValue);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{stringValue, new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetStringParameter", msgArgs, "doSetString( int, String )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{stringValue, new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetStringParameter", msgArgs, "doSetString( int, String )");
        }
    }

    private void doSetString(String paramName, String stringValue) throws DataException {
        block3: {
            try {
                this.getStatement().setString(paramName, stringValue);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{stringValue, paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetStringParameter", msgArgs, "doSetString( String, String )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setStringUsingHints(paramName, stringValue)) break block3;
                Object[] msgArgs = new Object[]{stringValue, paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetStringParameter", msgArgs, "doSetString( String, String )");
            }
        }
    }

    private void doSetBigDecimal(int paramIndex, BigDecimal decimal) throws DataException {
        try {
            this.getStatement().setBigDecimal(paramIndex, decimal);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{decimal, new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetBigDecimalParameter", msgArgs, "doSetBigDecimal( int, BigDecimal )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{decimal, new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetBigDecimalParameter", msgArgs, "doSetBigDecimal( int, BigDecimal )");
        }
    }

    private void doSetBigDecimal(String paramName, BigDecimal decimal) throws DataException {
        block3: {
            try {
                this.getStatement().setBigDecimal(paramName, decimal);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{decimal, paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetBigDecimalParameter", msgArgs, "doSetBigDecimal( String, BigDecimal )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setBigDecimalUsingHints(paramName, decimal)) break block3;
                Object[] msgArgs = new Object[]{decimal, paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetBigDecimalParameter", msgArgs, "doSetBigDecimal( String, BigDecimal )");
            }
        }
    }

    private void doSetDate(int paramIndex, Date date) throws DataException {
        try {
            this.getStatement().setDate(paramIndex, date);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{date, new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetDateParameter", msgArgs, "doSetDate( int, Date )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{date, new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetDateParameter", msgArgs, "doSetDate( int, Date )");
        }
    }

    private void doSetDate(String paramName, Date date) throws DataException {
        block3: {
            try {
                this.getStatement().setDate(paramName, date);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{date, paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetDateParameter", msgArgs, "doSetDate( String, Date )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setDateUsingHints(paramName, date)) break block3;
                Object[] msgArgs = new Object[]{date, paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetDateParameter", msgArgs, "doSetDate( String, Date )");
            }
        }
    }

    private void doSetTime(int paramIndex, Time time) throws DataException {
        try {
            this.getStatement().setTime(paramIndex, time);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{time, new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetTimeParameter", msgArgs, "doSetTime( int, Time )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{time, new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetTimeParameter", msgArgs, "doSetTime( int, Time )");
        }
    }

    private void doSetTime(String paramName, Time time) throws DataException {
        block3: {
            try {
                this.getStatement().setTime(paramName, time);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{time, paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetTimeParameter", msgArgs, "doSetTime( String, Time )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setTimeUsingHints(paramName, time)) break block3;
                Object[] msgArgs = new Object[]{time, paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetTimeParameter", msgArgs, "doSetTime( String, Time )");
            }
        }
    }

    private void doSetTimestamp(int paramIndex, Timestamp timestamp) throws DataException {
        try {
            this.getStatement().setTimestamp(paramIndex, timestamp);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{timestamp, new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetTimestampParameter", msgArgs, "doSetTimestamp( int, Timestamp )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{timestamp, new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetTimestampParameter", msgArgs, "doSetTimestamp( int, Timestamp )");
        }
    }

    private void doSetTimestamp(String paramName, Timestamp timestamp) throws DataException {
        block3: {
            try {
                this.getStatement().setTimestamp(paramName, timestamp);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{timestamp, paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetTimestampParameter", msgArgs, "doSetTimestamp( String, Timestamp )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setTimestampUsingHints(paramName, timestamp)) break block3;
                Object[] msgArgs = new Object[]{timestamp, paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetTimestampParameter", msgArgs, "doSetTimestamp( String, Timestamp )");
            }
        }
    }

    private void doSetBoolean(int paramIndex, boolean val) throws DataException {
        try {
            this.getStatement().setBoolean(paramIndex, val);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{new Boolean(val), new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetBooleanParameter", msgArgs, "doSetBoolean( int, boolean )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{new Boolean(val), new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetBooleanParameter", msgArgs, "doSetBoolean( int, boolean )");
        }
    }

    private void doSetBoolean(String paramName, boolean val) throws DataException {
        block3: {
            try {
                this.getStatement().setBoolean(paramName, val);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{new Boolean(val), paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetBooleanParameter", msgArgs, "doSetBoolean( String, boolean )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setBooleanUsingHints(paramName, val)) break block3;
                Object[] msgArgs = new Object[]{new Boolean(val), paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetBooleanParameter", msgArgs, "doSetBoolean( String, boolean )");
            }
        }
    }

    private void doSetNull(int paramIndex) throws DataException {
        try {
            this.getStatement().setNull(paramIndex);
        }
        catch (OdaException ex) {
            Object[] msgArgs = new Object[]{new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetNullParameter", msgArgs, "doSetNull( int )");
        }
        catch (UnsupportedOperationException ex) {
            Object[] msgArgs = new Object[]{new Integer(paramIndex)};
            this.handleException((Throwable)ex, "odaconsumer.CannotSetNullParameter", msgArgs, "doSetNull( int )");
        }
    }

    private void doSetNull(String paramName) throws DataException {
        block3: {
            try {
                this.getStatement().setNull(paramName);
            }
            catch (OdaException ex) {
                Object[] msgArgs = new Object[]{paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetNullParameter", msgArgs, "doSetNull( String )");
            }
            catch (UnsupportedOperationException ex) {
                if (this.setNullUsingHints(paramName)) break block3;
                Object[] msgArgs = new Object[]{paramName};
                this.handleException((Throwable)ex, "odaconsumer.CannotSetNullParameter", msgArgs, "doSetNull( String )");
            }
        }
    }

    private void handleError(String errorCode, Object[] msgArgs, String methodName) throws DataException {
        DataException dataEx = new DataException(errorCode, msgArgs);
        sm_logger.logp(Level.SEVERE, sm_className, methodName, dataEx.getLocalizedMessage(), msgArgs);
        throw dataEx;
    }

    private void handleException(Throwable ex, String errorCode, String methodName, int paramIndex) throws DataException {
        Integer methodArg = paramIndex > 0 ? new Integer(paramIndex) : null;
        this.handleException(ex, errorCode, methodName, methodArg);
    }

    private void handleException(Throwable ex, String errorCode, String methodName, Object methodArg) throws DataException {
        DataException dataEx = methodArg != null ? new DataException(errorCode, ex, methodArg) : new DataException(errorCode, ex);
        sm_logger.logp(Level.SEVERE, sm_className, methodName, dataEx.getLocalizedMessage(), ex);
        throw dataEx;
    }

    private void handleException(Throwable ex, String errorCode, Object[] msgArgs, String methodName) throws DataException {
        DataException dataEx = new DataException(errorCode, ex, msgArgs);
        sm_logger.logp(Level.SEVERE, sm_className, methodName, dataEx.getLocalizedMessage(), ex);
        throw dataEx;
    }

    static final class CustomColumn {
        private String m_name;
        private Class m_type;

        CustomColumn(String name, Class type) {
            this.m_name = name;
            this.m_type = type;
        }

        private String getName() {
            return this.m_name;
        }

        private Class getType() {
            return this.m_type;
        }
    }

    private static final class Property {
        private String m_name;
        private String m_value;

        private Property(String name, String value) {
            this.m_name = name;
            this.m_value = value;
        }

        private String getName() {
            return this.m_name;
        }

        private String getValue() {
            return this.m_value;
        }
    }
}

