/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.application.impl;

import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.application.ISMLResourceFacet;
import org.eclipse.cosmos.rm.repository.internal.application.ISMLResourceInstance;
import org.eclipse.cosmos.rm.repository.internal.reference.SMLQualifiedReference;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileDocument;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileInstanceDocument;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SMLFileResourceInstance
extends SMLFileInstanceDocument
implements ISMLResourceInstance {
    private static final long serialVersionUID = 4657641861840507364L;
    private String reference;
    private ISMLDocument delegate;
    private Node root;
    private ISMLDocument parentDocument;

    public static SMLFileResourceInstance load(ISMLRepository repository, Node root) {
        if (root == null || root.getNodeType() != 1) {
            return null;
        }
        String reference = null;
        if ("http://www.cosmos.rm/dataCenter/core".equals(root.getNamespaceURI()) && "itemRef".equals(root.getLocalName())) {
            reference = SMLRepositoryUtil.extractReference(root);
        }
        SMLFileResourceInstance instance = new SMLFileResourceInstance(repository, reference);
        if (reference == null) {
            instance.root = root;
        }
        return instance;
    }

    public SMLFileResourceInstance(ISMLRepository repository, String reference) {
        super(repository);
        this.reference = reference;
    }

    public SMLFileResourceInstance(ISMLRepository repository, ISMLDocument delegate) {
        super(repository);
        this.delegate = delegate;
    }

    public ISMLResourceInstance resolveReference() {
        if (this.reference == null) {
            return this;
        }
        try {
            SMLQualifiedReference qualifiedReference = new SMLQualifiedReference(this.getRepository(), this.reference);
            ISMLDocument[] document = this.getRepository().fetchDocuments(new SMLFileMetadata(null, -1, null, new String[]{qualifiedReference.getDocumentReference()}, null));
            if (document == null || document.length <= 0) {
                document = this.getRepository().fetchDocuments(new SMLFileMetadata(qualifiedReference.getDocumentReference(), -1, null, null, null));
            }
            return document != null && document.length > 0 ? new SMLFileResourceInstance(this.getRepository(), document[0]) : null;
        }
        catch (RepositoryOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ISMLResourceFacet[] retrieveFacets() throws RepositoryOperationException {
        return SMLRepositoryUtil.retrieveFacets(this.parentDocument == null ? this : (ISMLResourceInstance)this.parentDocument, (Node)(this.root == null ? (this.getDOMDocument() == null ? null : this.getDOMDocument().getFirstChild()) : this.root), this.getRepository());
    }

    public boolean isReference() {
        return this.reference != null;
    }

    public String retrieveName() {
        try {
            return this.retrieveRootAttribute(null, "name");
        }
        catch (RepositoryOperationException repositoryOperationException) {
            return null;
        }
    }

    public String retrieveDisplayName() {
        try {
            return this.retrieveRootAttribute(null, "displayName");
        }
        catch (RepositoryOperationException repositoryOperationException) {
            return null;
        }
    }

    public String retrieveDescription() {
        try {
            return this.retrieveRootAttribute(null, "description");
        }
        catch (RepositoryOperationException repositoryOperationException) {
            return null;
        }
    }

    public Document getDOMDocument() throws RepositoryOperationException {
        return this.delegate instanceof SMLFileDocument ? ((SMLFileDocument)this.delegate).getDOMDocument() : super.getDOMDocument();
    }

    public ISMLRepository getRepository() {
        return this.delegate instanceof SMLFileDocument ? ((SMLFileDocument)this.delegate).getRepository() : super.getRepository();
    }

    public String retrieveRootAttribute(String uri, String localName) throws RepositoryOperationException {
        return this.delegate instanceof SMLFileDocument ? ((SMLFileDocument)this.delegate).retrieveRootAttribute(uri, localName) : super.retrieveRootAttribute(uri, localName);
    }

    public ISMLMetadata getMetadata() {
        return this.delegate == null ? super.getMetadata() : this.delegate.getMetadata();
    }

    public void setParentDocument(ISMLDocument parentDocument) {
        this.parentDocument = parentDocument;
    }

    public ISMLDocument getParentDocument() {
        return this.parentDocument;
    }
}

