/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.exceptions.SelectorHandleException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IRecordTypeSelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.ISelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.AbstractSMLSelectorHandler;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.CMDBfUtil;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileInstanceDocument;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.w3c.dom.Node;

public class ItemRecordHandler
extends AbstractSMLSelectorHandler {
    protected INodes handle(INodes context, ISelector selector) throws SelectorHandleException {
        try {
            INodes results = this.retrieveContext(context);
            IGraphElement[] elements = results.getElements();
            ISMLRepository repository = this.getRepository();
            IRecordTypeSelector recordTypeSelector = (IRecordTypeSelector)selector;
            String namespace = CMDBfServicesUtil.toString((URI)recordTypeSelector.getNamespace());
            String localName = recordTypeSelector.getLocalName();
            ArrayList<IGraphElement> revisedList = new ArrayList<IGraphElement>();
            int i = 0;
            while (i < elements.length) {
                Node rootNode;
                SMLFileInstanceDocument document = CMDBfUtil.retrieveDocument(repository, (IItem)elements[i]);
                Node node = rootNode = document == null ? null : document.getDOMDocument().getFirstChild();
                if (rootNode != null) {
                    if (namespace.equals(rootNode.getNamespaceURI()) && localName.equals(rootNode.getLocalName())) {
                        revisedList.add(elements[i]);
                    } else {
                        String typeLocalName;
                        String typeNamespace;
                        int colonInx;
                        SMLRepositoryUtil.parseDocument(document, repository);
                        Map typeInfo = (Map)repository.getProperty("org.eclipse.cosmos.rm.repository.TYPE_INFORMATION", (Object)null);
                        String type = SMLRepositoryUtil.retrieveType(typeInfo, namespace, localName);
                        if (type != null && (colonInx = type.lastIndexOf(58)) >= 0 && SMLRepositoryUtil.isDerivedType(repository, rootNode, typeNamespace = type.substring(0, colonInx), typeLocalName = type.substring(colonInx + 1))) {
                            revisedList.add(elements[i]);
                        }
                    }
                }
                ++i;
            }
            results.setElements(revisedList.toArray(new IGraphElement[revisedList.size()]));
            return results;
        }
        catch (RepositoryOperationException e) {
            throw new SelectorHandleException((Throwable)e);
        }
    }
}

