/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.operations.cmdbf;

import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.exceptions.InitializationException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.exceptions.SelectorHandleException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.impl.AbstractRelationshipSelectorHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IRecordTypeSelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.ISelector;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IRelationship;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.IRelationshipConvertible;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.response.artifacts.ResponseArtifactFactory;
import org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.CMDBfUtil;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileInstanceDocument;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipRecordHandler
extends AbstractRelationshipSelectorHandler {
    public void initialize(Map<?, ?> init) throws InitializationException {
        if (!(init.get("org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.DATA_PROVIDER") instanceof ISMLRepository)) {
            throw new InitializationException("The data provider is not set as part of the initialization data");
        }
        super.initialize(init);
    }

    protected IEdges handle(IEdges context, IItem source, IItem target, ISelector selector) throws SelectorHandleException {
        IRecordTypeSelector recordTypeSelector = (IRecordTypeSelector)selector;
        IEdges edges = ResponseArtifactFactory.createEdges((IRelationshipTemplate)context.getRelationshipTemplate());
        if (!"http://cosmos.org".equals(recordTypeSelector.getNamespace().toString()) || !"references".equals(recordTypeSelector.getLocalName())) {
            return edges;
        }
        try {
            ISMLDocument[] references;
            ISMLRepository repository = (ISMLRepository)this.getValue("org.eclipse.cosmos.rm.repository.internal.operations.cmdbf.DATA_PROVIDER");
            SMLFileInstanceDocument sourceDocument = CMDBfUtil.retrieveDocument(repository, source);
            SMLFileInstanceDocument targetDocument = CMDBfUtil.retrieveDocument(repository, target);
            if (sourceDocument != null && targetDocument != null && (references = sourceDocument.retrieveReferences(targetDocument.getMetadata())) != null && references.length > 0) {
                IRelationship relationship = ResponseArtifactFactory.createRelationship();
                relationship.setSourceId(ResponseArtifactFactory.createInstanceId((String)"http://cosmos.org/rm/sml/repository", (String)sourceDocument.getMetadata().getId()));
                relationship.setTargetId(ResponseArtifactFactory.createInstanceId((String)"http://cosmos.org/rm/sml/repository", (String)targetDocument.getMetadata().getId()));
                edges.addRelationship((IRelationshipConvertible)relationship);
            }
        }
        catch (RepositoryOperationException e) {
            throw new SelectorHandleException((Throwable)e);
        }
        return edges;
    }
}

