/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts;

import java.io.StringWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IRecordSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Record
implements IRecord,
IXMLWritable {
    private URI recordId;
    private IXMLWritable value;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private IGraphElement parent;

    public Record(IGraphElement parent) {
        this.parent = parent;
    }

    @Override
    public URI getRecordId() {
        return this.recordId;
    }

    public void setRecordId(URI recordId) {
        this.recordId = recordId;
    }

    @Override
    public void setRecordId(String recordId) {
        String uriId = recordId.replaceAll(" ", "%20");
        this.setRecordId(CMDBfServicesUtil.createURI(uriId));
    }

    @Override
    public IXMLWritable getValue() {
        return this.value;
    }

    @Override
    public void setValue(IXMLWritable value) {
        this.value = value;
    }

    @Override
    public void addNamespace(String key, String value) {
        this.getNamespaces().put(key, value);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void toXML(StringWriter writer, int indent) {
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write("<record");
        int count = 0;
        for (String key : this.getNamespaces().keySet()) {
            if (count == 0) {
                writer.write(" ");
            } else {
                CMDBfServicesUtil.addIndent(writer, indent + 1);
            }
            ++count;
            CMDBfServicesUtil.writeAttribute(writer, "xmlns:" + key, this.getNamespaces().get(key));
            writer.write(ICMDBfServicesConstants.nl);
        }
        CMDBfServicesUtil.addIndent(writer, indent - 2);
        CMDBfServicesUtil.writeAttribute(writer, "recordId", this.getRecordId().toString());
        writer.write(">" + ICMDBfServicesConstants.nl);
        this.getValue().toXML(writer, indent + 1);
        CMDBfServicesUtil.addIndent(writer, indent);
        writer.write(String.valueOf(CMDBfServicesUtil.endTagFor("record")) + ICMDBfServicesConstants.nl);
    }

    public IGraphElement getParent() {
        return this.parent;
    }

    public void setParent(IGraphElement parent) {
        this.parent = parent;
    }

    @Override
    public void setValueFromString(String stringRepresentationOfValue) {
        IRecordSerializer serializer = CMDBfServicesUtil.getRecordSerializer();
        IXMLWritable writable = null;
        writable = serializer != null ? serializer.deserialize(stringRepresentationOfValue) : new XMLWritableString(stringRepresentationOfValue);
        this.setValue(writable);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.namespaces == null ? 0 : this.namespaces.hashCode());
        result = 31 * result + (this.recordId == null ? 0 : this.recordId.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Record other = (Record)obj;
        if (this.namespaces == null ? other.namespaces != null : !this.namespaces.equals(other.namespaces)) {
            return false;
        }
        if (this.recordId == null ? other.recordId != null : !this.recordId.equals(other.recordId)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    private class XMLWritableString
    implements IXMLWritable {
        private String value;

        public XMLWritableString(String value) {
            this.value = value;
        }

        public void toXML(StringWriter writer, int indentLevel) {
            CMDBfServicesUtil.addIndent(writer, indentLevel);
            writer.write(String.valueOf(this.valueWithIndent(indentLevel + 1)) + ICMDBfServicesConstants.nl);
        }

        private String valueWithIndent(int i) {
            String tempValue = this.value;
            StringWriter tabsWriter = new StringWriter();
            tabsWriter.append('\n');
            CMDBfServicesUtil.addIndent(tabsWriter, i);
            tempValue = tempValue.replace("\n", tabsWriter.toString());
            tempValue = String.valueOf(tabsWriter.toString()) + tempValue;
            return tempValue;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XMLWritableString other = (XMLWritableString)obj;
            return !(this.value == null ? other.value != null : !this.equalsSpaceIgnore(this.value, other.value));
        }

        private boolean equalsSpaceIgnore(String string1, String string2) {
            String cleanedString1 = string1.replaceAll("[\\t\\r\\n]", "");
            String cleanedString2 = string2.replaceAll("[\\t\\r\\n]", "");
            return cleanedString1.equals(cleanedString2);
        }
    }
}

