/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.impl;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.cmdbfservice.IServiceHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.exceptions.UnsupportedHandlerException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.IItemSelectorHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.IRelationshipSelectorHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.service.ISelectorHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.ISelector;

public abstract class AbstractSelectorHandlerFactory
implements ISelectorHandlerFactory {
    private static final int ITEM_TEMPLATE = 0;
    private static final int RELATIONSHIP_TEMPLATE = 1;
    private Map<Integer, Map<Integer, IServiceHandler>> cachedHandlers = new Hashtable<Integer, Map<Integer, IServiceHandler>>();

    public IItemSelectorHandler createItemHandler(ISelector selector) throws UnsupportedHandlerException {
        return (IItemSelectorHandler)this.createHandler(selector, 0);
    }

    public IRelationshipSelectorHandler createRelationshipHandler(ISelector selector) throws UnsupportedHandlerException {
        return (IRelationshipSelectorHandler)this.createHandler(selector, 1);
    }

    private IServiceHandler createHandler(ISelector selector, int templateType) throws UnsupportedHandlerException {
        Map<Integer, IServiceHandler> nestedMap;
        Object handler = null;
        int selectorType = selector.getType();
        if (this.isCachingSupported()) {
            nestedMap = this.cachedHandlers.get(templateType);
            IServiceHandler iServiceHandler = handler = nestedMap == null ? null : nestedMap.get(selectorType);
            if (handler != null) {
                return handler;
            }
        }
        switch (selectorType) {
            case 0: {
                handler = templateType == 0 ? this.createItemInstanceHandler() : this.createRelationshipInstanceHandler();
                break;
            }
            case 1: {
                handler = templateType == 0 ? this.createItemRecordHandler() : this.createRelationshipRecordHandler();
                break;
            }
            case 2: {
                handler = templateType == 0 ? this.createItemPropertyHandler() : this.createRelationshipPropertyHandler();
                break;
            }
            case 3: {
                handler = templateType == 0 ? this.createItemXPathHandler() : this.createRelationshipXPathHandler();
                break;
            }
            default: {
                throw new UnsupportedHandlerException("Unrecognized type of the selector");
            }
        }
        if (handler != null && this.isCachingSupported()) {
            nestedMap = this.cachedHandlers.get(templateType);
            if (nestedMap == null) {
                nestedMap = new Hashtable<Integer, IServiceHandler>();
                this.cachedHandlers.put(templateType, nestedMap);
            }
            nestedMap.put(selectorType, (IServiceHandler)handler);
        }
        return handler;
    }

    protected IItemSelectorHandler createItemInstanceHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unimplemented selector handler");
    }

    protected IItemSelectorHandler createItemPropertyHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unimplemented selector handler");
    }

    protected IItemSelectorHandler createItemRecordHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unimplemented selector handler");
    }

    protected IItemSelectorHandler createItemXPathHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unimplemented selector handler");
    }

    protected IRelationshipSelectorHandler createRelationshipInstanceHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unimplemented selector handler");
    }

    protected IRelationshipSelectorHandler createRelationshipPropertyHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unimplemented selector handler");
    }

    protected IRelationshipSelectorHandler createRelationshipRecordHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unimplemented selector handler");
    }

    protected IRelationshipSelectorHandler createRelationshipXPathHandler() throws UnsupportedHandlerException {
        throw new UnsupportedHandlerException("Unimplemented selector handler");
    }

    protected boolean isCachingSupported() {
        return true;
    }
}

