/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.broker.client;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.xml.namespace.QName;
import org.apache.muse.core.routing.CounterResourceIdFactory;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.eclipse.cosmos.dc.broker.client.BrokerClient;

public class BrokerTestClient {
    public static void addReferenceParameter(EndpointReference epr) {
        CounterResourceIdFactory factory = new CounterResourceIdFactory();
        QName name = factory.getIdentifierName();
        String value = factory.getNextIdentifier();
        epr.addParameter(name, (Object)value);
    }

    public static URI getLocalAddress(String contextPath, int port) throws UnknownHostException {
        String ip = InetAddress.getLocalHost().getHostAddress();
        StringBuffer address = new StringBuffer();
        address.append("http://");
        address.append(ip);
        address.append(':');
        address.append(port);
        if (contextPath.charAt(0) != '/') {
            address.append('/');
        }
        address.append(contextPath);
        return URI.create(address.toString());
    }

    public static void main(String[] args) {
        try {
            String contextPath = "/broker2/services/broker";
            int port = 8080;
            URI address = BrokerTestClient.getLocalAddress(contextPath, port);
            EndpointReference epr = new EndpointReference(address);
            epr.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME, (Object)"DataBroker");
            BrokerClient client = new BrokerClient(epr);
            client.setTrace(true);
            client.start();
            String[] eprs = client.getDataManagers("x");
            int i = 0;
            while (i < eprs.length) {
                System.out.println(eprs[i]);
                ++i;
            }
        }
        catch (Throwable error) {
            error.printStackTrace();
        }
    }
}

