/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.datafeed;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.datafeed.DataSetAdapter;
import org.eclipse.birt.chart.datafeed.DifferenceEntry;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.impl.DifferenceDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.StockDataSetImpl;

public final class DifferenceDataSetProcessorImpl
extends DataSetAdapter {
    public final DataSet populate(Object oResultSetDef, DataSet ds) throws ChartException {
        if (oResultSetDef instanceof IResultSetDataSet) {
            IResultSetDataSet rsds = (IResultSetDataSet)oResultSetDef;
            long lRowCount = rsds.getSize();
            if (lRowCount <= 0L) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 16, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
            }
            int i = 0;
            DifferenceEntry[] sea = new DifferenceEntry[(int)lRowCount];
            while (rsds.hasNext()) {
                Object[] oTwoComponents = rsds.next();
                this.validateDifferenceEntryData(oTwoComponents);
                sea[i++] = new DifferenceEntry(oTwoComponents);
            }
            if (ds == null) {
                ds = DifferenceDataSetImpl.create((Object)sea);
            } else {
                ds.setValues((Object)sea);
            }
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.unknown.custom.dataset", new Object[]{ds, oResultSetDef}, Messages.getResourceBundle(this.getULocale()));
        }
        return ds;
    }

    private void validateDifferenceEntryData(Object[] obja) throws ChartException {
        boolean valid = true;
        if (obja == null) {
            valid = false;
        } else if (obja.length != 2) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.dataset.differenceseries", Messages.getResourceBundle(this.getULocale()));
        }
        if (!valid) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 30, "exception.dataset.null.differenceentry", Messages.getResourceBundle(this.getULocale()));
        }
    }

    public final Object getMinimum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        double[] da = new double[2];
        double dMin = Double.MAX_VALUE;
        while (dsi.hasNext()) {
            DifferenceEntry dde = (DifferenceEntry)dsi.next();
            if (dde == null) continue;
            da[0] = dde.getPositiveValue();
            da[1] = dde.getNegativeValue();
            int j = 0;
            while (j < 2) {
                if (dMin > da[j]) {
                    dMin = da[j];
                }
                ++j;
            }
        }
        return new Double(dMin);
    }

    public final Object getMaximum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        double[] da = new double[2];
        double dMax = -1.7976931348623157E308;
        while (dsi.hasNext()) {
            DifferenceEntry dde = (DifferenceEntry)dsi.next();
            if (dde == null) continue;
            da[0] = dde.getPositiveValue();
            da[1] = dde.getNegativeValue();
            int j = 0;
            while (j < 2) {
                if (dMax < da[j]) {
                    dMax = da[j];
                }
                ++j;
            }
        }
        return new Double(dMax);
    }

    public final DataSet fromString(String sDataSetRepresentation, DataSet ds) throws ChartException {
        if (sDataSetRepresentation == null) {
            return ds;
        }
        if (ds == null) {
            ds = StockDataSetImpl.create(null);
        }
        StringTokenizer strTokDataElement = new StringTokenizer(sDataSetRepresentation, ",");
        StringTokenizer strTokComponents = null;
        String strDataElement = null;
        String strComponent = null;
        ArrayList<DifferenceEntry> vData = new ArrayList<DifferenceEntry>();
        while (strTokDataElement.hasMoreTokens()) {
            strDataElement = strTokDataElement.nextToken().trim();
            strTokComponents = new StringTokenizer(strDataElement);
            if (strTokComponents.countTokens() == 1) {
                double dComponent = Double.parseDouble(strDataElement);
                vData.add(new DifferenceEntry(dComponent, dComponent - 2.0));
                continue;
            }
            DifferenceEntry entry = new DifferenceEntry(Double.NaN, Double.NaN);
            while (strTokComponents.hasMoreTokens()) {
                strComponent = strTokComponents.nextToken().trim().toUpperCase();
                double dComponent = Double.parseDouble(strComponent.substring(1));
                if (strComponent.startsWith("P")) {
                    entry.setPositiveValue(dComponent);
                    continue;
                }
                if (!strComponent.startsWith("N")) continue;
                entry.setNegativeValue(dComponent);
            }
            vData.add(entry);
        }
        ds.setValues(vData);
        return ds;
    }

    public String getExpectedStringFormat() {
        return Messages.getString("info.difference.sample.format", this.getULocale());
    }

    public String toString(Object[] columnData) throws ChartException {
        if (columnData == null || columnData.length == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < columnData.length) {
            if (columnData[i] == null) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
            }
            if (columnData[i] instanceof Object[]) {
                buffer.append(this.toDifferenceString((Object[])columnData[i]));
            }
            if (i < columnData.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    private StringBuffer toDifferenceString(Object[] differenceArray) throws ChartException {
        if (differenceArray.length != 2 || differenceArray[0] == null) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "Invalid data set column");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("P" + String.valueOf(differenceArray[0]) + " ");
        buffer.append("N" + String.valueOf(differenceArray[1]));
        return buffer;
    }
}

