/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.remote;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.AgentConfiguration;
import org.eclipse.hyades.internal.execution.remote.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.remote.AgentControllerListener;
import org.eclipse.hyades.internal.execution.remote.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.remote.AgentNotRegisteredException;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.MonitorListener;
import org.eclipse.hyades.internal.execution.remote.RemoteClientListener;

public class RemoteComponentSkeleton {
    private static final boolean nativesAvailable;
    private boolean isLogging = false;
    private boolean isInitialized = false;
    protected final Vector monitorListeners = new Vector();
    protected final Vector serverListeners = new Vector();
    protected final Vector commandListeners = new Vector();
    protected final Vector clientListeners = new Vector();
    private boolean uuidsValid = false;
    private String agentUUID;
    private String nodeUUID;
    private String jvmUUID;
    private String name;
    private String type;
    private boolean isRegistered = false;
    private long mechanism = -1L;
    private static boolean serviceAvailable;
    private static int agentCount;
    private boolean requestForMonitor = false;
    private Object _optionLock = new Object();
    private AgentConfiguration _defaultConfiguration = null;

    static {
        serviceAvailable = false;
        agentCount = 0;
        boolean nativesLoadable = false;
        try {
            System.loadLibrary("hcclco");
            System.loadLibrary("hccls");
            System.loadLibrary("hcbnd");
            System.loadLibrary("hcclsm");
            System.loadLibrary("hccldt");
            System.loadLibrary("hcjbnd");
            nativesLoadable = true;
        }
        catch (Throwable throwable) {}
        nativesAvailable = nativesLoadable;
    }

    public RemoteComponentSkeleton(String name, String type) {
        this.setName(name);
        this.setType(type);
        this._defaultConfiguration = new AgentConfiguration();
        this._defaultConfiguration.setAgentName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentControllerListener(AgentControllerListener listener) {
        Vector vector = this.serverListeners;
        synchronized (vector) {
            this.serverListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitorListener(MonitorListener listener) {
        Vector vector = this.monitorListeners;
        synchronized (vector) {
            this.monitorListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteClientListener(RemoteClientListener listener) {
        Vector vector = this.clientListeners;
        synchronized (vector) {
            this.clientListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandListener(CustomCommandHandler listener) {
        Vector vector = this.commandListeners;
        synchronized (vector) {
            this.commandListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void agentControllerActive() {
        serviceAvailable = true;
        this.uuidsValid = true;
        Serializable serializable = this.getClass();
        synchronized (serializable) {
            if (agentCount == 0) {
                this.getClass().notify();
            }
        }
        serializable = this.serverListeners;
        synchronized (serializable) {
            Enumeration e = this.serverListeners.elements();
            while (e.hasMoreElements()) {
                AgentControllerListener listener = (AgentControllerListener)e.nextElement();
                listener.agentControllerActive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void agentControllerInactive() {
        serviceAvailable = false;
        this.setLogging(false);
        this._defaultConfiguration.clear();
        Vector vector = this.serverListeners;
        synchronized (vector) {
            Enumeration e = this.serverListeners.elements();
            while (e.hasMoreElements()) {
                AgentControllerListener listener = (AgentControllerListener)e.nextElement();
                listener.agentControllerInactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remoteClientExited() {
        this.setLogging(false);
        Vector vector = this.clientListeners;
        synchronized (vector) {
            Enumeration e = this.clientListeners.elements();
            while (e.hasMoreElements()) {
                RemoteClientListener listener = (RemoteClientListener)e.nextElement();
                listener.clientInactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deregister() {
        if (this.isInitialized) {
            this.deregister0(this.name);
            this.isInitialized = false;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                --agentCount;
            }
        }
    }

    private native void deregister0(String var1);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalize() {
        try {
            this.deregister0(this.name);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            try {
                super.finalize();
                throw throwable;
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        try {}
        catch (Throwable throwable) {
            return;
        }
        super.finalize();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public long getPID() {
        if (nativesAvailable) {
            return this.getPID0();
        }
        return 0L;
    }

    private native long getPID0();

    public String getOptionValue(String name) {
        return this.getOptionValue(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOptionValue(String name, String type) {
        Enumeration elements = this._defaultConfiguration._entries.elements();
        if (!elements.hasMoreElements()) {
            Object object = this._optionLock;
            synchronized (object) {
                try {
                    this._optionLock.wait(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            elements = this._defaultConfiguration._entries.elements();
        }
        while (elements.hasMoreElements()) {
            Object obj = elements.nextElement();
            if (!(obj instanceof AgentConfigurationEntry)) continue;
            AgentConfigurationEntry entry = (AgentConfigurationEntry)obj;
            if (!(name != null && type != null ? entry.getName().equals(name) && entry.getType().equals(type) : (name == null ? entry.getType().equals(type) : type == null && entry.getName().equals(name)))) continue;
            return entry.getValue();
        }
        return null;
    }

    public String generateUUID() {
        if (nativesAvailable) {
            return this.generateUUID0();
        }
        return null;
    }

    private native String generateUUID0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize() throws AgentControllerUnavailableException {
        if (!nativesAvailable) {
            throw new AgentControllerUnavailableException();
        }
        if (!this.isInitialized) {
            this.initializeEngine0(this.name, this.type);
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (agentCount == 0) {
                    try {
                        this.getClass().wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++agentCount;
            }
            this.isInitialized = true;
        }
        if (!serviceAvailable) {
            throw new AgentControllerUnavailableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initializeFast() throws AgentControllerUnavailableException {
        if (!nativesAvailable) {
            throw new AgentControllerUnavailableException();
        }
        if (!this.isInitialized) {
            this.initializeEngine0(this.name, this.type);
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                ++agentCount;
            }
            this.isInitialized = true;
        }
        if (!serviceAvailable) {
            throw new AgentControllerUnavailableException();
        }
    }

    private native void initializeEngine0(String var1, String var2) throws AgentControllerUnavailableException;

    public boolean isAgentControllerActive() {
        return serviceAvailable;
    }

    public boolean isLogging() {
        return this.isLogging;
    }

    public synchronized long logMessageReturn(byte[] msg, int offset, int len) {
        long byteSent = 0L;
        if (this.isLogging) {
            byteSent = this.logMessage0(this.name, msg, offset, len);
        }
        return byteSent;
    }

    public synchronized void logMessage(byte[] msg, int offset, int len) {
        this.logMessageReturn(msg, offset, len);
    }

    public synchronized long logMessageReturn(String msg) {
        long byteSent = 0L;
        if (this.isLogging) {
            byteSent = this.logMessage0(this.name, msg);
        }
        return byteSent;
    }

    public synchronized void logMessage(String msg) {
        this.logMessageReturn(msg);
    }

    private native long logMessage0(String var1, byte[] var2, int var3, int var4);

    private native long logMessage0(String var1, String var2);

    public synchronized long logErrMsgReturn(String message, String messageId, int severity) {
        return this.logErrorMessage(message, messageId, severity);
    }

    public synchronized void logErrMsg(String message, String messageId, int severity) {
        this.logErrMsgReturn(message, messageId, severity);
    }

    private native long logErrorMessage(String var1, String var2, int var3);

    public synchronized long logMessageUTF8Return(String msg) {
        long byteSent = 0L;
        if (this.isLogging) {
            try {
                byteSent = this.logMessageUTF81(this.name, msg.getBytes("UTF-8"));
            }
            catch (Throwable throwable) {
                byteSent = this.logMessageUTF80(this.name, msg);
            }
        }
        return byteSent;
    }

    public synchronized void logMessageUTF8(String msg) {
        this.logMessageUTF8Return(msg);
    }

    private native long logMessageUTF81(String var1, byte[] var2);

    private native long logMessageUTF80(String var1, String var2);

    public long sendMessageToAttachedClientReturn(String message, long contextId) {
        long byteSent = 0L;
        if (nativesAvailable) {
            try {
                byte[] bytes = message.getBytes("UTF-8");
                byteSent = this.sendMessageBinary0(bytes, 0, bytes.length, contextId);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return byteSent;
    }

    public void sendMessageToAttachedClient(String message, long contextId) {
        this.sendMessageToAttachedClientReturn(message, contextId);
    }

    native long sendMessage0(String var1, long var2);

    public long sendMessageToAttachedClientReturn(byte[] message, int offset, int length, long contextId) {
        long byteSent = 0L;
        if (nativesAvailable) {
            byteSent = this.sendMessageBinary0(message, offset, length, contextId);
        }
        return byteSent;
    }

    public void sendMessageToAttachedClient(byte[] message, int offset, int length, long contextId) {
        this.sendMessageToAttachedClientReturn(message, offset, length, contextId);
    }

    native long sendMessage0(byte[] var1, int var2, int var3, long var4);

    native long sendMessageBinary0(byte[] var1, int var2, int var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setLogging(boolean log) {
        this.isLogging = log;
        Object object = this.monitorListeners;
        synchronized (object) {
            Enumeration e = this.monitorListeners.elements();
            while (e.hasMoreElements()) {
                MonitorListener listener = (MonitorListener)e.nextElement();
                if (this.isLogging) {
                    listener.monitorActive();
                    continue;
                }
                listener.monitorInactive();
            }
        }
        if (this.isLogging && this.requestForMonitor) {
            object = this;
            synchronized (object) {
                this.notify();
            }
        }
    }

    private void setName(String name) {
        this.name = new String(name);
    }

    private void setType(String type) {
        this.type = new String(type);
    }

    void setAgentUUID(String type) {
        this.agentUUID = type;
    }

    public String getAgentUUID() {
        return this.agentUUID;
    }

    void setNodeUUID(String type) {
        this.nodeUUID = type;
    }

    public String getNodeUUID() throws AgentNotRegisteredException {
        if (!this.uuidsValid) {
            throw new AgentNotRegisteredException();
        }
        return this.nodeUUID;
    }

    void setJVMUUID(String type) {
        this.jvmUUID = type;
    }

    public String getJVMUUID() throws AgentNotRegisteredException {
        if (!this.uuidsValid) {
            throw new AgentNotRegisteredException();
        }
        return this.jvmUUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void requestMonitorThroughPeer_p(InetAddress addr, long port, String agentUUID, long timeout) {
        if (!nativesAvailable) {
            return;
        }
        RemoteComponentSkeleton remoteComponentSkeleton = this;
        synchronized (remoteComponentSkeleton) {
            this.requestForMonitor = true;
            this.requestMonitorThroughPeer0p(addr.getAddress(), port, agentUUID);
            try {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {}
                Object var8_8 = null;
                this.requestForMonitor = false;
                return;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.requestForMonitor = false;
                throw throwable;
            }
        }
    }

    public void requestMonitorThroughPeer(InetAddress addr, String agentUUID, long timeout) {
        this.requestMonitorThroughPeer_p(addr, 10002L, agentUUID, timeout);
    }

    native void requestMonitorThroughPeer0(byte[] var1, String var2);

    private native void requestMonitorThroughPeer0p(byte[] var1, long var2, String var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void requestMonitorThroughPeer_p(InetAddress addr, long port, long pid, String agentName, long timeout) {
        if (!nativesAvailable) {
            return;
        }
        RemoteComponentSkeleton remoteComponentSkeleton = this;
        synchronized (remoteComponentSkeleton) {
            this.requestForMonitor = true;
            this.requestMonitorThroughPeer0p(addr.getAddress(), port, pid, agentName);
            try {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {}
                Object var10_9 = null;
                this.requestForMonitor = false;
                return;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this.requestForMonitor = false;
                throw throwable;
            }
        }
    }

    public void requestMonitorThroughPeer(InetAddress addr, long pid, String agentName, long timeout) {
        this.requestMonitorThroughPeer_p(addr, 10002L, pid, agentName, timeout);
    }

    native void requestMonitorThroughPeer0(byte[] var1, long var2, String var4);

    native void requestMonitorThroughPeer0p(byte[] var1, long var2, long var4, String var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void peerUnreachable() {
        RemoteComponentSkeleton remoteComponentSkeleton = this;
        synchronized (remoteComponentSkeleton) {
            if (this.requestForMonitor) {
                this.notifyAll();
            }
        }
    }

    public AgentConfiguration getDefaultConfiguration() {
        return this._defaultConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntryToDefaultConfiguration(AgentConfigurationEntry entry) {
        this._defaultConfiguration.addEntry(entry);
        if (System.getProperty("tptp.debug") != null && System.getProperty("tptp.debug").equalsIgnoreCase("true")) {
            System.out.println("Adding: " + entry.getName() + "/" + entry.getType() + "/" + entry.getValue());
        }
        Object object = this._optionLock;
        synchronized (object) {
            this._optionLock.notifyAll();
        }
    }

    public void broadcastMessage(String message, long contextId) {
        this.sendMessageToAttachedClient(message, contextId);
    }

    public void broadcastMessage(byte[] message, int offset, int length, long contextId) {
        this.sendMessageToAttachedClient(message, offset, length, contextId);
    }

    Object createObjectInContextOfClassLoader(String objectType) {
        Object result = null;
        try {
            Class<?> clazz = Class.forName(objectType);
            result = clazz.newInstance();
        }
        catch (Throwable throwable) {}
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incomingCommand(CommandElement command) {
        if (command instanceof CustomCommand) {
            Vector vector = this.commandListeners;
            synchronized (vector) {
                Enumeration e = this.commandListeners.elements();
                while (e.hasMoreElements()) {
                    CustomCommandHandler listener = (CustomCommandHandler)e.nextElement();
                    listener.handleCommand((CustomCommand)command);
                }
            }
        }
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }
}

