/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.StructRefValue;

abstract class AbstractLibraryRecord
extends SimpleRecord {
    protected Module module;
    protected Library library;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.command.AbstractLibraryRecord");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    AbstractLibraryRecord(Module module, Library library) {
        this.module = module;
        this.library = library;
    }

    AbstractLibraryRecord(Module module) {
        this.module = module;
    }

    public DesignElement getTarget() {
        return this.module;
    }

    public void updateReferenceableClients(List librariesToUpdate) {
        int size = librariesToUpdate.size();
        List libraries = this.module.getLibraries();
        int i = 0;
        while (i < size) {
            this.updateReferenceableClients((Library)libraries.get(i));
            ++i;
        }
    }

    public void updateReferenceableClients(Library library) {
        this.updateReferenceableClients(library, 0);
        List images = library.getListProperty(library, "images");
        if (images == null || images.isEmpty()) {
            return;
        }
        boolean sendEvent = false;
        int i = 0;
        while (i < images.size()) {
            EmbeddedImage image = (EmbeddedImage)images.get(i);
            List clients = image.getClientStructures();
            if (clients != null && !clients.isEmpty()) {
                Object client;
                int j = 0;
                while (j < clients.size()) {
                    client = (Structure)clients.get(j);
                    StructRefValue value = (StructRefValue)((Structure)client).getLocalProperty(this.module, "libReference");
                    if (!$assertionsDisabled && value == null) {
                        throw new AssertionError();
                    }
                    value.unresolved(value.getName());
                    image.dropClientStructure((Structure)client);
                    sendEvent = true;
                    ++j;
                }
                clients = image.getClientList();
                if (clients != null && !clients.isEmpty()) {
                    j = 0;
                    while (j < clients.size()) {
                        client = (BackRef)clients.get(j);
                        DesignElement element = ((BackRef)client).getElement();
                        StructRefValue value = (StructRefValue)element.getLocalProperty(this.module, ((BackRef)client).getPropertyName());
                        if (!$assertionsDisabled && value == null) {
                            throw new AssertionError();
                        }
                        value.unresolved(value.getName());
                        image.dropClient(element);
                        element.broadcast(new PropertyEvent(this.module, ((BackRef)client).getPropertyName()));
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (sendEvent) {
            this.module.broadcast(new PropertyEvent(this.module, "images"));
        }
    }

    private void updateReferenceableClients(DesignElement target, int slotId) {
        ContainerSlot slot = target.getSlot(slotId);
        Iterator iter = slot.iterator();
        while (iter.hasNext()) {
            DesignElement element = (DesignElement)iter.next();
            if (!$assertionsDisabled && !(element instanceof IReferencableElement)) {
                throw new AssertionError();
            }
            IReferencableElement referenceableElement = (IReferencableElement)((Object)element);
            referenceableElement.updateClientReferences();
            if (!(referenceableElement instanceof Theme)) continue;
            this.updateReferenceableClients((DesignElement)((Object)referenceableElement), 0);
            List csses = ((ICssStyleSheetOperation)((Object)referenceableElement)).getCsses();
            Iterator cssIterator = csses.iterator();
            while (cssIterator.hasNext()) {
                CssStyleSheet styleSheet = (CssStyleSheet)cssIterator.next();
                List styles = styleSheet.getStyles();
                Iterator styleIterator = styles.iterator();
                while (styleIterator.hasNext()) {
                    CssStyle cssStyle = (CssStyle)styleIterator.next();
                    cssStyle.updateClientReferences();
                }
            }
        }
    }
}

