/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;

public class CachedMemberRef
extends MemberRef {
    private static final int UNKNOWN = 1;
    private static final int LOCAL = 2;
    private static final int INHERITED = 3;
    private static final int REFERRED = 4;
    private final Object[] cachedObjects = new Object[2];
    private boolean cached = false;
    private int cachedFrom = 1;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.core.CachedMemberRef");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CachedMemberRef(MemberRef ref) {
        super(ref);
        this.cachedObjects[0] = ((CachedMemberRef)ref).cachedObjects[0];
        this.cachedObjects[1] = ((CachedMemberRef)ref).cachedObjects[1];
        this.cached = ((CachedMemberRef)ref).cached;
        this.cachedFrom = ((CachedMemberRef)ref).cachedFrom;
    }

    public CachedMemberRef(ElementPropertyDefn prop) {
        super(prop);
    }

    public CachedMemberRef(ElementPropertyDefn prop, int n) {
        super(prop, n);
    }

    public CachedMemberRef(ElementPropertyDefn prop, int n, String memberName) {
        super(prop, n, memberName);
    }

    public CachedMemberRef(ElementPropertyDefn prop, int n, StructPropertyDefn memberDef) {
        super(prop, n, memberDef);
    }

    public CachedMemberRef(ElementPropertyDefn prop, String memberName) {
        super(prop, memberName);
    }

    public CachedMemberRef(ElementPropertyDefn prop, StructPropertyDefn memberDef) {
        super(prop, memberDef);
    }

    public CachedMemberRef(MemberRef ref, int n) {
        super(ref, n);
        if (ref instanceof CachedMemberRef) {
            this.cachedObjects[0] = ((CachedMemberRef)ref).cachedObjects[0];
            this.cachedObjects[1] = ((CachedMemberRef)ref).cachedObjects[1];
        }
    }

    public CachedMemberRef(MemberRef ref, int n, StructPropertyDefn memberDefn) {
        super(ref, n, memberDefn);
        if (ref instanceof CachedMemberRef) {
            this.cachedObjects[0] = ((CachedMemberRef)ref).cachedObjects[0];
            this.cachedObjects[1] = ((CachedMemberRef)ref).cachedObjects[1];
        }
    }

    public CachedMemberRef(MemberRef ref, String memberName) {
        super(ref, memberName);
        if (ref instanceof CachedMemberRef) {
            this.cachedObjects[0] = ((CachedMemberRef)ref).cachedObjects[0];
            this.cachedObjects[1] = ((CachedMemberRef)ref).cachedObjects[1];
            this.cached = ((CachedMemberRef)ref).cached;
            this.cachedFrom = ((CachedMemberRef)ref).cachedFrom;
        }
    }

    public CachedMemberRef(MemberRef ref, StructPropertyDefn memberDefn) {
        super(ref, memberDefn);
        if (ref instanceof CachedMemberRef) {
            this.cachedObjects[0] = ((CachedMemberRef)ref).cachedObjects[0];
            this.cachedObjects[1] = ((CachedMemberRef)ref).cachedObjects[1];
            this.cached = ((CachedMemberRef)ref).cached;
            this.cachedFrom = ((CachedMemberRef)ref).cachedFrom;
        }
    }

    public boolean checkOrCacheStructure(Module module, DesignElement element) {
        if (this.cached) {
            return this.checkCachedStructure(module, element);
        }
        this.doCacheStructure(module, element);
        if (!$assertionsDisabled && this.cachedFrom == 1) {
            throw new AssertionError();
        }
        return true;
    }

    private void doCacheStructure(Module module, DesignElement element) {
        Object localValue = element.getLocalProperty(module, this.propDefn);
        Object realValue = element.getProperty(module, this.propDefn);
        int n = this.cachedFrom = localValue != null ? 2 : 3;
        if (localValue != realValue) {
            this.cachedFrom = 4;
        }
        if (this.propDefn.isListType()) {
            List list = (List)localValue;
            if (this.cachedFrom == 3 || this.cachedFrom == 4) {
                list = (List)realValue;
            }
            if (list == null) {
                this.cached = true;
                return;
            }
            if (this.depth >= 1) {
                this.cachedObjects[0] = super.getValue(list, 0);
            }
            if (this.depth == 1) {
                this.cached = true;
                return;
            }
            if (!$assertionsDisabled && localValue == null) {
                throw new AssertionError();
            }
            list = super.getList(module, element);
            this.cachedObjects[1] = super.getValue(list, 1);
        } else {
            Structure struct = (Structure)element.getProperty(module, this.propDefn);
            if (struct == null) {
                this.cached = true;
                return;
            }
            if (this.index[0] >= 0) {
                if (!$assertionsDisabled && !this.member[0].isList()) {
                    throw new AssertionError();
                }
                ArrayList list = (ArrayList)struct.getProperty(module, this.member[0]);
                this.cachedObjects[0] = super.getValue(list, 0);
            }
        }
        this.cached = true;
    }

    private boolean checkCachedStructure(Module module, DesignElement element) {
        if (!$assertionsDisabled && !this.cached) {
            throw new AssertionError();
        }
        Object localValue = element.getLocalProperty(module, this.propDefn);
        Object realValue = element.getProperty(module, this.propDefn);
        if (this.cachedFrom == 2 && localValue == null || this.cachedFrom == 3 && localValue != null) {
            this.cachedObjects[0] = null;
            this.cachedObjects[1] = null;
            this.doCacheStructure(module, element);
            return true;
        }
        if (this.propDefn.isListType()) {
            List list = (List)localValue;
            if (this.cachedFrom == 3 || this.cachedFrom == 4) {
                list = (List)realValue;
            }
            if (list == null) {
                return this.cachedObjects[0] == null;
            }
            if (this.depth >= 1) {
                if (!(this.index[0] >= 0 && this.index[0] < list.size() && this.cachedObjects[0] == list.get(this.index[0]) || this.cachedObjects[0] == null || list.contains(this.cachedObjects[0]))) {
                    return false;
                }
                if (this.depth == 1) {
                    return true;
                }
            }
            if (this.member[0] != null && this.member[0].isList()) {
                if (!$assertionsDisabled && !(this.cachedObjects[0] instanceof Structure)) {
                    throw new AssertionError();
                }
                list = (List)((Structure)this.cachedObjects[0]).getProperty(module, this.member[0]);
            }
            if (!(this.depth != 2 || this.index[1] >= 0 && this.index[1] < list.size() && this.cachedObjects[1] == list.get(this.index[1]) || this.cachedObjects[1] == null || list.contains(this.cachedObjects[1]))) {
                return false;
            }
        }
        return true;
    }

    public List getList(Module module, DesignElement element) {
        if (!this.checkOrCacheStructure(module, element)) {
            return null;
        }
        return super.getList(module, element);
    }

    public Object getLocalValue(Module module, DesignElement element) {
        if (!this.checkOrCacheStructure(module, element)) {
            return null;
        }
        return super.getLocalValue(module, element);
    }

    public Structure getStructure(Module module, DesignElement element) {
        if (!this.checkOrCacheStructure(module, element)) {
            return null;
        }
        return super.getStructure(module, element);
    }

    public Object getValue(Module module, DesignElement element) {
        if (!this.checkOrCacheStructure(module, element)) {
            return null;
        }
        if (this.propDefn.isListType()) {
            switch (this.refType) {
                case 0: {
                    return super.getList(module, element);
                }
                case 5: {
                    return this.getValue(null, 0);
                }
                case 7: {
                    return this.getValue(null, 1);
                }
                case 6: {
                    Structure struct = (Structure)this.getValue(null, 0);
                    if (struct == null) {
                        return null;
                    }
                    return struct.getProperty(module, this.member[0]);
                }
                case 8: 
                case 9: {
                    Structure struct = (Structure)this.getValue(null, 1);
                    if (struct == null) {
                        return null;
                    }
                    return struct.getProperty(module, this.member[1]);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        return super.getValue(module, element);
    }

    protected Object getValue(List list, int level) {
        if (!$assertionsDisabled && level != 0 && level != 1) {
            throw new AssertionError();
        }
        return this.cachedObjects[level];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CachedMemberRef)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CachedMemberRef temp = (CachedMemberRef)obj;
        return temp.cached == this.cached && temp.cachedFrom == this.cachedFrom && this.equalArray(temp.cachedObjects, this.cachedObjects);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 7 * hash + (this.cached ? 1 : 0);
        hash = 7 * hash + this.cachedFrom;
        hash = this.addObjectArrayHashCode(hash, this.cachedObjects);
        return hash;
    }

    public void checkOrCacheStructure(IStructure struct) {
        if (!$assertionsDisabled && this.depth != 1) {
            throw new AssertionError();
        }
        this.cached = true;
        this.cachedFrom = 2;
        this.cachedObjects[this.depth - 1] = struct;
    }

    public void cacheStructureInForce(Module module, DesignElement element) {
        this.cached = false;
        this.doCacheStructure(module, element);
        if (!$assertionsDisabled && this.cachedFrom != 2) {
            throw new AssertionError();
        }
    }
}

