/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;

public class CssStyleSheetAdapter
implements ICssStyleSheetOperation {
    private List csses = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.css.CssStyleSheetAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static CssStyleSheet getCssStyleSheetByLocation(Module module, List csses, String location) {
        if (location == null || csses == null) {
            return null;
        }
        URL url = module.findResource(location, 3);
        if (url == null) {
            return null;
        }
        String fileLocation = url.getFile();
        int i = 0;
        while (i < csses.size()) {
            CssStyleSheet css = (CssStyleSheet)csses.get(i);
            String tmpFileName = css.getFileName();
            url = module.findResource(tmpFileName, 3);
            if (url != null && fileLocation.equalsIgnoreCase(tmpFileName = url.getFile())) {
                return css;
            }
            ++i;
        }
        return null;
    }

    public static int getPositionOfCssStyleSheet(Module module, List csses, String location) {
        if (location == null || csses == null) {
            return -1;
        }
        URL url = module.findResource(location, 3);
        if (url == null) {
            return -1;
        }
        String fileLocation = url.getFile();
        int i = 0;
        while (i < csses.size()) {
            CssStyleSheet css = (CssStyleSheet)csses.get(i);
            String tmpFileName = css.getFileName();
            url = module.findResource(tmpFileName, 3);
            if (url != null && fileLocation.equalsIgnoreCase(tmpFileName = url.getFile())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int dropCss(CssStyleSheet css) {
        if (!$assertionsDisabled && this.csses == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.csses.contains(css)) {
            throw new AssertionError();
        }
        int posn = this.csses.indexOf(css);
        if (posn != -1) {
            this.csses.remove(posn);
        }
        return posn;
    }

    public void addCss(CssStyleSheet css) {
        if (this.csses == null) {
            this.csses = new ArrayList();
        }
        this.csses.add(css);
    }

    public void insertCss(CssStyleSheet css, int index) {
        if (this.csses == null) {
            this.csses = new ArrayList();
        }
        if (index < 0 || index > this.csses.size()) {
            return;
        }
        this.csses.add(index, css);
    }

    public List getCsses() {
        if (this.csses == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.csses);
    }
}

