/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaObject;
import org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.ExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.PropertyProviderManifest;

class ConnectionPropertyHandler
extends OdaObject {
    private String m_consumerApplId;
    private Object m_connPropContext;

    ConnectionPropertyHandler() {
    }

    protected String getConsumerApplicationId() {
        return this.m_consumerApplId;
    }

    protected Object getConnectionPropertyContext() {
        return this.m_connPropContext;
    }

    void processConsumerAppContext(Object context) {
        String methodName = "ConnectionPropertyHandler.processConsumerAppContext( " + context + " )\t";
        this.logMethodCalled(methodName);
        if (context == null || !(context instanceof Map)) {
            this.logMethodExit(methodName);
            return;
        }
        Map contextMap = (Map)context;
        Object value = contextMap.get("OdaConsumerId");
        if (value == null || !(value instanceof String)) {
            this.logMethodExit(methodName);
            return;
        }
        this.m_consumerApplId = (String)value;
        this.log(methodName, "Consumer Application ID: " + this.m_consumerApplId);
        this.m_connPropContext = contextMap.get("OdaConnPropertyContext");
        this.log(methodName, "Externalized property context: " + this.m_connPropContext);
        this.logMethodExit(methodName);
    }

    protected Properties getEffectiveProperties(Properties candidateProperties) throws OdaException {
        String methodName = "ConnectionPropertyHandler.getEffectiveProperties( " + candidateProperties + " )\t";
        this.logMethodCalled(methodName);
        IPropertyProvider propProvider = this.getExtensionPropertyProvider();
        if (propProvider == null) {
            this.logMethodExit(methodName);
            return candidateProperties;
        }
        Properties effectiveProps = propProvider.getDataSourceProperties(candidateProperties, this.getConnectionPropertyContext());
        this.log(methodName, "Effective properties: " + effectiveProps);
        this.logMethodExit(methodName);
        return effectiveProps;
    }

    private IPropertyProvider getExtensionPropertyProvider() throws OdaException {
        String methodName = "ConnectionPropertyHandler.getExtensionPropertyProvider()\t";
        String applicationId = this.getConsumerApplicationId();
        if (applicationId == null || applicationId.length() == 0) {
            this.log("ConnectionPropertyHandler.getExtensionPropertyProvider()\t", "No ODA consumer application id specified in application context.");
            return null;
        }
        PropertyProviderManifest providerManifest = ExtensionExplorer.getInstance().getPropertyProviderManifest(applicationId);
        if (providerManifest == null) {
            this.log("ConnectionPropertyHandler.getExtensionPropertyProvider()\t", "No IPropertyProvider found for " + applicationId);
            return null;
        }
        IPropertyProvider extnProvider = providerManifest.createProvider();
        this.log("ConnectionPropertyHandler.getExtensionPropertyProvider()\t", "Found IPropertyProvider " + extnProvider + " for " + applicationId);
        return extnProvider;
    }
}

