/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.artifacts;

import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementLocation;

public class ElementModel
extends ElementLocation {
    private String source;
    private String elementName;
    private int endingLine;
    private int endingColumn;
    private String additionalSchemaLocation;

    public ElementModel(String name, String filePath, int lineNumber, int columnNumber) {
        super(filePath, lineNumber, columnNumber);
        this.elementName = name;
    }

    public int getEndingLine() {
        return this.endingLine;
    }

    public void setEndingLine(int endingLine) {
        this.endingLine = endingLine;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String contents) {
        this.source = contents;
    }

    public String getElementName() {
        return this.elementName;
    }

    public int getEndingColumn() {
        return this.endingColumn;
    }

    public void setEndingColumn(int columnNumber) {
        this.endingColumn = columnNumber;
    }

    public int numberOfLines() {
        if (this.getLineNumber() > this.getEndingLine()) {
            return 0;
        }
        return this.getEndingLine() - this.getLineNumber() + 1;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " <" + this.elementName + "> line=" + this.getLineNumber() + ", col=" + this.getColumnNumber();
    }

    public void setAdditionalSchemaLocation(String string) {
        this.additionalSchemaLocation = string;
    }

    public String getAdditionalSchemaLocation() {
        return this.additionalSchemaLocation;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ElementModel)) {
            return false;
        }
        ElementModel elementModel = (ElementModel)o;
        return this.elementName.equals(elementModel.getElementName()) && new Path(this.getFilePath()).equals((Object)new Path(elementModel.getFilePath())) && this.source.equals(elementModel.getSource());
    }
}

