/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.reference;

import java.util.StringTokenizer;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.reference.AbstractScheme;
import org.eclipse.cosmos.rm.validation.internal.reference.IXScheme;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointerExpression;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointerScheme;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointerSyntaxException;
import org.eclipse.cosmos.rm.validation.internal.reference.XmlnsScheme;
import org.eclipse.osgi.util.NLS;

public class XPointer {
    public static XPointerExpression compile(String expression) throws XPointerSyntaxException {
        XPointerExpression xpointerExpression;
        if (XPointer.unescapedCharExists(expression, '(')) {
            xpointerExpression = XPointer.parseFullXPointer(expression);
        } else if (XPointer.unescapedCharExists(expression, '/')) {
            xpointerExpression = XPointer.parseChildSequence(expression);
        } else {
            xpointerExpression = new XPointerExpression(0);
            xpointerExpression.setBareName(expression);
        }
        return xpointerExpression;
    }

    private static XPointerExpression parseChildSequence(String expression) throws XPointerSyntaxException {
        XPointerExpression xpointerExpression = new XPointerExpression(1);
        StringTokenizer st = new StringTokenizer(expression, "/");
        int count = 0;
        while (st.hasMoreTokens()) {
            String currentToken = st.nextToken();
            if (XPointer.isNumber(currentToken)) {
                xpointerExpression.addChildSequence(Integer.parseInt(currentToken));
            } else if (count == 0) {
                xpointerExpression.setBareName(currentToken);
            } else {
                throw new XPointerSyntaxException(NLS.bind((String)SMLValidationMessages.errorCSNotNumber, (Object[])new String[]{currentToken, expression}));
            }
            ++count;
        }
        return xpointerExpression;
    }

    private static boolean isNumber(String str) {
        int i = 0;
        int charCount = str.length();
        while (i < charCount) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return str.length() > 0;
    }

    private static XPointerExpression parseFullXPointer(String expression) throws XPointerSyntaxException {
        XPointerExpression xpointerExpression = new XPointerExpression(2);
        StringBuffer scheme = new StringBuffer();
        StringBuffer schemeExpression = new StringBuffer();
        IXScheme currentScheme = null;
        boolean readState = false;
        boolean unescapedChar = false;
        char currentChar = '\u0000';
        int lastChar = 0;
        int i = 0;
        int charCount = expression.length();
        while (i < charCount) {
            currentChar = expression.charAt(i);
            boolean bl = unescapedChar = 94 == lastChar;
            if (readState) {
                if (!unescapedChar && ')' == currentChar) {
                    readState = false;
                    currentScheme.setExpression(schemeExpression.toString());
                    schemeExpression = new StringBuffer();
                } else if (unescapedChar || '^' != currentChar) {
                    schemeExpression.append(currentChar);
                }
            } else if (!unescapedChar && '(' == currentChar) {
                readState = true;
                currentScheme = XPointer.createScheme(scheme.toString().trim());
                xpointerExpression.addScheme(currentScheme);
                scheme = new StringBuffer();
            } else {
                if (!unescapedChar && currentChar == ')') {
                    throw new XPointerSyntaxException(NLS.bind((String)SMLValidationMessages.errorUnbalancedBracket, (Object)expression));
                }
                if (unescapedChar || '^' != currentChar) {
                    scheme.append(currentChar);
                }
            }
            lastChar = currentChar;
            ++i;
        }
        if (scheme.toString().length() > 0) {
            throw new XPointerSyntaxException(NLS.bind((String)SMLValidationMessages.errorMissingExpression, (Object)scheme.toString()));
        }
        if (schemeExpression.toString().length() > 0) {
            throw new XPointerSyntaxException(NLS.bind((String)SMLValidationMessages.errorUnclosedExpression, (Object)schemeExpression.toString()));
        }
        return xpointerExpression;
    }

    private static IXScheme createScheme(String scheme) {
        if ("xpointer".equals(scheme)) {
            return new XPointerScheme();
        }
        if ("xmlns".equals(scheme)) {
            return new XmlnsScheme();
        }
        return NullScheme.instance;
    }

    private static boolean unescapedCharExists(String expression, char character) {
        int previousCharacter = 0;
        int i = 0;
        int charCount = expression.length();
        while (i < charCount) {
            if (character == expression.charAt(i) && previousCharacter != 94) {
                return true;
            }
            previousCharacter = expression.charAt(i);
            ++i;
        }
        return false;
    }

    private static class NullScheme
    extends AbstractScheme {
        private static final IXScheme instance = new NullScheme();

        private NullScheme() {
        }

        public Object evaluate(Object context) {
            return context;
        }

        public String getType() {
            return null;
        }
    }
}

