/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.adapter.Adapter;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.IStatus;
import org.eclipse.hyades.logging.adapter.impl.SensorStatus;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.SerializationException;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.LoggingParsersPlugin;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;
import org.eclipse.hyades.logging.parsers.adapter.outputters.AdapterLogOutputter;
import org.eclipse.hyades.logging.parsers.importer.ILogParser;
import org.eclipse.hyades.logging.parsers.internal.importer.GLADebug;
import org.eclipse.hyades.logging.parsers.internal.importer.GLAHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParserWrapper
implements ILogParser {
    private Adapter adapter;
    private String key = String.valueOf(System.currentTimeMillis());
    private String originalConfigFile = null;
    protected String newDirectory = null;
    protected String newFileName = null;
    protected String currentPlugin = "org.eclipse.hyades.logging.parsers";
    private Log parserLogger = null;
    private String file_path;
    private static Hashtable activeWrappers = new Hashtable();

    public ParserWrapper() {
        this.adapter = new Adapter();
    }

    public static Log getLogInstance(String logKey) {
        return (Log)activeWrappers.remove(logKey);
    }

    public void parse(Log argLogger) throws LogParserException {
        block8: {
            try {
                IStatus[] contexts;
                activeWrappers.put(this.key, argLogger);
                Log glaLogger = this.getParserLogger();
                if (glaLogger != null) {
                    AdapterLogOutputter logOutputter = new AdapterLogOutputter();
                    logOutputter.setOutLogger(glaLogger);
                    this.adapter.setLogOutputter((IOutputter)logOutputter);
                }
                this.adapter.start(false, false);
                IStatus status = this.adapter.getStatus();
                if (status == null || (contexts = status.getChildrenStatus()) == null || contexts.length <= 0) break block8;
                int i = 0;
                while (i < contexts.length) {
                    if (contexts[i] != null && contexts[i].getName().equals("AdapterContext")) {
                        if (contexts[i].getItemsProcessedCount() > 0) {
                            throw new LogParserException(ParserUtilities.getResourceString((String)"LOG_PARSER_PARSING_ERROR_", (String)this.file_path));
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (AdapterException e) {
                String errMessage = e.getLocalizedMessage();
                if (GLADebug.INSTANCE.debug) {
                    GLADebug.INSTANCE.log("ParserWrapper.parse: GLA threw an exception with message: " + errMessage);
                }
                if (errMessage.indexOf("IWAT0375E") != -1 || errMessage.indexOf("IWAT0376E") != -1) {
                    throw new LogParserException(ParserUtilities.getResourceString((String)"LOG_PARSER_INVALID_FILE_NAME_ERROR_", (String)this.file_path));
                }
                throw new LogParserException((Throwable)e);
            }
        }
    }

    public void setUserInput(Hashtable table) throws LogParserException {
        table.put("loggerKey", this.key);
        String newConfigFile = null;
        try {
            newConfigFile = this.getNewConfigFile(table);
            if (GLADebug.INSTANCE.debug) {
                GLADebug.INSTANCE.log("ParserWrapper.setUserInput: new adapter file is " + newConfigFile);
            }
        }
        catch (LogParserException e) {
            throw e;
        }
        catch (Throwable e) {
            String excMessage = e.getMessage();
            if (excMessage == null || excMessage.length() == 0) {
                excMessage = e.toString();
            }
            throw new LogParserException(ParserUtilities.getResourceString((String)"LOG_PARSER_INVALID_FILE_NAME_ERROR_", (String)excMessage));
        }
        this.adapter.setContextConfigPath(newConfigFile);
        this.adapter.setComponentConfigPath(newConfigFile);
    }

    private String getNewConfigFile(Hashtable table) throws LogParserException {
        int i;
        Document doc = null;
        String pluginName = (String)table.get("parserPluginName");
        if (pluginName == null) {
            pluginName = this.currentPlugin;
        }
        if (GLADebug.INSTANCE.debug) {
            GLADebug.INSTANCE.log("ParserWrapper.getNewConfigFile: plugin name is " + pluginName);
        }
        String config_file = GLAHelper.getAbsoluteAdapterPath(table, pluginName, false);
        if (GLADebug.INSTANCE.debug) {
            GLADebug.INSTANCE.log("ParserWrapper.getNewConfigFile: adapter file found is " + config_file);
        }
        File adapterFile = new File(config_file);
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(adapterFile);
        }
        catch (Exception exception) {}
        String configFileDirectory = null;
        if ((String)table.get("originalAdapter") != null) {
            this.originalConfigFile = GLAHelper.getAbsoluteAdapterPath(table, (String)table.get("parserPluginName"), true);
            File originalAdapterFile = new File(this.originalConfigFile);
            configFileDirectory = originalAdapterFile.getParent();
        } else {
            this.originalConfigFile = config_file;
            configFileDirectory = adapterFile.getParent();
        }
        if (GLADebug.INSTANCE.debug) {
            GLADebug.INSTANCE.log("ParserWrapper.getNewConfigFile: original adapter file location is " + configFileDirectory);
        }
        this.file_path = (String)table.get("file_path");
        File logFile = null;
        String logFileName = null;
        String logFileDir = null;
        if (this.file_path != null && this.file_path.trim().length() > 0) {
            int quoteIndex;
            if (this.file_path.endsWith("\"") && (quoteIndex = this.file_path.substring(0, this.file_path.length() - 1).lastIndexOf(34)) > 0) {
                logFileName = this.file_path.substring(quoteIndex + 1, this.file_path.length() - 1);
                logFileDir = this.file_path.substring(0, quoteIndex);
                this.file_path = String.valueOf(logFileDir) + logFileName;
            }
            logFile = new File(this.file_path.trim());
            if (logFileName == null) {
                logFileName = logFile.getName();
            }
            if (logFileDir == null) {
                logFileDir = logFile.getParent();
            }
        }
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inStream);
        }
        catch (SAXException e) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", (String)adapterFile.getAbsolutePath()), (Throwable)e);
        }
        catch (IOException e) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", (String)adapterFile.getAbsolutePath()), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", (String)adapterFile.getAbsolutePath()), (Throwable)e);
        }
        catch (Exception e) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", (String)adapterFile.getAbsolutePath()), (Throwable)e);
        }
        if (GLADebug.INSTANCE.debug) {
            GLADebug.INSTANCE.log("ParserWrapper.getNewConfigFile: setting context instance attributes.");
        }
        String isoLanguage = (String)table.get("isoLanguageCode");
        String isoCountry = (String)table.get("isoCountryCode");
        String charset = (String)table.get("charset");
        String year = (String)table.get("year");
        String month = (String)table.get("month");
        String day = (String)table.get("day");
        String timezone = (String)table.get("timezone");
        if (isoLanguage != null && isoLanguage.length() > 0 || isoCountry != null && isoCountry.length() > 0 || charset != null && charset.length() > 0 || year != null && year.length() > 0 || month != null && month.length() > 0 || day != null && day.length() > 0 || timezone != null && timezone.length() > 0) {
            NodeList contextInstanceList = doc.getElementsByTagName("cc:ContextInstance");
            int cICount = contextInstanceList.getLength();
            i = 0;
            while (i < cICount) {
                Element cIElement = (Element)contextInstanceList.item(i);
                if (cIElement != null) {
                    Attr ciAttribute = cIElement.getAttributeNode("isoLanguageCode");
                    if (isoLanguage != null && isoLanguage.length() > 0) {
                        if (ciAttribute != null) {
                            ciAttribute.setNodeValue(isoLanguage);
                        } else {
                            cIElement.setAttribute("isoLanguageCode", isoLanguage);
                        }
                    }
                    ciAttribute = cIElement.getAttributeNode("isoCountryCode");
                    if (isoCountry != null && isoCountry.length() > 0) {
                        if (ciAttribute != null) {
                            ciAttribute.setNodeValue(isoCountry);
                        } else {
                            cIElement.setAttribute("isoCountryCode", isoCountry);
                        }
                    }
                    ciAttribute = cIElement.getAttributeNode("charset");
                    if (charset != null && charset.length() > 0) {
                        if (ciAttribute != null) {
                            ciAttribute.setNodeValue(charset);
                        } else {
                            cIElement.setAttribute("charset", charset);
                        }
                    }
                    ciAttribute = cIElement.getAttributeNode("year");
                    if (year != null && year.length() > 0) {
                        if (ciAttribute != null) {
                            ciAttribute.setNodeValue(year);
                        } else {
                            cIElement.setAttribute("year", year);
                        }
                    }
                    ciAttribute = cIElement.getAttributeNode("month");
                    if (month != null && month.length() > 0) {
                        if (ciAttribute != null) {
                            ciAttribute.setNodeValue(month);
                        } else {
                            cIElement.setAttribute("month", month);
                        }
                    }
                    ciAttribute = cIElement.getAttributeNode("day");
                    if (day != null && day.length() > 0) {
                        if (ciAttribute != null) {
                            ciAttribute.setNodeValue(day);
                        } else {
                            cIElement.setAttribute("day", day);
                        }
                    }
                    ciAttribute = cIElement.getAttributeNode("timezone");
                    if (timezone != null && timezone.length() > 0) {
                        if (ciAttribute != null) {
                            ciAttribute.setNodeValue(timezone);
                        } else {
                            cIElement.setAttribute("timezone", timezone);
                        }
                    }
                }
                ++i;
            }
        }
        if (GLADebug.INSTANCE.debug) {
            GLADebug.INSTANCE.log("ParserWrapper.getNewConfigFile: setting sensor properties.");
        }
        NodeList sensorList = doc.getElementsByTagName("cc:Sensor");
        int sensorCount = sensorList.getLength();
        i = 0;
        while (i < sensorCount) {
            block86: {
                String propValue;
                Element sensorElement = (Element)sensorList.item(i);
                if (sensorElement == null) break block86;
                Element sensorTypeInstance = null;
                String newConverterCmd = null;
                Element directoryPropertyElement = null;
                Element fileNamePropertyElement = null;
                NodeList sensorNodes = sensorElement.getChildNodes();
                int k = 0;
                while (k < sensorNodes.getLength()) {
                    block87: {
                        String propName;
                        Element sensorPropertyElement;
                        Element sensorNode;
                        block88: {
                            block91: {
                                block90: {
                                    block89: {
                                        if (sensorNodes.item(k).getNodeType() != 1) break block87;
                                        sensorNode = (Element)sensorNodes.item(k);
                                        if (!sensorNode.getTagName().equals("pu:Property")) break block88;
                                        sensorPropertyElement = sensorNode;
                                        propName = sensorPropertyElement.getAttribute("propertyName");
                                        propValue = sensorPropertyElement.getAttribute("propertyValue");
                                        if (!propName.equals("directory")) break block89;
                                        directoryPropertyElement = sensorPropertyElement;
                                        if (logFileDir != null) {
                                            sensorPropertyElement.setAttribute("propertyValue", logFileDir);
                                        }
                                        break block87;
                                    }
                                    if (!propName.equals("fileName")) break block90;
                                    fileNamePropertyElement = sensorPropertyElement;
                                    if (logFileName != null) {
                                        sensorPropertyElement.setAttribute("propertyValue", logFileName);
                                    }
                                    break block87;
                                }
                                if (!propName.equals("converter")) break block91;
                                if (propValue != null && propValue.length() > 0) {
                                    if (newConverterCmd == null && (newConverterCmd = this.modifyConverter(propValue, configFileDirectory, table, logFile)) == null) {
                                        newConverterCmd = "";
                                    }
                                    sensorPropertyElement.setAttribute("propertyValue", newConverterCmd);
                                }
                                break block87;
                            }
                            propValue = (String)table.get(propName);
                            if (propValue == null) break block87;
                            sensorPropertyElement.setAttribute("propertyValue", propValue.trim());
                            break block87;
                        }
                        if (sensorNode.getTagName().equals("sensor:StaticParserSensor") || sensorNode.getTagName().equals("sensor:SingleFileSensor")) {
                            sensorTypeInstance = sensorNode;
                            NodeList sensorPropertyList = sensorTypeInstance.getElementsByTagName("sensor:SensorProperty");
                            int sensorPropertyCount = sensorPropertyList.getLength();
                            int j = 0;
                            while (j < sensorPropertyCount) {
                                sensorPropertyElement = (Element)sensorPropertyList.item(j);
                                propName = sensorPropertyElement.getAttribute("propertyName");
                                propValue = (String)table.get(propName);
                                if (propValue != null) {
                                    sensorPropertyElement.setAttribute("propertyValue", propValue.trim());
                                }
                                ++j;
                            }
                            NamedNodeMap sensorTypeAttributeList = sensorTypeInstance.getAttributes();
                            int sensorTypeAttributeCount = sensorTypeAttributeList.getLength();
                            int j2 = 0;
                            while (j2 < sensorTypeAttributeCount) {
                                Node sensorTypeAttribute = sensorTypeAttributeList.item(j2);
                                String attrName = sensorTypeAttribute.getNodeName();
                                if (attrName.equals("directory")) {
                                    if (logFileDir != null) {
                                        sensorTypeAttribute.setNodeValue(logFileDir);
                                    }
                                } else if (attrName.equals("fileName")) {
                                    if (logFileName != null) {
                                        sensorTypeAttribute.setNodeValue(logFileName);
                                    }
                                } else if (attrName.equals("converter")) {
                                    if (newConverterCmd == null && (newConverterCmd = this.modifyConverter(sensorTypeAttribute.getNodeValue(), configFileDirectory, table, logFile)) == null) {
                                        newConverterCmd = "";
                                    }
                                    sensorTypeAttribute.setNodeValue(newConverterCmd);
                                } else {
                                    propValue = (String)table.get(attrName);
                                    if (propValue != null) {
                                        sensorTypeAttribute.setNodeValue(propValue.trim());
                                    }
                                }
                                ++j2;
                            }
                        }
                    }
                    ++k;
                }
                NamedNodeMap sensorAttributeList = sensorElement.getAttributes();
                int sensorTypeAttributeCount = sensorAttributeList.getLength();
                int k2 = 0;
                while (k2 < sensorTypeAttributeCount) {
                    Node sensorTypeAttribute = sensorAttributeList.item(k2);
                    String attrName = sensorTypeAttribute.getNodeName();
                    propValue = (String)table.get(attrName);
                    if (propValue != null && propValue.length() > 0) {
                        sensorTypeAttribute.setNodeValue(propValue.trim());
                    }
                    ++k2;
                }
                if (this.newDirectory != null) {
                    if (directoryPropertyElement != null) {
                        directoryPropertyElement.setAttribute("propertyValue", this.newDirectory);
                    }
                    if (sensorTypeInstance != null) {
                        Attr sensorAttribute = sensorTypeInstance.getAttributeNode("directory");
                        sensorAttribute.setNodeValue(this.newDirectory);
                    }
                }
                if (this.newFileName != null) {
                    if (fileNamePropertyElement != null) {
                        fileNamePropertyElement.setAttribute("propertyValue", this.newFileName);
                    }
                    if (sensorTypeInstance != null) {
                        Attr sensorAttribute = sensorTypeInstance.getAttributeNode("fileName");
                        sensorAttribute.setNodeValue(this.newFileName);
                    }
                }
            }
            ++i;
        }
        NodeList outputterList = doc.getElementsByTagName("cc:Outputter");
        int outputterCount = outputterList.getLength();
        if (outputterCount != 0) {
            int i2 = 0;
            while (i2 < outputterCount) {
                Element outputterElement = (Element)outputterList.item(i2);
                Element outputterProperty = doc.createElement("pu:Property");
                outputterProperty.setAttribute("propertyValue", this.key);
                outputterProperty.setAttribute("propertyName", "loggerKey");
                outputterElement.insertBefore(outputterProperty, outputterElement.getFirstChild());
                ++i2;
            }
        } else {
            NodeList formatterList = doc.getElementsByTagName("fmt:Formatter");
            int formatterCount = formatterList.getLength();
            int i3 = 0;
            while (i3 < formatterCount) {
                Element formatterElement = (Element)formatterList.item(i3);
                Element formatterProperty = doc.createElement("pu:Property");
                formatterProperty.setAttribute("propertyValue", this.key);
                formatterProperty.setAttribute("propertyName", "loggerKey");
                formatterElement.insertBefore(formatterProperty, formatterElement.getFirstChild());
                ++i3;
            }
        }
        if (GLADebug.INSTANCE.debug) {
            GLADebug.INSTANCE.log("ParserWrapper.getNewConfigFile: saving updated configuration to a new file.");
        }
        File newFile = null;
        try {
            Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
            Method getPluginStateLocationMethod = platformClass.getMethod("getPluginStateLocation", Class.forName("org.eclipse.core.runtime.Plugin"));
            Object iPathObject = getPluginStateLocationMethod.invoke(null, LoggingParsersPlugin.getPlugin());
            Class<?> iPathClass = iPathObject.getClass();
            Method toOSStringMethod = iPathClass.getMethod("toOSString", null);
            File dirpath = new File((String)toOSStringMethod.invoke(iPathObject, null));
            newFile = File.createTempFile("GLA", ".adapter", dirpath);
        }
        catch (Exception exception) {
            try {
                newFile = File.createTempFile("GLA", ".adapter");
            }
            catch (Throwable throwable) {
                try {
                    File oldFile = new File(config_file);
                    String tmpFileName = new String("GLA" + System.currentTimeMillis() + ".adapter");
                    newFile = new File(oldFile.getParent(), tmpFileName);
                }
                catch (Throwable e3) {
                    throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Save_ERROR_", (String)"GLA.adapter", (String)e3.toString()), e3);
                }
            }
        }
        catch (Throwable e) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Save_ERROR_", (String)"GLA.adapter", (String)e.toString()), e);
        }
        newFile.deleteOnExit();
        try {
            XmlUtility.serialize((Document)doc, (File)newFile);
        }
        catch (SerializationException s) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Save_ERROR_", (String)newFile.getAbsolutePath(), (String)s.getMessage()), (Throwable)s);
        }
        return newFile.getAbsolutePath();
    }

    protected String modifyConverter(String converter, String configFileDirectory, Hashtable table, File logfile) {
        String tempWindowsFile = "windows.txt";
        String newConverter = converter;
        int winIndex = configFileDirectory.lastIndexOf("Windows\\");
        int evtTypeIndex = winIndex + 8;
        if (!(winIndex == -1 || configFileDirectory.substring(evtTypeIndex).indexOf("application") != 0 && configFileDirectory.substring(evtTypeIndex).indexOf("security") != 0 && configFileDirectory.substring(evtTypeIndex).indexOf("system") != 0 || converter.indexOf("eventlogreader.exe") == -1 && converter.indexOf("EventLogReader2.exe") == -1)) {
            File tempFile;
            try {
                tempFile = File.createTempFile("WindowsLogParser", ".tmp");
            }
            catch (Exception exception) {
                tempFile = new File(String.valueOf(configFileDirectory) + ParserConstants.FILE_SEPARATOR + tempWindowsFile);
            }
            try {
                tempFile.deleteOnExit();
            }
            catch (Exception exception) {}
            String windowsEventLog = "application";
            if (configFileDirectory.substring(evtTypeIndex).indexOf("security") == 0 && converter.indexOf("security") != -1) {
                windowsEventLog = "security";
            } else if (configFileDirectory.substring(evtTypeIndex).indexOf("system") == 0 && converter.indexOf("system") != -1) {
                windowsEventLog = "system";
            }
            int nlIndex = configFileDirectory.indexOf("nl");
            String baseFileDirectory = nlIndex != -1 ? configFileDirectory.substring(0, nlIndex - 1) : configFileDirectory;
            newConverter = converter.indexOf("EventLogReader2.exe") != -1 ? "cmd.exe ".concat("/c \"").concat(baseFileDirectory).concat(ParserConstants.FILE_SEPARATOR).concat("eventlogreader2.exe\" \"").concat(windowsEventLog).concat("\" \"").concat(tempFile.getAbsolutePath()).concat("\"") : "\"".concat(baseFileDirectory).concat(ParserConstants.FILE_SEPARATOR).concat("eventlogreader.exe\" \"").concat(windowsEventLog).concat("\" \"").concat(tempFile.getAbsolutePath()).concat("\"");
            this.newFileName = tempFile.getName();
            this.newDirectory = tempFile.getParent();
        }
        return newConverter;
    }

    public Log getParserLogger() {
        return this.parserLogger;
    }

    public void setParserLogger(Log parserLogger) {
        this.parserLogger = parserLogger;
    }

    public void stop() {
        this.adapter.stop();
    }

    public String getStatus() {
        IStatus[] contexts;
        String totalSize = "0";
        String totalProcessed = "0";
        IStatus status = this.adapter.getStatus();
        if (status != null && (contexts = status.getChildrenStatus()) != null && contexts.length > 1) {
            int i = 1;
            while (i < contexts.length) {
                IStatus cstatus;
                IStatus[] components;
                if (contexts[i] != null && (components = (cstatus = contexts[i]).getChildrenStatus()) != null && components.length > 0) {
                    int j = 0;
                    while (j < components.length) {
                        IStatus cpstatus = components[j];
                        if (cpstatus instanceof SensorStatus) {
                            if (cpstatus.isActive()) {
                                totalSize = Long.toString(((SensorStatus)cpstatus).getTotalSize());
                                totalProcessed = Long.toString(((SensorStatus)cpstatus).getProcessedSize());
                                break;
                            }
                            totalProcessed = totalSize = Long.toString(((SensorStatus)cpstatus).getTotalSize());
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return new String("total=" + totalSize + " processed=" + totalProcessed);
    }
}

