/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.internal.importer;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.internal.importer.GLADebug;

public class GLAHelper {
    protected static short platform = (short)-1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized String getAdapterPath(Map table, String nameSpace, boolean useOriginalAdapter) throws LogParserException {
        File test;
        String key;
        if (useOriginalAdapter) {
            key = "originalAdapter";
        } else {
            key = GLAHelper.getAdapterPathKey(table);
            if (key == null) {
                String message = Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_", null);
                throw new LogParserException(message);
            }
            if (GLADebug.INSTANCE.debug) {
                GLADebug.INSTANCE.log("GLAHelper.getAdapterPath: adapter key=" + key);
            }
        }
        String config_file = (String)table.get(key);
        String adapterFilePath = "";
        if (config_file.indexOf("./") > -1) {
            config_file = config_file.substring(2);
        }
        if (GLAHelper.isWorkbenchMode()) {
            try {
                Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Method getBundle = platformClass.getMethod("getBundle", classArray);
                Object bundle = getBundle.invoke(null, (Object[])new String[]{nameSpace});
                Class<?> pathClass = Class.forName("org.eclipse.core.runtime.IPath");
                Class<?> bundleClass = Class.forName("org.osgi.framework.Bundle");
                Method find = platformClass.getMethod("find", bundleClass, pathClass);
                if (bundle == null) return config_file;
                if (config_file.indexOf("/nl/") > -1) {
                    if ((config_file = GLAHelper.getNLAdapterPath(table, config_file, find, bundle)) != null) return config_file;
                    String message = Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_", (String)((String)table.get(key)));
                    throw new Exception(message);
                }
                URL fileURL = GLAHelper.find(find, bundle, config_file);
                if (fileURL == null) {
                    fileURL = GLAHelper.find(find, bundle, "config/" + config_file);
                }
                if (fileURL != null) {
                    return fileURL.toString();
                }
                adapterFilePath = String.valueOf((String)table.get("ConfigFileRoot")) + "/" + config_file;
                File test2 = new File(adapterFilePath);
                if (test2.exists()) return adapterFilePath;
                throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_", (String)config_file));
            }
            catch (Throwable e) {
                throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_", (String)config_file), e);
            }
        }
        if (config_file.indexOf("/nl/") > -1) {
            if (GLADebug.INSTANCE.debug) {
                GLADebug.INSTANCE.log("GLAHelper.getAdapterPath: trying to get the nl adapter file using base file " + config_file);
            }
            if ((config_file = GLAHelper.getNLAdapterPath(table, config_file, null, null)) != null) return config_file;
            String message = Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_", (String)((String)table.get(key)));
            throw new LogParserException(message);
        }
        String adapterPath = (String)table.get("ConfigFileRoot");
        adapterFilePath = String.valueOf(adapterPath) + "/" + config_file;
        if (GLADebug.INSTANCE.debug) {
            GLADebug.INSTANCE.log("GLAHelper.getAdapterPath: try to find the adapter file using ConfigFileRoot path eg. " + adapterFilePath);
        }
        if ((test = new File(adapterFilePath)).exists()) return adapterFilePath;
        adapterFilePath = String.valueOf(adapterPath) + "config/" + config_file;
        if (GLADebug.INSTANCE.debug) {
            GLADebug.INSTANCE.log("GLAHelper.getAdapterPath: try to find the adapter file using ConfigFileRoot path plus config eg. " + adapterFilePath);
        }
        if ((test = new File(adapterFilePath)).exists()) return adapterFilePath;
        String config_paths = (String)table.get("config_path");
        if (config_paths != null && config_paths.length() != 0) {
            StringTokenizer strtok = new StringTokenizer(config_paths, File.pathSeparator, false);
            while (strtok.hasMoreTokens()) {
                File f;
                String config_path = strtok.nextToken();
                if (GLADebug.INSTANCE.debug) {
                    GLADebug.INSTANCE.log("GLAHelper.getAdapterPath: try to find the adapter file " + config_file + " using config_path " + config_path);
                }
                if (!(f = new File(config_path, config_file)).exists()) continue;
                return f.getAbsolutePath();
            }
        }
        if (!GLADebug.INSTANCE.debug) throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_", (String)config_file));
        GLADebug.INSTANCE.log("GLAHelper.getAdapterPath: could not find the adapter file!  Throwing an exception.");
        throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_", (String)config_file));
    }

    protected static synchronized void initialize() {
        try {
            Class<?> resourcePlugin = Class.forName("org.eclipse.core.resources.ResourcesPlugin");
            Method getWorkspace = resourcePlugin.getMethod("getWorkspace", null);
            Object workspace = getWorkspace.invoke(null, null);
            Method getRoot = workspace.getClass().getMethod("getRoot", null);
            Object root = getRoot.invoke(workspace, null);
            platform = (short)(root != null ? 1 : 0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            platform = 0;
        }
        catch (SecurityException securityException) {
            platform = 0;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            platform = 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            platform = 0;
        }
        catch (IllegalAccessException illegalAccessException) {
            platform = 0;
        }
        catch (InvocationTargetException invocationTargetException) {
            platform = 0;
        }
        catch (NullPointerException nullPointerException) {
            platform = 0;
        }
    }

    public static synchronized String getAbsoluteAdapterPath(Map table, String nameSpace, boolean useOriginalAdapter) throws LogParserException {
        String adapterPath = GLAHelper.getAdapterPath(table, nameSpace, useOriginalAdapter);
        if (GLAHelper.isWorkbenchMode()) {
            try {
                Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
                Class[] classArray = new Class[1];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.net.URL");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Method asLocalURL = platformClass.getMethod("asLocalURL", classArray);
                URL adapterURL = new URL(adapterPath);
                URL absoluteURL = (URL)asLocalURL.invoke(null, adapterURL);
                return absoluteURL.getFile();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (Throwable e) {
                throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_", (String)adapterPath), e);
            }
        }
        return adapterPath;
    }

    public static synchronized String getAdapterPathKey(Map table) {
        String key = null;
        String version = (String)table.get("version");
        String config_file = null;
        if (version == null) {
            version = "Default";
        }
        if ((config_file = (String)table.get(version)) == null && version != "Default") {
            config_file = (String)table.get("Default");
            if (config_file != null) {
                key = "Default";
            }
        } else if (config_file != null) {
            key = version;
        }
        return key;
    }

    public static synchronized boolean isWorkbenchMode() {
        if (platform == -1) {
            GLAHelper.initialize();
        }
        if (GLADebug.INSTANCE.debug) {
            GLADebug.INSTANCE.log("workbench=" + platform);
        }
        return platform == 1;
    }

    protected static synchronized String getNLAdapterPath(Map table, String configFilePath, Method find, Object bundle) {
        String characterEncoding = (String)table.get("charset");
        String countryCode = (String)table.get("isoCountryCode");
        String languageCode = (String)table.get("isoLanguageCode");
        String locale = null;
        if (languageCode != null && languageCode.equals("default")) {
            languageCode = Locale.getDefault().getLanguage();
        }
        if (countryCode != null && countryCode.equals("default")) {
            countryCode = Locale.getDefault().getCountry();
        }
        if (characterEncoding != null && characterEncoding.equals("default")) {
            try {
                characterEncoding = System.getProperty("file.encoding");
            }
            catch (SecurityException securityException) {}
        }
        if (countryCode != null && countryCode.length() == 0) {
            locale = languageCode;
        } else if (countryCode != null && languageCode != null) {
            locale = String.valueOf(languageCode) + "_" + countryCode;
        }
        int i = configFilePath.indexOf("/nl/");
        if (GLADebug.INSTANCE.debug) {
            GLADebug.INSTANCE.log("characterEncoding=" + characterEncoding);
            GLADebug.INSTANCE.log("countryCode=" + countryCode);
            GLADebug.INSTANCE.log("languageCode=" + languageCode);
        }
        String[][] searchPath = new String[][]{{locale, characterEncoding}, {locale}, {characterEncoding}, {"/"}};
        if (i < 0) {
            return configFilePath;
        }
        int j = configFilePath.lastIndexOf(47);
        String dir = configFilePath.substring(0, i + 3);
        String fileName = configFilePath.substring(j);
        StringBuffer path = new StringBuffer();
        String[] currentPath = null;
        int l = 0;
        String fullPath = null;
        String lastPathAppended = null;
        int idx = 0;
        while (idx < 4 && fullPath == null) {
            currentPath = searchPath[idx];
            l = currentPath.length;
            path.append(dir);
            int jdx = 0;
            while (jdx < l) {
                if (currentPath[jdx] != null) {
                    if (!currentPath[jdx].equals("/")) {
                        path.append('/');
                    }
                    path.append(currentPath[jdx]);
                    lastPathAppended = currentPath[jdx];
                }
                ++jdx;
            }
            if (lastPathAppended != null && lastPathAppended.equals("/")) {
                path.append(fileName.substring(1));
            } else {
                path.append(fileName);
            }
            fullPath = GLAHelper.getPath(table, find, bundle, path.toString());
            path.setLength(0);
            ++idx;
        }
        return fullPath;
    }

    protected static synchronized String getPath(Map table, Method find, Object bundle, String configFilePath) {
        String filePath = null;
        if (bundle != null) {
            URL fileURL = GLAHelper.find(find, bundle, configFilePath);
            if (fileURL == null) {
                fileURL = GLAHelper.find(find, bundle, "config/" + configFilePath);
            }
            if (fileURL != null) {
                filePath = fileURL.toString();
            }
        } else {
            String adapterPath = (String)table.get("ConfigFileRoot");
            String adapterFilePath = String.valueOf(adapterPath) + "/" + configFilePath;
            File file = new File(adapterFilePath);
            if (file.exists()) {
                filePath = adapterFilePath;
            } else {
                String config_paths = (String)table.get("config_path");
                if (config_paths != null && config_paths.length() != 0) {
                    StringTokenizer strtok = new StringTokenizer(config_paths, File.pathSeparator, false);
                    while (strtok.hasMoreTokens()) {
                        String config_path = strtok.nextToken();
                        File f = new File(config_path, configFilePath);
                        if (!f.exists()) continue;
                        filePath = f.getAbsolutePath();
                    }
                }
            }
        }
        if (GLADebug.INSTANCE.debug) {
            GLADebug.INSTANCE.log("GLAHelper.getPath: Attempted to get adapter at path " + configFilePath + " result: file=" + filePath);
        }
        return filePath;
    }

    protected static URL find(Method find, Object bundle, String config_file) {
        URL fileURL;
        block2: {
            fileURL = null;
            try {
                Class<?> pathClass = Class.forName("org.eclipse.core.runtime.Path");
                Constructor<?> pathConstructor = pathClass.getConstructor(config_file.getClass());
                Object path = pathConstructor.newInstance(config_file);
                fileURL = (URL)find.invoke(null, bundle, path);
            }
            catch (Exception e) {
                if (!GLADebug.INSTANCE.debug) break block2;
                e.printStackTrace();
            }
        }
        return fileURL;
    }
}

