/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.provisional.common;

import java.util.Map;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.INotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.exceptions.InitializationException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.output.artifacts.IAccepted;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.output.artifacts.IDeclined;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.output.artifacts.IInstanceResponse;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.output.artifacts.RegisterResponseArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IInstanceId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNotificationHandler
implements INotificationHandler {
    private Map<?, ?> init;
    public String mdrId;
    public String localId;

    public void initialize(Map<?, ?> init) throws InitializationException {
        this.init = init;
    }

    public boolean isInitialized() {
        return this.init != null;
    }

    public Object getValue(Object key) {
        return this.init.get(key);
    }

    protected IInstanceResponse createDeclinedResponse() {
        return this.createDeclinedResponse(new String[0]);
    }

    protected IInstanceResponse createDeclinedResponse(String reason) {
        return this.createDeclinedResponse(new String[]{reason});
    }

    protected IInstanceResponse createDeclinedResponse(String[] reasons) {
        IInstanceResponse response = this.createResponse();
        IDeclined declined = RegisterResponseArtifactFactory.createDeclined();
        if (reasons != null) {
            int i = 0;
            while (i < reasons.length) {
                declined.addReason(reasons[i]);
                ++i;
            }
        }
        response.setDeclined(declined);
        return response;
    }

    protected IInstanceResponse createAcceptResponse() {
        return this.createAcceptResponse(new IInstanceId[0]);
    }

    protected IInstanceResponse createAcceptResponse(IInstanceId alternativeInstanceId) {
        return this.createAcceptResponse(new IInstanceId[]{alternativeInstanceId});
    }

    protected IInstanceResponse createAcceptResponse(IInstanceId[] alternativeInstanceIds) {
        IInstanceResponse response = this.createResponse();
        IAccepted accepted = RegisterResponseArtifactFactory.createAccepted();
        if (alternativeInstanceIds != null) {
            int i = 0;
            while (i < alternativeInstanceIds.length) {
                accepted.addAlternateInstanceId(alternativeInstanceIds[i]);
                ++i;
            }
        }
        response.setAccepted(accepted);
        return response;
    }

    private IInstanceResponse createResponse() {
        IInstanceResponse response = RegisterResponseArtifactFactory.createInstanceResponse();
        IInstanceId instanceId = RegisterResponseArtifactFactory.createInstanceId((String)this.mdrId, (String)this.localId);
        response.setInstanceId(instanceId);
        return response;
    }

    protected String getMdrId() {
        return this.mdrId;
    }

    protected void setMdrId(String mdrId) {
        this.mdrId = mdrId;
    }

    protected String getLocalId() {
        return this.localId;
    }

    protected void setLocalId(String localId) {
        this.localId = localId;
    }

    protected IInstanceId retrieveInstanceId(IGraphElement element) {
        IInstanceId[] instanceIds = element.getInstanceIds();
        return instanceIds.length > 0 ? instanceIds[0] : null;
    }

    protected void setIds(IGraphElement graphElement) {
        IInstanceId[] instanceIds = graphElement.getInstanceIds();
        if (instanceIds != null && instanceIds.length > 0) {
            this.setMdrId(instanceIds[0].getMdrId().toString());
            this.setLocalId(instanceIds[0].getLocalId().toString());
        } else {
            this.setMdrId("");
            this.setLocalId("");
        }
    }
}

