/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.provisional.common;

import org.eclipse.cosmos.dc.cmdbf.services.provisional.cmdbfservice.AbstractServiceHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IItemNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.INotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.INotificationHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.common.IRelationshipNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.exceptions.InitializationException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.exceptions.UnsupportedHandlerException;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.input.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.input.artifacts.IRelationship;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.input.artifacts.IRequest;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.registration.transform.output.artifacts.IResponse;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.transform.artifacts.IGraphElementCollection;

public abstract class AbstractNotificationOperation
extends AbstractServiceHandler {
    private INotificationHandlerFactory factory;

    public AbstractNotificationOperation(INotificationHandlerFactory factory) {
        this.factory = factory;
    }

    protected INotificationHandlerFactory getFactory() {
        return this.factory;
    }

    protected void execute(IRequest request, IResponse response, int type) throws IllegalArgumentException {
        try {
            this.handleGraphElementCollection((IGraphElementCollection)request.getItemList(), response, type, true);
            this.handleGraphElementCollection((IGraphElementCollection)request.getRelationshipList(), response, type, false);
        }
        catch (UnsupportedHandlerException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InitializationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void handleGraphElementCollection(IGraphElementCollection collection, IResponse response, int type, boolean item) throws UnsupportedHandlerException, InitializationException {
        INotificationHandler serviceHandler;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        IItemNotificationHandler itemHandler = null;
        IRelationshipNotificationHandler relationshipHandler = null;
        if (item) {
            itemHandler = this.getFactory().createItemHandler(type);
        } else {
            relationshipHandler = this.getFactory().createRelationshipHandler(type);
        }
        INotificationHandler iNotificationHandler = serviceHandler = itemHandler == null ? relationshipHandler : itemHandler;
        if (!serviceHandler.isInitialized()) {
            serviceHandler.initialize(this.getInit());
        }
        IGraphElement[] elements = collection.getElements();
        int i = 0;
        while (i < elements.length) {
            response.addInstanceResponse(itemHandler == null ? relationshipHandler.handle(type, (IRelationship)elements[i]) : itemHandler.handle(type, (IItem)elements[i]));
            ++i;
        }
    }
}

