/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.ir.Report;

public class DataPresentationEngine
extends AbstractDataEngine {
    private IDocArchiveReader reader;
    protected HashMap rsetRelations = new HashMap();
    private StringBuffer keyBuffer = new StringBuffer();

    public DataPresentationEngine(ExecutionContext context, IDocArchiveReader reader) throws Exception {
        super(context);
        DataSessionContext dteSessionContext = new DataSessionContext(2, null, context.getSharedScope());
        dteSessionContext.setDocumentReader(reader);
        DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
        dteEngineContext.setLocale(context.getLocale());
        String tempDir = this.getTempDir(context);
        if (tempDir != null) {
            dteEngineContext.setTmpdir(tempDir);
        }
        this.dteSession = DataRequestSession.newSession((DataSessionContext)dteSessionContext);
        this.reader = reader;
        this.loadDteMetaInfo();
    }

    public void prepare(Report report, Map appContext) {
        new ReportQueryBuilder(report, this.context).build();
        this.doPrepareQuery(report, appContext);
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.queryIDMap.putAll(report.getQueryIDs());
    }

    private void loadDteMetaInfo() throws IOException {
        ArrayList result = DteMetaInfoIOUtil.loadDteMetaInfo(this.reader);
        if (result != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < result.size()) {
                String[] rsetRelation = (String[])result.get(i);
                String pRsetId = rsetRelation[0];
                String rowId = rsetRelation[1];
                String queryId = rsetRelation[2];
                String rsetId = rsetRelation[3];
                buffer.setLength(0);
                buffer.append(pRsetId);
                buffer.append(".");
                buffer.append(rowId);
                buffer.append(".");
                buffer.append(queryId);
                this.rsetRelations.put(buffer.toString(), rsetId);
                ++i;
            }
        }
    }

    protected String getResultID(String pRsetId, String rowId, String queryId) {
        int charAt;
        this.keyBuffer.setLength(0);
        this.keyBuffer.append(pRsetId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(rowId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(queryId);
        String rsetId = (String)this.rsetRelations.get(this.keyBuffer.toString());
        if (rsetId == null && pRsetId != null && (charAt = pRsetId.indexOf("_")) != -1) {
            String rootId = pRsetId.substring(0, charAt);
            this.keyBuffer.setLength(0);
            this.keyBuffer.append(rootId);
            this.keyBuffer.append(".");
            this.keyBuffer.append(rowId);
            this.keyBuffer.append(".");
            this.keyBuffer.append(queryId);
            rsetId = (String)this.rsetRelations.get(this.keyBuffer.toString());
        }
        return rsetId;
    }

    protected IBaseResultSet doExecuteQuery(IBaseResultSet resultSet, IDataQueryDefinition query, boolean useCache) {
        if (query instanceof IQueryDefinition) {
            return this.doExecuteQuery(resultSet, (IQueryDefinition)query);
        }
        if (query instanceof ICubeQueryDefinition) {
            return this.doExecuteCube(resultSet, (ICubeQueryDefinition)query);
        }
        return null;
    }

    protected IBaseResultSet doExecuteQuery(IBaseResultSet parentResult, IQueryDefinition query) {
        String resultSetID;
        block3: {
            String queryID = (String)this.queryIDMap.get(query);
            try {
                resultSetID = this.loadResultSetID(parentResult, queryID);
                if (resultSetID != null) break block3;
                logger.log(Level.SEVERE, "Can't load the report query");
                return null;
            }
            catch (BirtException be) {
                logger.log(Level.SEVERE, be.getMessage());
                this.context.addException(be);
                return null;
            }
        }
        IQueryResults queryResults = this.dteSession.getQueryResults(resultSetID);
        QueryResultSet resultSet = null;
        resultSet = parentResult == null ? new QueryResultSet(this, this.context, query, queryResults) : new QueryResultSet(this, this.context, parentResult, query, queryResults);
        return resultSet;
    }

    protected IBaseResultSet doExecuteCube(IBaseResultSet parentResult, ICubeQueryDefinition query) {
        String queryID = (String)this.queryIDMap.get(query);
        try {
            String resultSetID = this.loadResultSetID(parentResult, queryID);
            IBaseQueryResults queryResults = null;
            query.setQueryResultsID(resultSetID);
            IBasePreparedQuery pQuery = this.dteSession.prepare((IDataQueryDefinition)query, this.context.getAppContext());
            queryResults = parentResult != null ? this.dteSession.execute(pQuery, parentResult.getQueryResults(), this.context.getSharedScope()) : this.dteSession.execute(pQuery, null, this.context.getSharedScope());
            CubeResultSet resultSet = null;
            resultSet = parentResult == null ? new CubeResultSet(this, this.context, query, (ICubeQueryResults)queryResults) : new CubeResultSet(this, this.context, resultSet, query, (ICubeQueryResults)queryResults);
            return resultSet;
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
            return null;
        }
    }

    private String loadResultSetID(IBaseResultSet parentResult, String queryID) {
        String resultSetID = null;
        IBaseQueryResults queryResults = null;
        if (parentResult != null) {
            queryResults = parentResult.getQueryResults();
        }
        if (queryResults == null) {
            if (this.context.isExecutingMasterPage()) {
                long pageNumber = this.context.getPageNumber();
                resultSetID = this.getResultID(null, String.valueOf(pageNumber), queryID);
                if (resultSetID == null) {
                    resultSetID = this.getResultID(null, "1", queryID);
                }
            } else {
                resultSetID = this.getResultID(null, "-1", queryID);
            }
        } else {
            String pRsetId = queryResults.getID();
            try {
                String rowid = parentResult.getRawID();
                resultSetID = this.getResultID(pRsetId, rowid, queryID);
            }
            catch (BirtException e) {
                this.context.addException(e);
            }
        }
        return resultSetID;
    }
}

