/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;
import org.eclipse.birt.report.engine.adapter.ExpressionUtil;
import org.eclipse.birt.report.engine.adapter.ITotalExprBindings;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IQueryContext;
import org.eclipse.birt.report.engine.extension.IReportItemQuery;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.extension.internal.QueryContext;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class ReportQueryBuilder {
    protected static Logger logger;
    private ExpressionUtil expressionUtil = new ExpressionUtil();
    private QueryBuilderVisitor queryBuilder = new QueryBuilderVisitor();
    protected HashMap queryIDs;
    protected HashMap resultMetaData;
    protected Collection queries;
    protected Report report;
    protected ExecutionContext context;
    protected int maxRows = 0;
    IQueryContext queryContext;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public ReportQueryBuilder() {
    }

    public ReportQueryBuilder(Report report, ExecutionContext context) {
        EngineConfig engineConfig;
        IReportEngine engine;
        this.report = report;
        this.context = context;
        if (this.context != null && (engine = this.context.getEngine()) != null && (engineConfig = engine.getConfig()) != null) {
            this.maxRows = engineConfig.getMaxRowsPerQuery();
        }
        this.queryContext = new QueryContext(context, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        Report report = this.report;
        synchronized (report) {
            if (this.report.getQueries().isEmpty()) {
                this.queries = this.report.getQueries();
                this.queries.clear();
                this.queryIDs = this.report.getQueryIDs();
                this.queryIDs.clear();
                this.resultMetaData = this.report.getResultMetaData();
                this.resultMetaData.clear();
                int i = 0;
                while (i < this.report.getPageSetup().getMasterPageCount()) {
                    MasterPageDesign masterPage = this.report.getPageSetup().getMasterPage(i);
                    if (masterPage != null) {
                        SimpleMasterPageDesign pageDesign = (SimpleMasterPageDesign)masterPage;
                        int j = 0;
                        while (j < pageDesign.getHeaderCount()) {
                            this.build(null, pageDesign.getHeader(j));
                            ++j;
                        }
                        j = 0;
                        while (j < pageDesign.getFooterCount()) {
                            this.build(null, pageDesign.getFooter(j));
                            ++j;
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < this.report.getContentCount()) {
                    this.build(null, this.report.getContent(i));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDataQueryDefinition[] build(IDataQueryDefinition parentQuery, ReportItemDesign design) {
        Report report = this.report;
        synchronized (report) {
            Object result;
            block13: {
                result = design.accept(this.queryBuilder, parentQuery);
                if (result != null) break block13;
                return null;
            }
            IDataQueryDefinition[] queries = (IDataQueryDefinition[])result;
            design.setQueries(queries);
            int i = 0;
            while (i < queries.length) {
                IDataQueryDefinition query = queries[i];
                if (query != null) {
                    String queryId = String.valueOf(design.getID());
                    if (i > 0) {
                        queryId = String.valueOf(queryId) + "_" + String.valueOf(i);
                    }
                    this.queryIDs.put(query, queryId);
                    if (query instanceof IBaseQueryDefinition) {
                        ResultMetaData metaData = new ResultMetaData((IBaseQueryDefinition)query);
                        this.resultMetaData.put(query, metaData);
                    }
                    this.registerQueryAndElement(query, design);
                    if (!(query instanceof ISubqueryDefinition)) {
                        this.queries.add(query);
                    } else if (query instanceof ISubqueryDefinition) {
                        IBaseQueryDefinition pQuery;
                        Collection subQueries;
                        if (!(parentQuery instanceof IBaseQueryDefinition)) {
                            this.context.addException(new EngineException("subquery can only be created in another subquery/query" + design.getID()));
                        }
                        if (!(subQueries = (pQuery = (IBaseQueryDefinition)parentQuery).getSubqueries()).contains(query)) {
                            subQueries.add(query);
                        }
                    }
                }
                this.registerQueryToHandle(design, queries);
                ++i;
            }
            return queries;
        }
    }

    private void registerQueryAndElement(IDataQueryDefinition query, ReportItemDesign reportItem) {
        if (!($assertionsDisabled || query != null && reportItem != null)) {
            throw new AssertionError();
        }
        HashMap map = this.report.getReportItemToQueryMap();
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        map.put(query, reportItem);
    }

    private void registerQueryToHandle(ReportItemDesign reportItem, IDataQueryDefinition[] queries) {
        DesignElementHandle handle = reportItem.getHandle();
        if (!$assertionsDisabled && !(handle instanceof ReportElementHandle)) {
            throw new AssertionError();
        }
        this.report.setQueryToReportHandle((ReportElementHandle)handle, queries);
    }

    protected class QueryBuilderVisitor
    extends DefaultReportItemVisitorImpl {
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        protected QueryBuilderVisitor() {
        }

        public Object visitTemplate(TemplateDesign template, Object value) {
            return null;
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            BaseQueryDefinition query = this.createQuery(container, value);
            int i = 0;
            while (i < container.getItemCount()) {
                ReportQueryBuilder.this.build((IDataQueryDefinition)query, container.getItem(i));
                ++i;
            }
            this.transformExpressions(container, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            BaseQueryDefinition query = this.createQuery(grid, value);
            int i = 0;
            while (i < grid.getRowCount()) {
                ReportQueryBuilder.this.build((IDataQueryDefinition)query, grid.getRow(i));
                ++i;
            }
            this.transformExpressions(grid, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        public Object visitImageItem(ImageItemDesign image, Object value) {
            BaseQueryDefinition query = this.createQuery(image, value);
            if (image.getImageSource() == 2) {
                String newImageExpression = this.transformExpression(image.getImageExpression(), (IBaseQueryDefinition)query, null);
                String newImageFormat = this.transformExpression(image.getImageFormat(), (IBaseQueryDefinition)query, null);
                image.setImageExpression(newImageExpression, newImageFormat);
            } else if (image.getImageSource() == 0) {
                String newImageUri = this.transformExpression(image.getImageUri(), (IBaseQueryDefinition)query, null);
                image.setImageUri(newImageUri);
            } else if (image.getImageSource() == 3) {
                String newImageUri = this.transformExpression(image.getImageUri(), (IBaseQueryDefinition)query, null);
                image.setImageFile(newImageUri);
            }
            this.transformExpressions(image, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        public Object visitLabelItem(LabelItemDesign label, Object value) {
            BaseQueryDefinition query = this.createQuery(label, value);
            this.transformExpressions(label, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        public Object visitExtendedItem(ExtendedItemDesign item, Object value) {
            ExtendedItemHandle handle = (ExtendedItemHandle)item.getHandle();
            ReportItemHandle referenceHandle = handle.getDataBindingReference();
            if (referenceHandle != null) {
                IDataQueryDefinition[] queries = ReportQueryBuilder.this.report.getQueryByReportHandle((ReportElementHandle)referenceHandle);
                if (queries != null && queries.length > 0) {
                    ReportQueryBuilder.this.registerQueryToHandle(item, queries);
                    int i = 0;
                    while (i < queries.length) {
                        IDataQueryDefinition referenceQuery = queries[i];
                        if (referenceQuery instanceof BaseQueryDefinition) {
                            ((BaseQueryDefinition)referenceQuery).setCacheQueryResults(true);
                        } else if (referenceQuery instanceof ICubeQueryDefinition) {
                            ((ICubeQueryDefinition)referenceQuery).setCacheQueryResults(true);
                        }
                        ++i;
                    }
                    IDataQueryDefinition query = queries[0];
                    if (query instanceof IBaseQueryDefinition) {
                        this.transformExpressions(item, (IBaseQueryDefinition)query);
                    }
                    return null;
                }
                throw new IllegalStateException("forward reference dataset");
            }
            String tagName = handle.getExtensionName();
            IReportItemQuery itemQuery = ExtensionManager.getInstance().createQueryItem(tagName);
            IDataQueryDefinition[] queries = null;
            IDataQueryDefinition parentQuery = (IDataQueryDefinition)value;
            if (itemQuery != null) {
                try {
                    itemQuery.setModelObject(handle);
                    itemQuery.setQueryContext(ReportQueryBuilder.this.queryContext);
                    queries = itemQuery.createReportQueries(parentQuery);
                }
                catch (BirtException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                    ReportQueryBuilder.this.context.addException(ex);
                }
                if (queries != null) {
                    IDataQueryDefinition query;
                    if (queries.length > 0 && (query = queries[0]) instanceof IBaseQueryDefinition) {
                        this.transformExpressions(item, (IBaseQueryDefinition)query, null);
                    }
                    return queries;
                }
            }
            BaseQueryDefinition query = this.createQuery(item, parentQuery);
            this.transformExpressions(item, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        public Object visitListItem(ListItemDesign list, Object value) {
            BaseQueryDefinition query = this.createQuery(list, value);
            if (query == null) {
                this.handleListingBand(list.getHeader(), (IBaseQueryDefinition)query, true, null);
                this.handleListingBand(list.getFooter(), (IBaseQueryDefinition)query, true, null);
            } else {
                this.handleListingBand(list.getHeader(), (IBaseQueryDefinition)query, true, null);
                SlotHandle groupsSlot = ((ListHandle)list.getHandle()).getGroups();
                int i = 0;
                while (i < list.getGroupCount()) {
                    this.handleListingGroup(list.getGroup(i), (GroupHandle)groupsSlot.get(i), query);
                    ++i;
                }
                BandDesign detail = list.getDetail();
                if (detail == null || detail.getContentCount() == 0) {
                    query.setUsesDetails(false);
                }
                this.handleListingBand(detail, (IBaseQueryDefinition)query, false, null);
                this.handleListingBand(list.getFooter(), (IBaseQueryDefinition)query, true, null);
            }
            this.transformExpressions(list, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        public Object visitTextItem(TextItemDesign text, Object value) {
            BaseQueryDefinition query = this.createQuery(text, value);
            HashMap exprs = text.getExpressions();
            if (exprs != null) {
                Iterator ite = exprs.entrySet().iterator();
                while (ite.hasNext()) {
                    Map.Entry entry = ite.next();
                    if (!$assertionsDisabled && !(entry.getValue() instanceof String)) {
                        throw new AssertionError();
                    }
                    String newExpr = this.transformExpression(entry.getValue().toString(), (IBaseQueryDefinition)query, null);
                    entry.setValue(newExpr);
                }
            }
            this.transformExpressions(text, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        public void handleColumn(ColumnDesign column, IBaseQueryDefinition query) {
            this.transformColumnExpressions(column, query, null);
        }

        public Object visitTableItem(TableItemDesign table, Object value) {
            BaseQueryDefinition query = this.createQuery(table, value);
            if (query == null) {
                this.handleListingBand(table.getHeader(), (IBaseQueryDefinition)query, true, null);
                this.handleListingBand(table.getFooter(), (IBaseQueryDefinition)query, true, null);
            } else {
                int i = 0;
                while (i < table.getColumnCount()) {
                    this.handleColumn(table.getColumn(i), (IBaseQueryDefinition)query);
                    ++i;
                }
                this.handleListingBand(table.getHeader(), (IBaseQueryDefinition)query, true, null);
                SlotHandle groupsSlot = ((TableHandle)table.getHandle()).getGroups();
                int i2 = 0;
                while (i2 < table.getGroupCount()) {
                    this.handleListingGroup(table.getGroup(i2), (GroupHandle)groupsSlot.get(i2), query);
                    ++i2;
                }
                BandDesign detail = table.getDetail();
                if (detail == null || detail.getContentCount() == 0) {
                    query.setUsesDetails(false);
                }
                this.handleListingBand(detail, (IBaseQueryDefinition)query, false, null);
                this.handleListingBand(table.getFooter(), (IBaseQueryDefinition)query, true, null);
            }
            this.transformExpressions(table, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        public Object visitDynamicTextItem(DynamicTextItemDesign dynamicText, Object value) {
            BaseQueryDefinition query = this.createQuery(dynamicText, value);
            String newContent = this.transformExpression(dynamicText.getContent(), (IBaseQueryDefinition)query, null);
            dynamicText.setContent(newContent);
            this.transformExpressions(dynamicText, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        public Object visitDataItem(DataItemDesign data, Object value) {
            BaseQueryDefinition query = this.createQuery(data, value);
            this.transformExpressions(data, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        public void handleListingBand(BandDesign band, IBaseQueryDefinition query, boolean onGroup, IGroupDefinition groupDefn) {
            if (band != null) {
                ArrayList subQueries = (ArrayList)((ArrayList)query.getSubqueries()).clone();
                int i = 0;
                while (i < band.getContentCount()) {
                    ReportQueryBuilder.this.build((IDataQueryDefinition)query, band.getContent(i));
                    ++i;
                }
                ArrayList subQueriesChanged = (ArrayList)query.getSubqueries();
                if (subQueriesChanged != null) {
                    int i2 = 0;
                    while (i2 < subQueriesChanged.size()) {
                        SubqueryDefinition subQuery = (SubqueryDefinition)subQueriesChanged.get(i2);
                        if (!subQueries.contains(subQuery) && subQuery instanceof SubqueryDefinition) {
                            subQuery.setApplyOnGroupFlag(onGroup);
                            if (groupDefn != null) {
                                subQueriesChanged.remove(subQuery);
                                groupDefn.getSubqueries().add(subQuery);
                                --i2;
                            }
                        }
                        ++i2;
                    }
                }
            }
        }

        protected void handleListingGroup(GroupDesign group, GroupHandle handle, Object value) {
            if (!$assertionsDisabled && !(value instanceof IBaseQueryDefinition)) {
                throw new AssertionError();
            }
            IBaseQueryDefinition query = (IBaseQueryDefinition)value;
            IGroupDefinition groupDefn = this.handleGroup(group, handle, query);
            this.transformExpressions(group, query, groupDefn.getName());
            this.handleListingBand(group.getHeader(), query, true, groupDefn);
            this.handleListingBand(group.getFooter(), query, true, groupDefn);
        }

        protected IGroupDefinition handleGroup(GroupDesign group, GroupHandle handle, IBaseQueryDefinition query) {
            GroupDefinition groupDefn = new GroupDefinition(group.getName());
            groupDefn.setKeyExpression(handle.getKeyExpr());
            String interval = handle.getInterval();
            if (interval != null) {
                groupDefn.setInterval(this.parseInterval(interval));
            }
            groupDefn.setIntervalRange(handle.getIntervalRange());
            groupDefn.setIntervalStart((Object)handle.getIntervalBase());
            String direction = handle.getSortDirection();
            if (direction != null) {
                groupDefn.setSortDirection(this.parseSortDirection(direction));
            }
            groupDefn.getSorts().addAll(this.createSorts(handle));
            groupDefn.getFilters().addAll(this.createFilters(handle));
            query.getGroups().add(groupDefn);
            return groupDefn;
        }

        public Object visitRow(RowDesign row, Object value) {
            BaseQueryDefinition query = this.createQuery(row, value);
            int i = 0;
            while (i < row.getCellCount()) {
                CellDesign cell = row.getCell(i);
                ReportQueryBuilder.this.build((IDataQueryDefinition)query, cell);
                ++i;
            }
            this.transformExpressions(row, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        public Object visitCell(CellDesign cell, Object value) {
            BaseQueryDefinition query = this.createQuery(cell, value);
            int i = 0;
            while (i < cell.getContentCount()) {
                ReportQueryBuilder.this.build((IDataQueryDefinition)query, cell.getContent(i));
                ++i;
            }
            this.transformExpressions(cell, (IBaseQueryDefinition)query);
            return this.getResultQuery((IBaseQueryDefinition)query, value);
        }

        private IBaseQueryDefinition[] getResultQuery(IBaseQueryDefinition query, Object parent) {
            if (query != null && query != parent && !query.cacheQueryResults()) {
                return new IBaseQueryDefinition[]{query};
            }
            return null;
        }

        protected void addColumBinding(IBaseQueryDefinition transfer, ComputedColumnHandle columnBinding) {
            String name = columnBinding.getName();
            String expr = columnBinding.getExpression();
            String type = columnBinding.getDataType();
            int dbType = ModelDteApiAdapter.toDteDataType(type);
            ScriptExpression dbExpr = new ScriptExpression(expr, dbType);
            if (columnBinding.getAggregateOn() != null) {
                dbExpr.setGroupName(columnBinding.getAggregateOn());
            }
            Binding binding = new Binding(name, (IBaseExpression)dbExpr);
            try {
                Iterator arguments;
                String filter;
                if (columnBinding.getAggregateOn() != null) {
                    binding.addAggregateOn(columnBinding.getAggregateOn());
                }
                if (columnBinding.getAggregateFunction() != null) {
                    binding.setAggrFunction(columnBinding.getAggregateFunction());
                }
                if ((filter = columnBinding.getFilterExpression()) != null) {
                    binding.setFilter((IBaseExpression)new ScriptExpression(filter));
                }
                if ((arguments = columnBinding.argumentsIterator()) != null) {
                    while (arguments.hasNext()) {
                        AggregationArgumentHandle argumentHandle = (AggregationArgumentHandle)arguments.next();
                        String argument = argumentHandle.getValue();
                        if (argument == null) continue;
                        binding.addArgument((IBaseExpression)new ScriptExpression(argument));
                    }
                }
                transfer.addBinding((IBinding)binding);
            }
            catch (DataException ex) {
                ReportQueryBuilder.this.context.addException((BirtException)((Object)ex));
            }
        }

        protected BaseQueryDefinition createQuery(ReportItemDesign item, Object value) {
            ReportItemHandle itemHandle;
            ReportItemHandle referenceHandle;
            DesignElementHandle handle = item.getHandle();
            if (handle instanceof ReportItemHandle && (referenceHandle = (itemHandle = (ReportItemHandle)handle).getDataBindingReference()) != null) {
                IDataQueryDefinition[] queries = ReportQueryBuilder.this.report.getQueryByReportHandle((ReportElementHandle)referenceHandle);
                if (queries != null && queries.length > 0) {
                    ReportQueryBuilder.this.registerQueryToHandle(item, queries);
                    int i = 0;
                    while (i < queries.length) {
                        IDataQueryDefinition referenceQuery = queries[i];
                        if (referenceQuery instanceof BaseQueryDefinition) {
                            ((BaseQueryDefinition)referenceQuery).setCacheQueryResults(true);
                        }
                        ++i;
                    }
                    if ((BaseQueryDefinition)queries[0] instanceof BaseQueryDefinition) {
                        return (BaseQueryDefinition)queries[0];
                    }
                } else {
                    throw new IllegalStateException("forward reference dataset");
                }
            }
            BaseQueryDefinition parentQuery = null;
            if (value instanceof BaseQueryDefinition) {
                parentQuery = (BaseQueryDefinition)value;
            }
            if (!(handle instanceof ReportItemHandle)) {
                if (!this.needQuery(item, (IBaseQueryDefinition)parentQuery)) {
                    return parentQuery;
                }
                return this.createSubQuery(item, parentQuery);
            }
            ReportItemHandle designHandle = (ReportItemHandle)handle;
            DataSetHandle dsHandle = designHandle.getDataSet();
            if (dsHandle == null) {
                String dsName = (String)designHandle.getProperty("dataSet");
                if (dsName != null && dsName.length() > 0) {
                    ReportQueryBuilder.this.context.addException(item.getHandle(), new EngineException("Error.UndefinedDatasetError", dsName));
                }
                if (!this.needQuery(item, (IBaseQueryDefinition)parentQuery)) {
                    return parentQuery;
                }
                if (value instanceof CubeQueryDefinition) {
                    return null;
                }
                return this.createSubQuery(item, parentQuery);
            }
            QueryDefinition query = new QueryDefinition(parentQuery);
            query.setDataSetName(dsHandle.getQualifiedName());
            query.getInputParamBindings().addAll(this.createParamBindings(designHandle.paramBindingsIterator()));
            query.setMaxRows(ReportQueryBuilder.this.maxRows);
            Iterator iter = designHandle.columnBindingsIterator();
            while (iter.hasNext()) {
                ComputedColumnHandle binding = (ComputedColumnHandle)iter.next();
                this.addColumBinding((IBaseQueryDefinition)query, binding);
            }
            this.addSortAndFilter(item, (BaseQueryDefinition)query);
            return query;
        }

        protected BaseQueryDefinition createSubQuery(ReportItemDesign item, BaseQueryDefinition parentQuery) {
            QueryDefinition query = null;
            if (parentQuery == null) {
                query = new QueryDefinition(null);
            } else {
                String name = String.valueOf(item.getID());
                query = new SubqueryDefinition(name, (IBaseQueryDefinition)parentQuery);
                parentQuery.getSubqueries().add(query);
            }
            query.setMaxRows(ReportQueryBuilder.this.maxRows);
            if (item.getHandle() instanceof ReportItemHandle) {
                ReportItemHandle designHandle = (ReportItemHandle)item.getHandle();
                Iterator iter = designHandle.columnBindingsIterator();
                while (iter.hasNext()) {
                    ComputedColumnHandle binding = (ComputedColumnHandle)iter.next();
                    this.addColumBinding((IBaseQueryDefinition)query, binding);
                }
            }
            this.addSortAndFilter(item, (BaseQueryDefinition)query);
            return query;
        }

        private boolean needQuery(ReportItemDesign item, IBaseQueryDefinition query) {
            DesignElementHandle handle = item.getHandle();
            if (handle instanceof ReportItemHandle) {
                ReportItemHandle designHandle = (ReportItemHandle)item.getHandle();
                if (designHandle.columnBindingsIterator().hasNext()) {
                    return true;
                }
                if (designHandle instanceof ListingHandle) {
                    return true;
                }
                if (designHandle instanceof ExtendedItemHandle) {
                    ExtendedItemHandle extHandle = (ExtendedItemHandle)designHandle;
                    return ExtensionManager.getInstance().getAllRows(extHandle.getExtensionName());
                }
            }
            HighlightDesign highlight = item.getHighlight();
            return query == null && highlight != null && highlight.getRuleCount() > 0;
        }

        private void addSortAndFilter(ReportItemDesign item, BaseQueryDefinition query) {
            if (item instanceof ListingDesign) {
                query.getSorts().addAll(this.createSorts((ListingDesign)item));
                query.getFilters().addAll(this.createFilters((ListingDesign)item));
            } else if (item instanceof ExtendedItemDesign) {
                query.getFilters().addAll(this.createFilters((ExtendedItemDesign)item));
            }
        }

        protected String getLocalizedString(String resourceKey, String text) {
            if (resourceKey == null) {
                return text;
            }
            String ret = ReportQueryBuilder.this.report.getReportDesign().getMessage(resourceKey, ReportQueryBuilder.this.context.getLocale());
            if (ret == null) {
                logger.log(Level.SEVERE, "get resource error, resource key:" + resourceKey + " Locale:" + ReportQueryBuilder.this.context.getLocale().toString());
                return text;
            }
            return ret;
        }

        private IFilterDefinition createFilter(FilterConditionHandle handle) {
            String filterExpr = handle.getExpr();
            if (filterExpr == null || filterExpr.length() == 0) {
                return null;
            }
            String filterOpr = handle.getOperator();
            if (filterOpr == null || filterOpr.length() == 0) {
                return new FilterDefinition((IBaseExpression)new ScriptExpression(filterExpr));
            }
            String column = filterExpr;
            int dteOpr = ModelDteApiAdapter.toDteFilterOperator(filterOpr);
            String operand1 = handle.getValue1();
            String operand2 = handle.getValue2();
            return new FilterDefinition((IBaseExpression)new ConditionalExpression(column, dteOpr, operand1, operand2));
        }

        private ArrayList createFilters(Iterator iter) {
            ArrayList<IFilterDefinition> filters = new ArrayList<IFilterDefinition>();
            if (iter != null) {
                while (iter.hasNext()) {
                    FilterConditionHandle filterHandle = (FilterConditionHandle)iter.next();
                    IFilterDefinition filter = this.createFilter(filterHandle);
                    filters.add(filter);
                }
            }
            return filters;
        }

        public ArrayList createFilters(ListingDesign listing) {
            return this.createFilters(((ListingHandle)listing.getHandle()).filtersIterator());
        }

        public ArrayList createFilters(DataSetHandle dataSet) {
            return this.createFilters(dataSet.filtersIterator());
        }

        public ArrayList createFilters(GroupHandle group) {
            return this.createFilters(group.filtersIterator());
        }

        public ArrayList createFilters(ExtendedItemDesign extendedItem) {
            return this.createFilters(((ExtendedItemHandle)extendedItem.getHandle()).filtersIterator());
        }

        private ISortDefinition createSort(SortKeyHandle handle) {
            SortDefinition sort = new SortDefinition();
            sort.setExpression(handle.getKey());
            sort.setSortDirection(handle.getDirection().equals("asc") ? 0 : 1);
            return sort;
        }

        private ArrayList createSorts(Iterator iter) {
            ArrayList<ISortDefinition> sorts = new ArrayList<ISortDefinition>();
            if (iter != null) {
                while (iter.hasNext()) {
                    SortKeyHandle handle = (SortKeyHandle)iter.next();
                    sorts.add(this.createSort(handle));
                }
            }
            return sorts;
        }

        protected ArrayList createSorts(ListingDesign listing) {
            return this.createSorts(((ListingHandle)listing.getHandle()).sortsIterator());
        }

        protected ArrayList createSorts(GroupHandle group) {
            return this.createSorts(group.sortsIterator());
        }

        protected IInputParameterBinding createParamBinding(ParamBindingHandle handle) {
            if (handle.getExpression() == null) {
                return null;
            }
            ScriptExpression expr = new ScriptExpression(handle.getExpression());
            return new InputParameterBinding(handle.getParamName(), (IBaseExpression)expr);
        }

        protected ArrayList createParamBindings(Iterator iter) {
            ArrayList<IInputParameterBinding> list = new ArrayList<IInputParameterBinding>();
            if (iter != null) {
                while (iter.hasNext()) {
                    ParamBindingHandle modelParamBinding = (ParamBindingHandle)iter.next();
                    IInputParameterBinding binding = this.createParamBinding(modelParamBinding);
                    if (binding == null) continue;
                    list.add(binding);
                }
            }
            return list;
        }

        protected int parseInterval(String interval) {
            if ("year".equals(interval)) {
                return 1;
            }
            if ("month".equals(interval)) {
                return 2;
            }
            if ("week".equals(interval)) {
                return 4;
            }
            if ("quarter".equals(interval)) {
                return 3;
            }
            if ("day".equals(interval)) {
                return 5;
            }
            if ("hour".equals(interval)) {
                return 6;
            }
            if ("minute".equals(interval)) {
                return 7;
            }
            if ("prefix".equals(interval)) {
                return 100;
            }
            if ("second".equals(interval)) {
                return 8;
            }
            if ("interval".equals(interval)) {
                return 99;
            }
            return 0;
        }

        protected int parseSortDirection(String direction) {
            if ("asc".equals(direction)) {
                return 0;
            }
            if ("desc".equals(direction)) {
                return 1;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }

        private void transformExpressions(ReportItemDesign item, IBaseQueryDefinition query, String groupName) {
            if (query != null) {
                ITotalExprBindings totalExpressionBindings = this.getNewExpressionBindings(item, query, groupName);
                this.addNewColumnBindings(query, totalExpressionBindings);
                this.replaceOldExpressions(item, totalExpressionBindings);
            }
        }

        protected String transformExpression(String expr, IBaseQueryDefinition query, String groupName) {
            if (expr == null) {
                return null;
            }
            if (query != null) {
                ArrayList<String> expressions = new ArrayList<String>();
                expressions.add(expr);
                ITotalExprBindings totalExpressionBinding = null;
                try {
                    totalExpressionBinding = ReportQueryBuilder.this.expressionUtil.prepareTotalExpressions(expressions, groupName);
                }
                catch (EngineException ex) {
                    ReportQueryBuilder.this.context.addException(ex);
                }
                this.addNewColumnBindings(query, totalExpressionBinding);
                List newExpressions = totalExpressionBinding.getNewExpression();
                return (String)newExpressions.get(0);
            }
            return expr;
        }

        private void transformColumnExpressions(ColumnDesign column, IBaseQueryDefinition query, String groupName) {
            int i;
            HighlightDesign highlights;
            if (query == null) {
                return;
            }
            ArrayList<String> expressions = new ArrayList<String>();
            VisibilityDesign visibilities = column.getVisibility();
            if (visibilities != null) {
                int i2 = 0;
                while (i2 < visibilities.count()) {
                    expressions.add(visibilities.getRule(i2).getExpression());
                    ++i2;
                }
            }
            if ((highlights = column.getHighlight()) != null) {
                int i3 = 0;
                while (i3 < highlights.getRuleCount()) {
                    HighlightRuleDesign rule = highlights.getRule(i3);
                    if (rule != null) {
                        expressions.add((String)ReportQueryBuilder.this.expressionUtil.createConditionalExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1(), rule.getValue2()));
                    }
                    ++i3;
                }
            }
            ITotalExprBindings totalExpressionBindings = null;
            try {
                totalExpressionBindings = ReportQueryBuilder.this.expressionUtil.prepareTotalExpressions(expressions, groupName);
            }
            catch (EngineException ex) {
                ReportQueryBuilder.this.context.addException(ex);
            }
            this.addNewColumnBindings(query, totalExpressionBindings);
            int expressionIndex = 0;
            List newExpressions = totalExpressionBindings.getNewExpression();
            if (visibilities != null) {
                i = 0;
                while (i < visibilities.count()) {
                    visibilities.getRule(i).setExpression((String)newExpressions.get(expressionIndex++));
                    ++i;
                }
            }
            if (highlights != null) {
                i = 0;
                while (i < highlights.getRuleCount()) {
                    highlights.getRule(i).setConditionExpr((String)newExpressions.get(expressionIndex++));
                    ++i;
                }
            }
        }

        private void replaceOldExpressions(ReportItemDesign item, ITotalExprBindings totalExpressionBindings) {
            ActionDesign action;
            Map namedExpressions;
            VisibilityDesign visibilities;
            MapDesign maps;
            int expressionIndex = 0;
            List newExpressions = totalExpressionBindings.getNewExpression();
            item.setTOC((String)newExpressions.get(expressionIndex++));
            item.setBookmark((String)newExpressions.get(expressionIndex++));
            item.setOnCreate((String)newExpressions.get(expressionIndex++));
            item.setOnRender((String)newExpressions.get(expressionIndex++));
            item.setOnPageBreak((String)newExpressions.get(expressionIndex++));
            HighlightDesign highlights = item.getHighlight();
            if (highlights != null) {
                int i = 0;
                while (i < highlights.getRuleCount()) {
                    highlights.getRule(i).setConditionExpr((String)newExpressions.get(expressionIndex++));
                    ++i;
                }
            }
            if ((maps = item.getMap()) != null) {
                int i = 0;
                while (i < maps.getRuleCount()) {
                    maps.getRule(i).setConditionExpr((String)newExpressions.get(expressionIndex++));
                    ++i;
                }
            }
            if ((visibilities = item.getVisibility()) != null) {
                int i = 0;
                while (i < visibilities.count()) {
                    visibilities.getRule(i).setExpression((String)newExpressions.get(expressionIndex++));
                    ++i;
                }
            }
            if ((namedExpressions = item.getNamedExpressions()) != null) {
                Set exprs = namedExpressions.entrySet();
                Iterator exprIter = exprs.iterator();
                Map.Entry entry = null;
                while (exprIter.hasNext()) {
                    entry = (Map.Entry)exprIter.next();
                    entry.setValue((String)newExpressions.get(expressionIndex++));
                }
            }
            if ((action = item.getAction()) != null) {
                switch (action.getActionType()) {
                    case 2: {
                        action.setBookmark((String)newExpressions.get(expressionIndex++));
                        break;
                    }
                    case 3: {
                        DrillThroughActionDesign drillThrough = action.getDrillThrough();
                        if (drillThrough == null) break;
                        drillThrough.setBookmark((String)newExpressions.get(expressionIndex++));
                        if (drillThrough.getParameters() == null) break;
                        Iterator ite = drillThrough.getParameters().entrySet().iterator();
                        while (ite.hasNext()) {
                            Map.Entry entry = ite.next();
                            entry.setValue((String)newExpressions.get(expressionIndex++));
                        }
                        break;
                    }
                    case 1: {
                        action.setHyperlink((String)newExpressions.get(expressionIndex++));
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
        }

        private ITotalExprBindings getNewExpressionBindings(ReportItemDesign item, IBaseQueryDefinition query, String groupName) {
            ActionDesign action;
            Map namedExpressions;
            VisibilityDesign visibilities;
            MapDesign maps;
            ArrayList<String> expressions = new ArrayList<String>();
            expressions.add(item.getTOC());
            expressions.add(item.getBookmark());
            expressions.add(item.getOnCreate());
            expressions.add(item.getOnRender());
            expressions.add(item.getOnPageBreak());
            HighlightDesign highlights = item.getHighlight();
            if (highlights != null) {
                int i = 0;
                while (i < highlights.getRuleCount()) {
                    HighlightRuleDesign rule = highlights.getRule(i);
                    if (rule != null) {
                        expressions.add((String)ReportQueryBuilder.this.expressionUtil.createConditionalExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1(), rule.getValue2()));
                    }
                    ++i;
                }
            }
            if ((maps = item.getMap()) != null) {
                int i = 0;
                while (i < maps.getRuleCount()) {
                    MapRuleDesign rule = maps.getRule(i);
                    if (rule != null) {
                        expressions.add((String)ReportQueryBuilder.this.expressionUtil.createConditionalExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1(), rule.getValue2()));
                    }
                    ++i;
                }
            }
            if ((visibilities = item.getVisibility()) != null) {
                int i = 0;
                while (i < visibilities.count()) {
                    expressions.add(visibilities.getRule(i).getExpression());
                    ++i;
                }
            }
            if ((namedExpressions = item.getNamedExpressions()) != null) {
                Set exprs = namedExpressions.entrySet();
                Iterator exprIter = exprs.iterator();
                Map.Entry entry = null;
                while (exprIter.hasNext()) {
                    entry = (Map.Entry)exprIter.next();
                    expressions.add((String)entry.getValue());
                }
            }
            if ((action = item.getAction()) != null) {
                switch (action.getActionType()) {
                    case 2: {
                        expressions.add(action.getBookmark());
                        break;
                    }
                    case 3: {
                        DrillThroughActionDesign drillThrough = action.getDrillThrough();
                        if (drillThrough == null) break;
                        expressions.add(drillThrough.getBookmark());
                        if (drillThrough.getParameters() == null) break;
                        Iterator ite = drillThrough.getParameters().entrySet().iterator();
                        while (ite.hasNext()) {
                            Map.Entry entry = ite.next();
                            expressions.add((String)entry.getValue());
                        }
                        break;
                    }
                    case 1: {
                        expressions.add(action.getHyperlink());
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
            ITotalExprBindings totalExpressionBindings = null;
            try {
                totalExpressionBindings = ReportQueryBuilder.this.expressionUtil.prepareTotalExpressions(expressions, groupName);
            }
            catch (EngineException ex) {
                ReportQueryBuilder.this.context.addException(ex);
            }
            return totalExpressionBindings;
        }

        private void addNewColumnBindings(IBaseQueryDefinition query, ITotalExprBindings totalExpressionBindings) {
            IBinding[] bindings = totalExpressionBindings.getColumnBindings();
            if (bindings != null) {
                try {
                    int i = 0;
                    while (i < bindings.length) {
                        query.addBinding(bindings[i]);
                        ++i;
                    }
                }
                catch (DataException e) {
                    ReportQueryBuilder.this.context.addException((BirtException)((Object)e));
                }
            }
        }

        private void transformExpressions(ReportItemDesign item, IBaseQueryDefinition query) {
            if (query != null) {
                this.transformExpressions(item, query, null);
            }
        }
    }
}

