/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.parser.EngineIRVisitor;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.w3c.dom.css.CSSStyleDeclaration;

public class Report {
    protected ReportDesignHandle reportDesign;
    protected ArrayList styles = new ArrayList();
    protected HashMap styleTable = new HashMap();
    protected String rootStyleName;
    protected ArrayList queries = new ArrayList();
    protected HashMap queryIDs = new HashMap();
    protected HashMap resultMetaData = new HashMap();
    protected PageSetupDesign pageSetup = new PageSetupDesign();
    protected ArrayList contents = new ArrayList();
    protected Map namedExpressions;
    protected Map mapReportItemIDtoInstance;
    protected HashMap mapReportItemToQuery;
    protected HashMap mapQueryToReportElementHandle;
    protected CSSEngine cssEngine = new BIRTCSSEngine();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.ir.Report");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CSSEngine getCSSEngine() {
        return this.cssEngine;
    }

    public HashMap getReportItemToQueryMap() {
        if (this.mapReportItemToQuery == null) {
            this.mapReportItemToQuery = new HashMap();
        }
        return this.mapReportItemToQuery;
    }

    public void setQueryToReportHandle(ReportElementHandle handle, IDataQueryDefinition[] queries) {
        if (this.mapQueryToReportElementHandle == null) {
            this.mapQueryToReportElementHandle = new HashMap();
        }
        this.mapQueryToReportElementHandle.put(handle, queries);
    }

    public IDataQueryDefinition[] getQueryByReportHandle(ReportElementHandle handle) {
        if (this.mapQueryToReportElementHandle != null) {
            return (IDataQueryDefinition[])this.mapQueryToReportElementHandle.get(handle);
        }
        return null;
    }

    public void setReportItemInstanceID(long id, ReportElementDesign rptElement) {
        if (this.mapReportItemIDtoInstance == null) {
            this.mapReportItemIDtoInstance = new HashMap();
        }
        this.mapReportItemIDtoInstance.put(new Long(id), rptElement);
    }

    public ReportElementDesign getReportItemByID(long id) {
        if (!$assertionsDisabled && this.mapReportItemIDtoInstance == null) {
            throw new AssertionError();
        }
        return (ReportElementDesign)this.mapReportItemIDtoInstance.get(new Long(id));
    }

    public Map getNamedExpressions() {
        if (this.namedExpressions == null) {
            this.namedExpressions = new HashMap();
        }
        return this.namedExpressions;
    }

    public void setPageSetup(PageSetupDesign pageSetup) {
        this.pageSetup = pageSetup;
    }

    public PageSetupDesign getPageSetup() {
        return this.pageSetup;
    }

    public int getContentCount() {
        return this.contents.size();
    }

    public ReportItemDesign getContent(int index) {
        if (!($assertionsDisabled || index >= 0 && index < this.contents.size())) {
            throw new AssertionError();
        }
        return (ReportItemDesign)this.contents.get(index);
    }

    public void addContent(ReportItemDesign item) {
        this.contents.add(item);
    }

    public Map getStyles() {
        return this.styleTable;
    }

    public void addStyle(String name, CSSStyleDeclaration style) {
        if (!$assertionsDisabled && style == null) {
            throw new AssertionError();
        }
        this.styles.add(style);
        this.styleTable.put(name, style);
    }

    public IStyle findStyle(String name) {
        if (name == null) {
            return null;
        }
        return (IStyle)this.styleTable.get(name);
    }

    public MasterPageDesign findMasterPage(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.pageSetup.findMasterPage(name);
    }

    public ReportDesignHandle getReportDesign() {
        return this.reportDesign;
    }

    public void setReportDesign(ReportDesignHandle reportDesign) {
        this.reportDesign = reportDesign;
    }

    public ArrayList getQueries() {
        return this.queries;
    }

    public HashMap getQueryIDs() {
        return this.queryIDs;
    }

    public HashMap getResultMetaData() {
        return this.resultMetaData;
    }

    public String getRootStyleName() {
        return this.rootStyleName;
    }

    public void setRootStyleName(String rootStyleName) {
        this.rootStyleName = rootStyleName;
    }

    public List getErrors() {
        return this.reportDesign.getErrorList();
    }

    public ReportItemDesign findDesign(ReportElementHandle handle) {
        ReportElementDesign elementDesign = this.getReportItemByID(handle.getID());
        if (elementDesign != null) {
            return (ReportItemDesign)elementDesign;
        }
        return new EngineIRVisitor(this.reportDesign).translate(handle, this);
    }
}

