/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.text;

import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;

public class Chunk {
    private String text;
    private int offset;
    private FontInfo fontInfo;
    private int baseLevel;
    private int runDirection;
    public static final Chunk HARD_LINE_BREAK = new Chunk("\n");

    public Chunk(String text) {
        this.text = text;
        this.fontInfo = null;
        this.baseLevel = -2;
        this.runDirection = 0;
    }

    public Chunk(String text, int offset, FontInfo fi) {
        this.text = text;
        this.offset = offset;
        this.fontInfo = fi;
        this.baseLevel = -2;
        this.runDirection = 0;
    }

    public Chunk(Chunk chunk) {
        this.text = chunk.text;
        this.fontInfo = chunk.fontInfo;
        this.baseLevel = chunk.baseLevel;
        this.runDirection = chunk.runDirection;
    }

    public Chunk(String text, int offset, int baseLevel, int runDirection) {
        this.text = text;
        this.offset = offset;
        this.fontInfo = null;
        this.baseLevel = baseLevel;
        this.runDirection = runDirection;
    }

    public Chunk(String text, int offset, int baseLevel, int runDirection, FontInfo fi) {
        this.text = text;
        this.offset = offset;
        this.fontInfo = null;
        this.baseLevel = baseLevel;
        this.runDirection = runDirection;
        this.fontInfo = fi;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setFontInfo(FontInfo fi) {
        this.fontInfo = fi;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setBaseLevel(int baseLevel) {
        this.baseLevel = baseLevel;
    }

    public int getBaseLevel() {
        return this.baseLevel;
    }

    public void setRunDirection(int runDirection) {
        this.runDirection = runDirection;
    }

    public int getRunDirection() {
        return this.runDirection;
    }
}

