/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cosmos.dc.cmdbf.services.provisional.query.transform.input.artifacts.BaseProperty;

public class StringProperty
extends BaseProperty {
    private String value;

    public StringProperty(String value) {
        this.value = value;
    }

    public boolean contains(String str, boolean caseSensitive) {
        String operand;
        String propertyValue = caseSensitive ? this.value : this.value.toUpperCase();
        String string = operand = caseSensitive ? str : str.toUpperCase();
        return propertyValue.indexOf(operand) >= 0;
    }

    public boolean equals(Object o, boolean caseSensitive) {
        if (!(o instanceof String)) {
            return false;
        }
        return caseSensitive ? this.value.equals((String)o) : this.value.equalsIgnoreCase((String)o);
    }

    public boolean greater(Object o) {
        if (!(o instanceof String)) {
            return false;
        }
        return this.value.compareTo((String)o) > 0;
    }

    public boolean less(Object o) {
        if (!(o instanceof String)) {
            return false;
        }
        return this.value.compareTo((String)o) < 0;
    }

    public boolean like(String str, boolean caseSensitive) throws IllegalArgumentException {
        if (str == null) {
            return false;
        }
        int currentInx = 0;
        int backslashInx = 0;
        int strLength = str.length();
        while (currentInx < strLength && (backslashInx = str.indexOf(92, currentInx)) > 0) {
            if (backslashInx + 1 >= strLength) {
                throw new IllegalArgumentException("Illegal character is escaped at index " + backslashInx);
            }
            char escapedChar = str.charAt(backslashInx + 1);
            if (escapedChar != '%' && escapedChar != '_' && escapedChar != '\\') {
                throw new IllegalArgumentException("Illegal character is escaped at index " + backslashInx);
            }
            currentInx = backslashInx + 1;
        }
        String[] RESERVED_CHARACTERS = new String[]{"\\[", "\\]", "\\-", "\\^", "\\&", "\\.", "\\{", "\\}", "\\$", "\\?", "\\*", "\\+", "\\|"};
        int i = 0;
        while (i < RESERVED_CHARACTERS.length) {
            str = str.replaceAll(RESERVED_CHARACTERS[i], "\\" + RESERVED_CHARACTERS[i]);
            ++i;
        }
        currentInx = 0;
        StringBuffer normalizedPattern = new StringBuffer();
        strLength = str.length();
        while (currentInx < strLength) {
            char currentChar = str.charAt(currentInx);
            switch (currentChar) {
                case '%': {
                    normalizedPattern.append(".*");
                    break;
                }
                case '_': {
                    normalizedPattern.append('.');
                    break;
                }
                default: {
                    normalizedPattern.append(currentChar);
                }
            }
            ++currentInx;
        }
        String propertyValue = caseSensitive ? this.value : this.value.toUpperCase();
        String patternString = caseSensitive ? normalizedPattern.toString() : normalizedPattern.toString().toUpperCase();
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(propertyValue);
        return matcher.matches();
    }
}

