/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.data.LazyLoadStore");
dojo.require("dojo.data.ItemFileWriteStore");

dojo.declare("cosmos.data.LazyLoadStore", dojo.data.ItemFileWriteStore, {
	loadItem: function(/* object */ keywordArgs){
		//	summary: 
		//		See dojo.data.api.Read.loadItem()
		
		var item = keywordArgs.item;
		for (i in item) {
			if (!dojo.isArray(item[i])) {
				item[i] = [item[i]];
			}
		}
		newIdentity = this._arrayOfAllItems.length;		
		item[this._storeRefPropName] = this;		
		item[this._itemNumPropName] = newIdentity;
		this._itemsByIdentity[newIdentity] = item;
		this._arrayOfAllItems.push(item);		
		//Reset the item in the reference.  
		//Done processing!  Call the onItem, if any.
		if(keywordArgs.onItem){
			var scope = keywordArgs.scope ? keywordArgs.scope : dojo.global;
			keywordArgs.onItem.call(scope, item);
		}
		
	}
});