/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.utility.UIContext");
dojo.require("cosmos.data.LazyLoadStore");
dojo.require("dijit.Tree");
cosmos.utility.UIContext = function (href) {
	this.initialize = function(){
			//populate node
			dojo.xhrGet({
	  			    widgetStyle: this,
					url: "WidgetStyleJSON?href="+href,    
			        handleAs: "json",
			        handle: function(response, ioArgs){
			                //This function handles the response.
			                //Inside this function, the "this" variable
			                //will be the object used as the argument to the dojo.xhrGet() call.
			                if(response instanceof Error){
			                        if(response.dojoType == "cancel"){
			                                //The request was canceled by some other JavaScript code.
			                                console.debug("Request canceled.");
			                        }else if(response.dojoType == "timeout"){
			                                //The request took over 5 seconds to complete.
			                                console.debug("Request timed out.");
			                        }else{
			                                //Some other error happened.
			                                console.error(response);
			                        }
			                }else{
								    this.widgetStyle.setStyles(response);
			                }
			                //If you think there could be other callback handlers registered with this deferred, then
			                //return response to propagate the same response to other callback handlers. Otherwise,
			                //the error callbacks may be called in the success case.
			                return response;
			        }
			});
		console.debug("initializing context");				
	},
	this.setStyles = function(styles){
	   this.styles = styles;
	   dojo.publish("initializeWidget", [{context:this}]);	   
	}
	this.getStyles = function(){
	   return this.styles;
	},		
	this.storageInitalize = function(){
	},	
	this.getStyleProperties = function(className){		
		var style = this.getStyles()[className];
		if (typeof(style) != undefined)
			return dojo.clone(style);
		return style;
	},	
	this.createMenu = function(menuClass, sourceObject){
		var properties = this.getStyleProperties(menuClass);
		if (typeof(properties) == 'undefined') return null;
		if (typeof(properties.menuType) == 'undefined') return null;
		var menuType = properties.menuType;			 
		//see if the class ia a reference
//	   var exp = /\bref[(]([\w\s\d]+)[)]$/;
//       var reference =  exp.exec(menuType);
//       if (reference != null){
//       		menuClass = reference[1];
       		properties = this.getStyleProperties(menuType);
			if (typeof(properties) == 'undefined') return null;
			if (typeof(properties.clazz) == 'undefined') return null;
       		menuType = properties.clazz;
//   		}
		//see if the class is a reference
		var contextMenuFactory = null;
		properties.sourceObject = sourceObject;
		if (menuType){
			contextMenuFactory = eval("new "+menuType+"(properties)");
			contextMenuFactory.UIContext = this;
			
		}
		return contextMenuFactory;	
	},
	this._createWidget = function(widgetProperties, store, widgetCallback, cell){
       		if (store){
		        widgetProperties.store=new cosmos.data.LazyLoadStore({data:store});
	        }	
       		
		//create widget		
			widgetProperties.UIContext = this;
			var widget = eval("new "+widgetProperties.clazz+"(widgetProperties, cell)");
		//call callback to with widget			
			if (widgetCallback)
				widgetCallback(widget);
			return true;
	
	},
	this.submitQuery=function(keyArgs){
		var item = keyArgs.item;
		var query = keyArgs.queryObject
	    if (typeof(query[keyArgs.queryProp]) != 'undefined'){
			queryProperties = this.getStyleProperties(query[keyArgs.queryProp]);	
			if (typeof(queryProperties.clazz) != 'undefined'){		
			queryProperties.UIContext = this;
			 query = eval("new "+queryProperties.clazz+"(queryProperties)");
	
			if (typeof(query["queryHandler"]) != 'undefined'){
				//map input item to parameters of the query
				var postData = "";
				if (query.bindInput){
					query.bindInput(item, function(postData){
						var deferred = dojo.rawXhrPost({
						        url: query["queryHandler"],
						        handleAs: "json",
						        postData: postData,
						        render: query.render,        
						        onItem: keyArgs.onItem,
						        timeout: 5000, //Time in milliseconds
						        handle: function(response, ioArgs){
						                //This function handles the response.
						                //Inside this function, the "this" variable
						                //will be the object used as the argument to the dojo.xhrGet() call.
						                if(response instanceof Error){
						                        if(response.dojoType == "cancel"){
						                                //The request was canceled by some other JavaScript code.
						                                console.debug("Request canceled.");
						                        }else if(response.dojoType == "timeout"){
						                                //The request took over 5 seconds to complete.
						                                console.debug("Request timed out.");
						                        }else{
						                                //Some other error happened.
						                                console.error(response);
						                        }
						                }else{				
						                	//should only store the record contents so that we don't load the full graph response when loading the record viewer
						                	//check to see if we have to transform the response before sending the data to the call back method
						                	if (typeof(render) != 'undefined'){
					                        	this.onItem(render(response.items));
				                        	}
						                	else{
					                        	this.onItem(response.items);
				                        	}
						                }
						                //If you think there could be other callback handlers registered with this deferred, then
						                //return response to propagate the same response to other callback handlers. Otherwise,
						                //the error callbacks may be called in the success case.
						                return response;
						        }
						});		
					
					});
				}
			}
			}
		}
	},
	this.createWidget = function(widgetProperties, store, widgetCallback, cell){
		//check if properties is a reference
		var widgetClass = widgetProperties.clazz; 
		//see if the class ia a reference
	   var exp = /\bref[(]([\w\s\d]+)[)]$/;
       var reference =  exp.exec(widgetClass);
       if (reference != null){
       		widgetProperties = this.getStyleProperties(reference[1]);
			if (typeof(properties) == 'undefined') return false;
			if (typeof(properties.menuType) == 'undefined') return false;
			widgetClass = widgetProperties.clazz; 
   		}
		if (typeof(widgetClass) == 'undefined') return false;
		//check if properties has a handler
		if (typeof(widgetProperties.handler) != 'undefined'){
			var handler = widgetProperties.handler;
			if ((store != null) && (typeof(store.item) != 'undefined') && (typeof(store.item.object) != 'undefined'))
				handler += "?id=" + store.item.object;
			dojo.xhrGet({
	  			    UIContext: this,
	  			    widgetCallback: widgetCallback,
	  			    cell: cell,
	  			    widgetProperties: widgetProperties,
					url: handler,    
			        handleAs: "json",
			        handle: function(response, ioArgs){
			                //This function handles the response.
			                //Inside this function, the "this" variable
			                //will be the object used as the argument to the dojo.xhrGet() call.
			                if(response instanceof Error){
		                        if(response.dojoType == "cancel"){
			                                //The request was canceled by some other JavaScript code.
			                                console.debug("Request canceled.");
			                        }else if(response.dojoType == "timeout"){
			                                //The request took over 5 seconds to complete.
				                                console.debug("Request timed out.");
			                        }else{
			                                //Some other error happened.
		                                console.error(response);
			                        }
			                }else{
									this.UIContext._createWidget(this.widgetProperties, response, this.widgetCallback, this.cell)
			                }
			                //If you think there could be other callback handlers registered with this deferred, then
			                //return response to propagate the same response to other callback handlers. Otherwise,
			                //the error callbacks may be called in the success case.
			                return response;
			        }
				});
		}
		else{
			return this._createWidget(widgetProperties, store, widgetCallback, cell)
		}
			
		return true;
		
	},	
	this.href = href;	
 	dojo.subscribe("initialize", this, this.initialize);
 	return true;			
};

